/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items.misc;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.projectiles.LaserEntity;
import net.tardis.mod.items.misc.GenericLaserWeapon;
import net.tardis.mod.sounds.TSounds;

public class BlockGriefingLaserWeapon<T extends LivingEntity>
extends GenericLaserWeapon<T> {
    protected Class<? extends Block> blockToDestroy;

    public BlockGriefingLaserWeapon(T user, DamageSource source, float damage, Vector3d colour, float rayLength, SoundEvent sound) {
        super(user, source, rayLength, colour, rayLength, sound);
    }

    public BlockGriefingLaserWeapon(T user) {
        this(user, TDamageSources.causeTardisMobDamage("laser", user), 5.0f, new Vector3d(0.0, 1.0, 1.0), 1.0f, (SoundEvent)TSounds.LASER_GUN_FIRE.get());
    }

    @Override
    public void onHit(LaserEntity laserEntity, RayTraceResult result) {
        BlockPos pos = new BlockPos(result.func_216347_e());
        GameRules.BooleanValue shouldGrief = (GameRules.BooleanValue)laserEntity.field_70170_p.func_82736_K().func_223585_a(GameRules.field_223599_b);
        if (pos != null && shouldGrief.func_223572_a() && this.blockToDestroy != null && laserEntity.func_130014_f_().func_180495_p(pos).func_177230_c().getClass().equals(this.blockToDestroy)) {
            laserEntity.field_70170_p.func_230546_a_((Entity)laserEntity, this.source, null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, false, Explosion.Mode.DESTROY);
        }
    }

    public void setBlockToDestroy(Class<? extends Block> blockToDestroy) {
        this.blockToDestroy = blockToDestroy;
    }
}

