/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.BaseItem;

public class VortexManipItem
extends BaseItem {
    public VortexManipItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(TItemGroups.MAIN));
    }

    public static void syncCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.func_196082_o().func_197643_a(stack.getShareTag());
        }
    }

    public static void readCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.readShareTag(stack.func_196082_o());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack != ItemStack.field_190927_a && worldIn.field_72995_K && !player.func_184811_cZ().func_185141_a((Item)this)) {
            ClientHelper.openGUI(5, null);
            stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> cap.setOpen(true));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            if (entityIn instanceof PlayerEntity) {
                stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> cap.tick((PlayerEntity)entityIn));
            }
            if (worldIn.func_82737_E() % 20L == 0L) {
                VortexManipItem.syncCapability(stack);
            }
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> {
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
            if (Screen.func_231173_s_()) {
                tooltip.clear();
                tooltip.add(0, stack.func_200301_q());
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.vm.total_charge").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(cap.getClientTotalCurrentCharge())).func_240699_a_(TextFormatting.LIGHT_PURPLE).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS)));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.vm.battery_count").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(cap.getBatteries())).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
            }
            if (Screen.func_231172_r_()) {
                tooltip.clear();
                tooltip.add(0, stack.func_200301_q());
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_ARTRON_BATTERY_REQUIRED);
            }
        });
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(handler -> tag.func_218657_a("cap_sync", handler.serializeNBT()));
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("cap_sync")) {
            stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(handler -> handler.deserializeNBT((INBT)nbt.func_74775_l("cap_sync")));
        }
    }
}

