/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.misc.TooltipProviderItem;
import net.tardis.mod.properties.Prop;

public class TardisPartItem
extends TooltipProviderItem {
    protected TardisConstants.Part.PartType type;
    protected boolean requiredForFlight;
    protected boolean requiresRepair;
    protected TranslationTextComponent dependentItem;
    protected boolean isDisabled = false;

    public TardisPartItem(Item.Properties prop, TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair, TranslationTextComponent dependentItem, boolean isDisabled) {
        super(prop);
        this.type = type;
        this.requiredForFlight = requiredForFlight;
        this.requiresRepair = requiresRepair;
        this.dependentItem = dependentItem;
        this.isDisabled = isDisabled;
        this.setShowTooltips(true);
        this.setHasStatisticsTooltips(true);
        this.setHasDescriptionTooltips(true);
    }

    public TardisPartItem(Item.Properties prop, TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair, TranslationTextComponent dependentItem) {
        this(prop, type, requiredForFlight, requiresRepair, dependentItem, false);
    }

    public TardisPartItem(Item.Properties prop, TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair, boolean isDisabled) {
        this(prop, type, requiredForFlight, requiresRepair, new TranslationTextComponent(""), isDisabled);
    }

    public TardisPartItem(Item.Properties prop, TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair) {
        this(prop, type, requiredForFlight, requiresRepair, false);
    }

    public TardisPartItem(TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair, TranslationTextComponent dependentItem, boolean isDisabled) {
        this(Prop.Items.ONE.get().func_200916_a(TItemGroups.MAINTENANCE).func_200918_c(250), type, requiredForFlight, requiresRepair, dependentItem, isDisabled);
    }

    public TardisPartItem(TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair, TranslationTextComponent dependentItem) {
        this(Prop.Items.ONE.get().func_200916_a(TItemGroups.MAINTENANCE).func_200918_c(250), type, requiredForFlight, requiresRepair, dependentItem, false);
    }

    public TardisPartItem(TardisConstants.Part.PartType type, boolean requiredForFlight, boolean requiresRepair) {
        this(type, requiredForFlight, requiresRepair, new TranslationTextComponent(""));
    }

    @Override
    public void createStatisticTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String typeName = this.type.toString().toLowerCase();
        String typeFriendlyName = typeName.substring(0, 1).toUpperCase() + typeName.substring(1);
        StringTextComponent panelName = new StringTextComponent(this.type == TardisConstants.Part.PartType.SUBSYSTEM ? "Components" : "Upgrades");
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.part.type").func_230529_a_((ITextComponent)new StringTextComponent(typeFriendlyName).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        if (this.type != TardisConstants.Part.PartType.UPGRADE) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.part.flight.required").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.requiredForFlight)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.part.repair.required").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.requiresRepair)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        if (this.type == TardisConstants.Part.PartType.UPGRADE && !this.dependentItem.func_150268_i().isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.part.dependency").func_230529_a_((ITextComponent)(this.dependentItem != null ? this.dependentItem.func_240699_a_(TextFormatting.LIGHT_PURPLE) : new StringTextComponent("None").func_240699_a_(TextFormatting.LIGHT_PURPLE))));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.part.engine_panel").func_230529_a_((ITextComponent)panelName.func_240699_a_(this.type == TardisConstants.Part.PartType.SUBSYSTEM ? TextFormatting.BLUE : TextFormatting.GREEN)));
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TardisConstants.Prefix.TOOLTIP_ITEM_DESCRIPTION.func_230532_e_().func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.part." + this.getRegistryName().func_110623_a() + ".description").func_240699_a_(TextFormatting.GRAY)));
    }

    @Override
    public void createDefaultTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isDisabled) {
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_DISABLED_ITEM.func_240699_a_(TextFormatting.RED));
        }
    }
}

