/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.IDiagnostic;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.misc.ConsoleBoundItem;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.DiagnosticMessage;
import net.tardis.mod.tileentities.ConsoleTile;

public class TardisDiagnosticItem
extends ConsoleBoundItem {
    private final IFormattableTextComponent descriptionTooltip = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.diagnostic.use"));
    private final IFormattableTextComponent descriptionTooltipTwo = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.diagnostic.use2"));

    public TardisDiagnosticItem(Item.Properties properties) {
        super(properties);
    }

    public static void syncCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.func_196082_o().func_197643_a(stack.getShareTag());
        }
    }

    public static void readCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.readShareTag(stack.func_196082_o());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K) {
            playerIn.func_184586_b(handIn).getCapability(Capabilities.DIAGNOSTIC).ifPresent(loc -> loc.onRightClick(worldIn, playerIn, handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().func_201670_d()) {
            TardisHelper.getConsoleInWorld(context.func_195991_k()).ifPresent(console -> Network.sendTo(DiagnosticMessage.createFromConsole(console), (ServerPlayerEntity)context.func_195999_j()));
        }
        return super.func_195939_a(context);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        LivingEntity ent;
        if (!worldIn.field_72995_K && entityIn instanceof LivingEntity && PlayerHelper.isInEitherHand(ent = (LivingEntity)entityIn, this)) {
            stack.getCapability(Capabilities.DIAGNOSTIC).ifPresent(loc -> loc.tick((LivingEntity)entityIn));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.getTardisName(stack) != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.tardis.diagnostic.owner").func_230529_a_((ITextComponent)new StringTextComponent(this.getTardisName(stack)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        } else if (this.getTardisName(stack) == null) {
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_NO_ATTUNED);
        }
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
        if (Screen.func_231172_r_()) {
            tooltip.clear();
            tooltip.add(0, this.func_200295_i(stack));
            tooltip.add((ITextComponent)this.descriptionTooltip);
            tooltip.add((ITextComponent)this.descriptionTooltipTwo);
        }
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        stack.getCapability(Capabilities.DIAGNOSTIC).ifPresent(cap -> tag.func_218657_a("cap_sync", cap.serializeNBT()));
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("cap_sync")) {
            stack.getCapability(Capabilities.DIAGNOSTIC).ifPresent(cap -> cap.deserializeNBT((INBT)nbt.func_74775_l("cap_sync")));
        }
    }

    @Override
    public ItemStack onAttuned(ItemStack stack, ConsoleTile tile) {
        this.setTardis(stack, tile.func_145831_w().func_234923_W_().func_240901_a_());
        tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> this.setTardisName(stack, data.getTARDISName()));
        return stack;
    }

    @Override
    public int getAttunementTime() {
        return 200;
    }

    @Override
    public ResourceLocation getTardis(ItemStack stack) {
        IDiagnostic cap = (IDiagnostic)stack.getCapability(Capabilities.DIAGNOSTIC).orElse(null);
        if (cap == null) {
            return null;
        }
        return cap.getTardis();
    }

    @Override
    public void setTardis(ItemStack stack, ResourceLocation world) {
        IDiagnostic diag = (IDiagnostic)stack.getCapability(Capabilities.DIAGNOSTIC).orElse(null);
        if (diag != null) {
            diag.setTardis(world);
        }
    }

    @Override
    public String getTardisName(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("tardis_name")) {
            return stack.func_77978_p().func_74779_i("tardis_name");
        }
        return null;
    }

    @Override
    public void setTardisName(ItemStack stack, String name) {
        stack.func_196082_o().func_74778_a("tardis_name", name);
    }
}

