/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.properties.Prop;

public class TapeMeasureItem
extends Item {
    private final IFormattableTextComponent descriptionTooltip = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tape_measure.howto"));
    private final IFormattableTextComponent descriptionTooltipTwo = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tape_measure.howto_2"));

    public TapeMeasureItem() {
        super(Prop.Items.ONE.get().func_200916_a(null));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT tag = stack.func_77978_p();
        tooltip.add((ITextComponent)new StringTextComponent("Tool for measuring block position differences"));
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
        if (tag != null && !tag.isEmpty()) {
            BlockPos pos;
            if (tag.func_74764_b("first")) {
                pos = BlockPos.func_218283_e((long)tag.func_74763_f("first"));
                tooltip.add((ITextComponent)new StringTextComponent("First: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p()));
            }
            if (tag.func_74764_b("second")) {
                pos = BlockPos.func_218283_e((long)tag.func_74763_f("second"));
                tooltip.add((ITextComponent)new StringTextComponent("Second: " + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p()));
            }
            if (tag.func_74764_b("first") && tag.func_74764_b("second")) {
                BlockPos first = BlockPos.func_218283_e((long)tag.func_74763_f("first"));
                BlockPos second = BlockPos.func_218283_e((long)tag.func_74763_f("second"));
                int x = first.func_177958_n() > second.func_177958_n() ? first.func_177958_n() - second.func_177958_n() : second.func_177958_n() - first.func_177958_n();
                int y = first.func_177956_o() > second.func_177956_o() ? first.func_177956_o() - second.func_177956_o() : second.func_177956_o() - first.func_177956_o();
                int z = first.func_177952_p() > second.func_177952_p() ? first.func_177952_p() - second.func_177952_p() : second.func_177952_p() - first.func_177952_p();
                tooltip.add((ITextComponent)new StringTextComponent("Diff: " + x + ", " + y + ", " + z));
            }
        }
        if (Screen.func_231173_s_()) {
            tooltip.clear();
            tooltip.add(0, this.func_200295_i(stack));
            tooltip.add((ITextComponent)this.descriptionTooltip);
            tooltip.add((ITextComponent)this.descriptionTooltipTwo);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        if (!context.func_195991_k().func_201670_d()) {
            if (context.func_195999_j().func_225608_bj_()) {
                context.func_195996_i().func_77982_d(new CompoundNBT());
                return ActionResultType.SUCCESS;
            }
            CompoundNBT nbt = context.func_195996_i().func_196082_o();
            if (nbt.func_74764_b("first")) {
                BlockPos first = BlockPos.func_218283_e((long)nbt.func_74763_f("first"));
                BlockPos second = context.func_195995_a();
                nbt.func_74772_a("second", second.func_218275_a());
                int secondX = context.func_195995_a().func_177958_n();
                int secondY = context.func_195995_a().func_177956_o();
                int secondZ = context.func_195995_a().func_177952_p();
                TextComponent secondPos = TextHelper.createTextComponentWithTip("x:" + secondX + " y:" + secondY + " z:" + secondZ, WorldHelper.formatBlockPosDebug(new BlockPos(secondX, secondY, secondZ)));
                context.func_195999_j().func_146105_b((ITextComponent)new StringTextComponent("Second Position: ").func_230529_a_((ITextComponent)secondPos), false);
                int x = first.func_177958_n() > second.func_177958_n() ? first.func_177958_n() - second.func_177958_n() : second.func_177958_n() - first.func_177958_n();
                int y = first.func_177956_o() > second.func_177956_o() ? first.func_177956_o() - second.func_177956_o() : second.func_177956_o() - first.func_177956_o();
                int z = first.func_177952_p() > second.func_177952_p() ? first.func_177952_p() - second.func_177952_p() : second.func_177952_p() - first.func_177952_p();
                TextComponent diffPos = TextHelper.createTextComponentWithTip("x:" + x + " y:" + y + " z:" + z, WorldHelper.formatBlockPosDebug(new BlockPos(x, y, z)));
                context.func_195999_j().func_146105_b((ITextComponent)new StringTextComponent("BlockPos Difference: ").func_230529_a_((ITextComponent)diffPos), false);
            } else {
                nbt.func_74772_a("first", context.func_195995_a().func_218275_a());
                int x = context.func_195995_a().func_177958_n();
                int y = context.func_195995_a().func_177956_o();
                int z = context.func_195995_a().func_177952_p();
                TextComponent firstPos = TextHelper.createTextComponentWithTip("x:" + x + " y:" + y + " z:" + z, WorldHelper.formatBlockPosDebug(new BlockPos(x, y, z)));
                context.func_195999_j().func_146105_b((ITextComponent)new StringTextComponent("First Position: ").func_230529_a_((ITextComponent)firstPos), false);
            }
            context.func_195996_i().func_77982_d(nbt);
        }
        return ActionResultType.SUCCESS;
    }
}

