/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.IRemote;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.misc.ConsoleBoundItem;
import net.tardis.mod.tileentities.ConsoleTile;

public class StatRemoteItem
extends ConsoleBoundItem {
    public static final DecimalFormat FORMAT = new DecimalFormat("###");
    private static final IFormattableTextComponent USAGE = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.stat_remote.use"));

    public StatRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public static void syncCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.func_196082_o().func_197643_a(stack.getShareTag());
        }
    }

    public static void readCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.readShareTag(stack.func_196082_o());
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().func_201670_d() && WorldHelper.canTravelToDimension(context.func_195991_k())) {
            context.func_195996_i().getCapability(Capabilities.REMOTE_CAP).ifPresent(cap -> cap.onClick(context.func_195991_k(), context.func_195999_j(), context.func_195995_a()));
            return ActionResultType.SUCCESS;
        }
        if (!context.func_195991_k().func_201670_d() && !WorldHelper.canTravelToDimension(context.func_195991_k())) {
            context.func_195999_j().func_146105_b((ITextComponent)TardisConstants.Translations.CANT_USE_IN_DIM, true);
            return ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
        stack.getCapability(Capabilities.REMOTE_CAP).ifPresent(cap -> {
            String flightStatus;
            String string = flightStatus = cap.isInFlight() ? "Destination" : "Current";
            if (cap.getTardis() != null) {
                if (Screen.func_231173_s_()) {
                    tooltip.clear();
                    tooltip.add(0, this.func_200295_i(stack));
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.stat_remote.tardis_owner").func_230529_a_((ITextComponent)new StringTextComponent(this.getTardisName(stack)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
                    tooltip.add((ITextComponent)new StringTextComponent(flightStatus).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.stat_remote.exterior_dim").func_230529_a_((ITextComponent)new StringTextComponent(WorldHelper.formatDimName(cap.getExteriorDim())).func_240699_a_(TextFormatting.LIGHT_PURPLE))));
                    tooltip.add((ITextComponent)new StringTextComponent(flightStatus).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.stat_remote.exterior_pos").func_230529_a_((ITextComponent)new StringTextComponent(WorldHelper.formatBlockPos(cap.getExteriorPos())).func_240699_a_(TextFormatting.LIGHT_PURPLE))));
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.stat_remote.in_flight").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(cap.isInFlight())).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.stat_remote.journey").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(FORMAT.format(cap.getJourney() * 100.0))).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.stat_remote.fuel").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(FORMAT.format(cap.getFuel()))).func_240699_a_(TextFormatting.LIGHT_PURPLE).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS)));
                }
            } else {
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_NO_ATTUNED);
            }
        });
        if (Screen.func_231172_r_()) {
            tooltip.clear();
            tooltip.add(0, this.func_200295_i(stack));
            tooltip.add((ITextComponent)USAGE);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (entityIn instanceof PlayerEntity) {
                stack.getCapability(Capabilities.REMOTE_CAP).ifPresent(cap -> cap.tick(worldIn, entityIn));
            }
            if (worldIn.func_82737_E() % 20L == 0L) {
                StatRemoteItem.syncCapability(stack);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        stack.getCapability(Capabilities.REMOTE_CAP).ifPresent(cap -> tag.func_218657_a("cap_sync", cap.serializeNBT()));
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("cap_sync")) {
            stack.getCapability(Capabilities.REMOTE_CAP).ifPresent(handler -> handler.deserializeNBT((INBT)nbt.func_74775_l("cap_sync")));
        }
    }

    @Override
    public ItemStack onAttuned(ItemStack stack, ConsoleTile tile) {
        this.setTardis(stack, tile.func_145831_w().func_234923_W_().func_240901_a_());
        tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> this.setTardisName(stack, data.getTARDISName()));
        return stack;
    }

    @Override
    public int getAttunementTime() {
        return 3600;
    }

    @Override
    public ResourceLocation getTardis(ItemStack stack) {
        IRemote remote = (IRemote)stack.getCapability(Capabilities.REMOTE_CAP).orElse(null);
        if (remote == null) {
            return null;
        }
        return remote.getTardis();
    }

    @Override
    public void setTardis(ItemStack stack, ResourceLocation world) {
        stack.getCapability(Capabilities.REMOTE_CAP).ifPresent(remote -> remote.setTardis(world));
    }

    @Override
    public String getTardisName(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("tardis_name")) {
            return stack.func_77978_p().func_74779_i("tardis_name");
        }
        return null;
    }

    @Override
    public void setTardisName(ItemStack stack, String name) {
        stack.func_196082_o().func_74778_a("tardis_name", name);
    }
}

