/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.misc.IDontBreak;
import net.tardis.mod.tileentities.SquarenessChamelonTile;

public class SquarenessGunItem
extends Item {
    public SquarenessGunItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(TItemGroups.MAIN));
    }

    public static AxisAlignedBB getSelection(BlockPos clickedBlock, Direction direction) {
        AxisAlignedBB box = null;
        switch (direction) {
            case EAST: 
            case WEST: {
                box = new AxisAlignedBB(clickedBlock.func_177984_a().func_177978_c(), clickedBlock.func_177977_b().func_177968_d());
                break;
            }
            case NORTH: 
            case SOUTH: {
                box = new AxisAlignedBB(clickedBlock.func_177984_a().func_177976_e(), clickedBlock.func_177977_b().func_177974_f());
                break;
            }
            case DOWN: 
            case UP: {
                box = new AxisAlignedBB(clickedBlock.func_177978_c().func_177976_e(), clickedBlock.func_177968_d().func_177974_f());
                break;
            }
        }
        return box;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand handIn) {
        RayTraceResult result = PlayerHelper.getPosLookingAt((Entity)player, 5.0);
        if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction direction;
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
            BlockPos clickedBlock = blockRayTraceResult.func_216350_a();
            AxisAlignedBB box = SquarenessGunItem.getSelection(clickedBlock, direction = Direction.func_176737_a((float)((float)(player.func_226277_ct_() - (double)clickedBlock.func_177958_n())), (float)((float)(player.func_226278_cu_() - (double)clickedBlock.func_177956_o())), (float)((float)(player.func_226281_cx_() - (double)clickedBlock.func_177952_p()))));
            if (box == null) {
                return super.func_77659_a(world, player, handIn);
            }
            Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f), (BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c)).iterator();
            while (iterator.hasNext()) {
                SquarenessChamelonTile chamelonTile;
                BlockPos pos = (BlockPos)iterator.next();
                BlockState blockState = world.func_180495_p(pos);
                if (blockState.func_177230_c() instanceof IDontBreak || blockState.func_177230_c() == Blocks.field_150357_h || blockState.hasTileEntity()) continue;
                world.func_175656_a(pos, ((Block)TBlocks.squareness_block.get()).func_176223_P());
                if (!(world.func_175625_s(pos) instanceof SquarenessChamelonTile) || (chamelonTile = (SquarenessChamelonTile)world.func_175625_s(pos)) == null) continue;
                chamelonTile.setState(blockState);
            }
        }
        return super.func_77659_a(world, player, handIn);
    }
}

