/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.Map;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.tardis.api.space.items.IGravArmor;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.ISpaceHelmet;
import net.tardis.mod.properties.Prop;

public class SpaceSuitItem
extends ArmorItem
implements ISpaceHelmet,
IGravArmor {
    public static final SpaceMaterial spaceMaterial = new SpaceMaterial();

    public SpaceSuitItem(EquipmentSlotType slot) {
        super((IArmorMaterial)spaceMaterial, slot, Prop.Items.ONE.get().func_200916_a(TItemGroups.MAIN));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return slot == EquipmentSlotType.LEGS ? "tardis:textures/armor/spacesuit_legs.png" : "tardis:textures/armor/spacesuit.png";
    }

    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        Map<Item, BipedModel<?>> map = ClientHelper.getSpacesuitArmorModel(itemStack);
        BipedModel<?> model = map.get(itemStack.func_77973_b());
        return (A)model;
    }

    @Override
    public boolean shouldSufficate(LivingEntity ent) {
        for (ItemStack stack : ent.func_184193_aE()) {
            if (stack.func_77973_b() instanceof SpaceSuitItem) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useNormalGrav(LivingEntity entity, ItemStack stack) {
        BlockPos pos = entity.func_233580_cy_();
        for (int i = 0; i < 16; ++i) {
            if (!entity.field_70170_p.func_180495_p(pos.func_177979_c(i)).func_200132_m()) continue;
            return true;
        }
        return false;
    }

    public static class SpaceMaterial
    implements IArmorMaterial {
        public int func_200902_b(EquipmentSlotType arg0) {
            return 0;
        }

        public int func_200896_a(EquipmentSlotType arg0) {
            return 0;
        }

        public int func_200900_a() {
            return 0;
        }

        public String func_200897_d() {
            return "tardis:space_material";
        }

        public Ingredient func_200898_c() {
            return Ingredient.field_193370_a;
        }

        public SoundEvent func_200899_b() {
            return SoundEvents.field_187719_p;
        }

        public float func_200901_e() {
            return 2.0f;
        }

        public float func_230304_f_() {
            return 0.3f;
        }
    }
}

