/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.sonic.ISonic;
import net.tardis.mod.cap.items.sonic.SonicCapability;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.client.renderers.SonicRenderer;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.misc.ConsoleBoundItem;
import net.tardis.mod.misc.GuiContext;
import net.tardis.mod.sonic.AbstractSonicMode;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;

public class SonicItem
extends ConsoleBoundItem
implements IArtronItemStackBattery {
    private static final Integer COOLDOWN_TIME = 40;
    private static final Integer MAX_CHARGE = 500;

    public SonicItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(TItemGroups.MAIN).setISTER(() -> SonicRenderer::new));
    }

    public static void syncCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.func_196082_o().func_197643_a(stack.getShareTag());
        }
    }

    public static void readCapability(ItemStack stack) {
        if (stack.getShareTag() != null) {
            stack.readShareTag(stack.func_196082_o());
        }
    }

    public static AbstractSonicMode getCurrentMode(ItemStack stack) {
        ISonic data = (ISonic)SonicCapability.getForStack(stack).orElseGet(null);
        return data.getMode();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!(playerIn.func_184600_cs() == null || worldIn.func_201670_d() || playerIn.func_184811_cZ().func_185141_a(itemstack.func_77973_b()) || playerIn.func_225608_bj_())) {
            playerIn.func_184598_c(handIn);
        }
        if (worldIn.func_201670_d() && playerIn.func_225608_bj_()) {
            ClientHelper.openGUI(27, new GuiContext());
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity livingEntity, int timeLeft) {
        PlayerEntity player;
        RayTraceResult raytraceresult;
        if (world.field_72995_K) {
            return;
        }
        AbstractSonicMode mode = SonicItem.getCurrentMode(stack);
        if (livingEntity instanceof PlayerEntity && (raytraceresult = PlayerHelper.getPosLookingAt((Entity)(player = (PlayerEntity)livingEntity), SonicItem.getCurrentMode(stack).getReachDistance())) != null) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
                BlockPos pos = blockraytraceresult.func_216350_a();
                boolean flag = mode.processBlock(player, world.func_180495_p(pos), player.func_184607_cu(), pos);
                this.runPassFail(player, world, pos, flag);
                SonicCapability.getForStack(stack).ifPresent(cap -> cap.sync(player, Hand.MAIN_HAND));
            } else if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)raytraceresult;
                boolean worked = mode.processEntity(player, entityRayTraceResult.func_216348_a(), stack);
                this.runPassFail(player, world, entityRayTraceResult.func_216348_a().func_233580_cy_(), worked);
                SonicCapability.getForStack(stack).ifPresent(cap -> cap.sync(player, Hand.MAIN_HAND));
            }
        }
    }

    public void runPassFail(PlayerEntity playerEntity, World world, BlockPos pos, boolean worked) {
        world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), worked ? (SoundEvent)TSounds.SONIC_GENERIC.get() : (SoundEvent)TSounds.SONIC_FAIL.get(), SoundCategory.PLAYERS, 0.25f, 1.0f);
        if (worked) {
            playerEntity.func_184811_cZ().func_185145_a((Item)this, COOLDOWN_TIME.intValue());
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        SonicItem.getCurrentMode(stack).updateHeld((PlayerEntity)player, stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof PlayerEntity) {
            stack.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(cap -> {
                AbstractSonicMode mode = SonicItem.getCurrentMode(stack);
                if (mode != null) {
                    mode.inventoryTick((PlayerEntity)entityIn, stack);
                }
            });
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        SonicCapability.getForStack(stack).ifPresent(data -> {
            AbstractSonicMode mode;
            if (data.getTardis() != null && this.getTardisName(stack) != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.item.attuned.owner").func_230529_a_((ITextComponent)new StringTextComponent(this.getTardisName(stack)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
            } else {
                tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_NO_ATTUNED);
            }
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
            if (Screen.func_231173_s_()) {
                tooltip.clear();
                tooltip.add(0, stack.func_200301_q());
                mode = SonicItem.getCurrentMode(stack);
                tooltip.add((ITextComponent)new TranslationTextComponent("sonic.mode.type", new Object[]{mode.getTranslation().func_240699_a_(TextFormatting.GRAY)}));
                tooltip.add((ITextComponent)new TranslationTextComponent("sonic.mode.type.desc", new Object[]{new TranslationTextComponent(mode.getDescriptionLangKey()).func_240699_a_(TextFormatting.GRAY)}));
                tooltip.add((ITextComponent)new TranslationTextComponent("sonic.mode.charge", new Object[]{Float.valueOf(data.getCharge())}));
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.tardis.stored_schematic"));
                List<ITextComponent> schematicTexts = TextHelper.getSchematicsInList(data.getSchematics());
                tooltip.addAll(schematicTexts);
            }
            if (Screen.func_231172_r_()) {
                tooltip.clear();
                tooltip.add(0, stack.func_200301_q());
                mode = SonicItem.getCurrentMode(stack);
                if (mode.hasAdditionalInfo()) {
                    tooltip.addAll(mode.getAdditionalInfo());
                } else if (mode.hasAdditionalInfo()) {
                    tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
                }
            }
        });
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        super.func_77622_d(stack, worldIn, playerIn);
        SonicCapability.getForStack(stack).ifPresent(ISonic::randomiseParts);
    }

    public ActionResultType func_111207_a(ItemStack sonic, PlayerEntity player, LivingEntity target, Hand hand) {
        AbstractSonicMode mode = SonicItem.getCurrentMode(sonic);
        if (player.func_184811_cZ().func_185141_a(sonic.func_77973_b())) {
            return ActionResultType.FAIL;
        }
        boolean flag = mode.processEntity(player, (Entity)target, sonic);
        this.runPassFail(player, player.field_70170_p, target.func_233580_cy_(), flag);
        return ActionResultType.PASS;
    }

    public int func_77626_a(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        SonicCapability.getForStack(stack).ifPresent(handler -> tag.func_218657_a("cap_sync", handler.serializeNBT()));
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null && nbt.func_74764_b("cap_sync")) {
            SonicCapability.getForStack(stack).ifPresent(handler -> handler.deserializeNBT((INBT)nbt.func_74775_l("cap_sync")));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @Override
    public float charge(ItemStack stack, float amount, boolean simulate) {
        float maxCharge;
        float charge = this.getCharge(stack);
        if (charge + amount >= (maxCharge = this.getMaxCharge(stack))) {
            float chargeToAdd = maxCharge - charge;
            this.writeCharge(stack, chargeToAdd, false);
            return chargeToAdd;
        }
        this.writeCharge(stack, amount, false);
        return amount;
    }

    @Override
    public float discharge(ItemStack stack, float amount, boolean simulate) {
        float current = this.getCharge(stack);
        if (amount <= current) {
            this.writeCharge(stack, amount, true);
            return amount;
        }
        this.writeCharge(stack, 0.0f, true);
        return current;
    }

    @Override
    public float getCharge(ItemStack stack) {
        ISonic data = (ISonic)SonicCapability.getForStack(stack).orElse(null);
        return data.getCharge();
    }

    @Override
    public float getMaxCharge(ItemStack stack) {
        ISonic data = (ISonic)SonicCapability.getForStack(stack).orElse(null);
        if (data != null) {
            return data.getMaxCharge();
        }
        return MAX_CHARGE.intValue();
    }

    public void writeCharge(ItemStack stack, float charge, boolean discharge) {
        ISonic data = (ISonic)SonicCapability.getForStack(stack).orElse(null);
        data.setCharge(discharge ? this.getCharge(stack) - charge : this.getCharge(stack) + charge);
    }

    @Override
    public ItemStack onAttuned(ItemStack stack, ConsoleTile tile) {
        this.setTardis(stack, tile.func_145831_w().func_234923_W_().func_240901_a_());
        tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> this.setTardisName(stack, data.getTARDISName()));
        return stack;
    }

    @Override
    public int getAttunementTime() {
        return 3600;
    }

    @Override
    public ResourceLocation getTardis(ItemStack stack) {
        ISonic remote = (ISonic)stack.getCapability(Capabilities.SONIC_CAPABILITY).orElse(null);
        if (remote == null) {
            return null;
        }
        return remote.getTardis();
    }

    @Override
    public void setTardis(ItemStack stack, ResourceLocation world) {
        stack.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(sonic -> sonic.setTardis(world));
    }

    @Override
    public String getTardisName(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("tardis_name")) {
            return stack.func_77978_p().func_74779_i("tardis_name");
        }
        return null;
    }

    @Override
    public void setTardisName(ItemStack stack, String name) {
        stack.func_196082_o().func_74778_a("tardis_name", name);
    }

    @Override
    public float charge(ItemStack stack, float amount) {
        return this.charge(stack, amount, false);
    }

    @Override
    public float discharge(ItemStack stack, float amount) {
        return this.discharge(stack, amount, false);
    }
}

