/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.items.IWatch;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.misc.TooltipProviderItem;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.sounds.TSounds;

public class PocketWatchItem
extends TooltipProviderItem {
    private final IFormattableTextComponent descriptionTooltip = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.watch.line1"));
    private final IFormattableTextComponent descriptionTooltipTwo = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.watch.line2"));

    public PocketWatchItem() {
        super(Prop.Items.ONE.get().func_200916_a(TItemGroups.MAIN));
        this.setShowTooltips(true);
        this.setHasDescriptionTooltips(true);
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.descriptionTooltip);
        tooltip.add((ITextComponent)this.descriptionTooltipTwo);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && PlayerHelper.isInEitherHand((LivingEntity)entityIn, stack.func_77973_b())) {
            if (worldIn.func_82737_E() % 20L == 0L) {
                worldIn.func_184133_a(null, entityIn.func_233580_cy_(), (SoundEvent)TSounds.WATCH_TICK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (worldIn.func_82737_E() % 100L == 0L) {
                stack.getCapability(Capabilities.WATCH_CAPABILITY).ifPresent(watch -> {
                    watch.tick(worldIn, entityIn, itemSlot);
                    if (watch.shouldSpin(entityIn) && worldIn.func_82737_E() % 10L == 0L) {
                        worldIn.func_184133_a(null, entityIn.func_233580_cy_(), (SoundEvent)TSounds.WATCH_MALFUNCTION.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                    }
                });
            }
        }
    }

    public float createPropertyOverride(ItemStack stack, ClientWorld world, LivingEntity entity) {
        IWatch watch = (IWatch)stack.getCapability(Capabilities.WATCH_CAPABILITY).orElse(null);
        if (watch != null) {
            if (entity != null && watch.shouldSpin((Entity)entity)) {
                return entity.field_70173_aa % 8;
            }
            return watch.getVariant();
        }
        return world != null ? ClientHelper.getPocketWatchRotFromTime(world) : 0.0f;
    }
}

