/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.properties.Prop;

public class PlasmicShellItem
extends Item {
    public PlasmicShellItem() {
        super(Prop.Items.ONE.get().func_200916_a(null));
    }

    public static AxisAlignedBB getBox(BlockPos pos, BlockPos pos1) {
        int maxZ;
        int minZ;
        int maxY;
        int minY;
        int maxX;
        int minX;
        if (pos.func_177958_n() > pos1.func_177958_n()) {
            minX = pos1.func_177958_n();
            maxX = pos.func_177958_n();
        } else {
            minX = pos.func_177958_n();
            maxX = pos1.func_177958_n();
        }
        if (pos.func_177956_o() > pos1.func_177956_o()) {
            minY = pos1.func_177956_o();
            maxY = pos.func_177956_o();
        } else {
            minY = pos.func_177956_o();
            maxY = pos1.func_177956_o();
        }
        if (pos.func_177952_p() > pos1.func_177952_p()) {
            minZ = pos1.func_177952_p();
            maxZ = pos.func_177952_p();
        } else {
            minZ = pos.func_177952_p();
            maxZ = pos1.func_177952_p();
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("pos1") && tag.func_74764_b("pos2") && context.func_195991_k().func_180495_p(context.func_195995_a()) == ((Block)TBlocks.atrium_block.get()).func_176223_P()) {
            DataResult dataresult;
            BlockPos pos1 = BlockPos.func_218283_e((long)tag.func_74763_f("pos1"));
            BlockPos pos2 = BlockPos.func_218283_e((long)tag.func_74763_f("pos2"));
            ArrayList<Disguise.DisguiseBlockStateEntry> entries = new ArrayList<Disguise.DisguiseBlockStateEntry>();
            for (BlockPos pos : BlockPos.func_218278_a((BlockPos)pos1, (BlockPos)pos2)) {
                BlockState state = context.func_195991_k().func_180495_p(pos);
                if (state.func_196958_f() || pos.equals((Object)context.func_195995_a()) || pos.equals((Object)context.func_195995_a().func_177977_b())) continue;
                int x = pos.func_177958_n() - context.func_195995_a().func_177958_n();
                int y = pos.func_177956_o() - context.func_195995_a().func_177956_o();
                int z = pos.func_177952_p() - context.func_195995_a().func_177952_p();
                BlockPos offsetPos = new BlockPos(x, y, z);
                entries.add(new Disguise.DisguiseBlockStateEntry(state, offsetPos.func_185334_h()));
            }
            Path path = new File("plasmic_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime()) + ".json").toPath();
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                DataResult result = Disguise.DisguiseBlockStateEntry.CODEC_LIST.encodeStart((DynamicOps)JsonOps.INSTANCE, entries);
                dataresult = result.flatMap(element -> {
                    try (JsonWriter jsonwriter = gson.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
                        gson.toJson(element, jsonwriter);
                    }
                    catch (JsonIOException | IOException ioexception) {
                        return DataResult.error((String)("Error writing file: " + ioexception.getMessage()));
                    }
                    return DataResult.success((Object)path.toString());
                });
                if (!context.func_195991_k().func_201670_d()) {
                    context.func_195999_j().func_145747_a((ITextComponent)new StringTextComponent("Saved as " + path.getFileName() + " in the minecraft instance!"), Util.field_240973_b_);
                    context.func_195996_i().func_196082_o().func_74757_a("complete", true);
                }
            }
            catch (Exception e) {
                dataresult = DataResult.error((String)"Failed to parse disguise json");
            }
            return ActionResultType.SUCCESS;
        }
        if (!tag.func_74764_b("pos1")) {
            tag.func_74772_a("pos1", context.func_195995_a().func_218275_a());
            return ActionResultType.SUCCESS;
        }
        if (tag.func_74764_b("pos1") && !tag.func_74764_b("pos2")) {
            tag.func_74772_a("pos2", context.func_195995_a().func_218275_a());
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_70170_p.func_201670_d() && playerIn.func_225608_bj_() && stack.func_196082_o().func_74764_b("pos1") && stack.func_196082_o().func_74764_b("pos2")) {
            stack.func_77982_d(new CompoundNBT());
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("pos1")) {
            BlockPos pos1 = BlockPos.func_218283_e((long)tag.func_74763_f("pos1"));
            tooltip.add((ITextComponent)new StringTextComponent("Pos 1: " + WorldHelper.formatBlockPosDebug(pos1)));
            if (tag.func_74764_b("pos2")) {
                BlockPos pos2 = BlockPos.func_218283_e((long)tag.func_74763_f("pos2"));
                tooltip.add((ITextComponent)new StringTextComponent("Pos 2: " + WorldHelper.formatBlockPosDebug(pos2)));
            }
        }
        if (tag.func_74764_b("complete")) {
            boolean complete = tag.func_74767_n("complete");
            tooltip.add((ITextComponent)new StringTextComponent("Completed: " + complete));
        }
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.plasmic_shell.use1"));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.plasmic_shell.use2"));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.plasmic_shell.use3"));
        } else {
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
        }
    }
}

