/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.items.ItemStackHandler;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.client.TClientRegistry;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TInventoryHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.ArtronItemStackBatteryItem;
import net.tardis.mod.items.BaseItem;
import net.tardis.mod.items.misc.LaserPowerTier;
import net.tardis.mod.items.misc.PlayerLaserWeapon;

public class LaserGunItem
extends BaseItem {
    private ItemStackHandler handler;
    private final TranslationTextComponent NONE = new TranslationTextComponent("tooltip.laser_gun.charge.none");

    public LaserGunItem(int numSlots) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(TItemGroups.MAIN));
        this.handler = new ItemStackHandler(numSlots);
    }

    public void addBattery(Entity gunHolder, ItemStack stack, ItemStack testStack) {
        CompoundNBT root = stack.func_196082_o();
        float chargeTotal = this.calcTotalCharge();
        int numBatteries = this.getNumBatteries(stack);
        if (!testStack.func_190926_b()) {
            if (testStack.func_77973_b() instanceof IArtronItemStackBattery) {
                IArtronItemStackBattery battery = (IArtronItemStackBattery)testStack.func_77973_b();
                for (int index = 0; index < this.handler.getSlots(); ++index) {
                    ItemStack slotStack = this.handler.getStackInSlot(index);
                    if (testStack.func_190926_b()) continue;
                    if (slotStack.func_77973_b() instanceof IArtronItemStackBattery) {
                        IArtronItemStackBattery slotBattery = (IArtronItemStackBattery)slotStack.func_77973_b();
                        if (!(slotBattery.getCharge(slotStack) < battery.getCharge(testStack))) continue;
                        chargeTotal -= slotBattery.getCharge(slotStack);
                        TInventoryHelper.giveStackTo(gunHolder, slotStack.func_77946_l());
                        this.handler.setStackInSlot(index, ItemStack.field_190927_a);
                        chargeTotal += battery.getCharge(testStack);
                        this.handler.setStackInSlot(index, testStack.func_77946_l());
                        testStack.func_190918_g(1);
                        gunHolder.field_70170_p.func_184133_a(null, gunHolder.func_233580_cy_(), SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        continue;
                    }
                    if (!slotStack.func_190926_b()) continue;
                    chargeTotal += battery.getCharge(testStack);
                    ++numBatteries;
                    this.handler.setStackInSlot(index, testStack.func_77946_l());
                    testStack.func_190918_g(1);
                    gunHolder.field_70170_p.func_184133_a(null, gunHolder.func_233580_cy_(), SoundEvents.field_187719_p, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        } else {
            for (int index = 0; index < this.handler.getSlots(); ++index) {
                ItemStack slotStack = this.handler.getStackInSlot(index);
                if (!(slotStack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
                IArtronItemStackBattery slotBattery = (IArtronItemStackBattery)slotStack.func_77973_b();
                float stackCharge = slotBattery.getCharge(slotStack);
                float actualAmountToTake = this.getCurrentTier(stack).getChargeRequired();
                boolean isCreativeBattery = false;
                if (slotStack.func_77973_b() instanceof ArtronItemStackBatteryItem) {
                    ArtronItemStackBatteryItem artronBattery = (ArtronItemStackBatteryItem)slotStack.func_77973_b();
                    actualAmountToTake = artronBattery.getDischargeRate(this.getTierRequiredCharge(slotStack));
                    isCreativeBattery = artronBattery.isCreative();
                }
                if (slotStack.func_190926_b() || !(stackCharge < actualAmountToTake) && !isCreativeBattery) continue;
                chargeTotal = chargeTotal - actualAmountToTake >= 0.0f ? (chargeTotal == Float.MAX_VALUE ? 0.0f : (chargeTotal -= actualAmountToTake)) : 0.0f;
                if (Float.toString(chargeTotal).equals("Infinity")) {
                    chargeTotal = 0.0f;
                }
                TInventoryHelper.giveStackTo(gunHolder, slotStack.func_77946_l());
                this.handler.setStackInSlot(index, ItemStack.field_190927_a);
                if (numBatteries <= 0) continue;
                --numBatteries;
            }
        }
        root.func_218657_a("inv", (INBT)this.handler.serializeNBT());
        root.func_74776_a("charge", chargeTotal);
        root.func_74768_a("num_batteries", numBatteries);
        this.calculateNumShots(stack);
    }

    public void removeCharge(Entity gunHolder, ItemStack stack, float amount) {
        CompoundNBT root = stack.func_196082_o();
        float chargeToDeplete = amount;
        float chargeTotal = this.calcTotalCharge();
        boolean shouldRemove = true;
        if (gunHolder instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)gunHolder;
            boolean bl = shouldRemove = !player.field_71075_bZ.field_75098_d;
        }
        if (shouldRemove) {
            for (int index = 0; index < this.handler.getSlots(); ++index) {
                IArtronItemStackBattery battery;
                float depleted;
                ItemStack slotStack = this.handler.getStackInSlot(index);
                if (!(slotStack.func_77973_b() instanceof IArtronItemStackBattery) || !(chargeTotal - (chargeToDeplete -= (depleted = (battery = (IArtronItemStackBattery)slotStack.func_77973_b()).discharge(slotStack, chargeToDeplete))) < 0.0f)) continue;
                chargeToDeplete -= chargeTotal;
            }
            chargeTotal = this.calcTotalCharge();
        }
        root.func_218657_a("inv", (INBT)this.handler.serializeNBT());
        root.func_74776_a("charge", chargeTotal);
        this.calculateNumShots(stack);
    }

    public ItemStack getBatteryInInventory(NonNullList<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (!(stack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public float getTotalCharge(ItemStack stack) {
        CompoundNBT root = stack.func_196082_o();
        if (root.func_74764_b("charge")) {
            return root.func_74760_g("charge");
        }
        return 0.0f;
    }

    public float calcTotalCharge() {
        float totalCharge = 0.0f;
        for (int index = 0; index < this.handler.getSlots(); ++index) {
            ItemStack slotStack = this.handler.getStackInSlot(index);
            if (!(slotStack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
            IArtronItemStackBattery battery = (IArtronItemStackBattery)slotStack.func_77973_b();
            totalCharge += battery.getCharge(slotStack);
        }
        return totalCharge;
    }

    public int getNumBatteries(ItemStack stack) {
        CompoundNBT root = stack.func_196082_o();
        if (root.func_74764_b("num_batteries")) {
            return root.func_74762_e("num_batteries");
        }
        return 0;
    }

    protected void calculateNumShots(ItemStack stack) {
        CompoundNBT root = stack.func_196082_o();
        int numShots = 0;
        for (int index = 0; index < this.handler.getSlots(); ++index) {
            ItemStack slotStack = this.handler.getStackInSlot(index);
            if (!(slotStack.func_77973_b() instanceof IArtronItemStackBattery)) continue;
            IArtronItemStackBattery battery = (IArtronItemStackBattery)slotStack.func_77973_b();
            float actualAmountToTake = this.getCurrentTier(stack).getChargeRequired();
            float deplete = battery.discharge(slotStack, actualAmountToTake, true);
            numShots = (int)((double)numShots + Math.ceil(battery.getCharge(slotStack) / deplete));
        }
        root.func_74768_a("remaining_shots", numShots);
    }

    public int getNumShotsRemaining(ItemStack stack) {
        CompoundNBT root = stack.func_196082_o();
        if (root.func_74764_b("remaining_shots")) {
            return root.func_74762_e("remaining_shots");
        }
        return 0;
    }

    public void setPowerTier(LaserPowerTier tier, ItemStack stack) {
        CompoundNBT root = stack.func_196082_o();
        root.func_74768_a("power_tier", tier.ordinal());
        this.calculateNumShots(stack);
    }

    public LaserPowerTier getCurrentTier(ItemStack stack) {
        CompoundNBT root = stack.func_196082_o();
        if (root.func_74764_b("power_tier")) {
            return LaserPowerTier.values()[root.func_74762_e("power_tier")];
        }
        return LaserPowerTier.LOW;
    }

    public float getTierRequiredCharge(ItemStack stack) {
        return this.getCurrentTier(stack).getChargeRequired();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().func_201670_d()) {
            ItemStack gun = context.func_195996_i();
            PlayerEntity player = context.func_195999_j();
            if (player.func_225608_bj_()) {
                int maxLength = LaserPowerTier.values().length;
                int nextIndex = this.getCurrentTier(gun).ordinal() + 1 < maxLength ? this.getCurrentTier(gun).ordinal() + 1 : 0;
                LaserPowerTier nextTier = LaserPowerTier.values()[nextIndex];
                this.setPowerTier(nextTier, gun);
                IFormattableTextComponent nextTierName = new TranslationTextComponent(nextTier.getTranslationKey()).func_240699_a_(TextFormatting.LIGHT_PURPLE);
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.laser_gun.set_power_tier").func_230529_a_((ITextComponent)nextTierName), true);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack gun = player.func_184586_b(handIn);
        if (!player.field_70170_p.func_201670_d()) {
            if (player.func_225608_bj_()) {
                Vector3d pos = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
                BlockRayTraceResult result = worldIn.func_217299_a(new RayTraceContext(pos, pos.func_178787_e(player.func_70040_Z().func_186678_a(player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get()))), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player));
                if (result.func_216346_c() == RayTraceResult.Type.MISS) {
                    player.func_184598_c(handIn);
                    return ActionResult.func_226248_a_((Object)gun);
                }
                return ActionResult.func_226251_d_((Object)gun);
            }
            player.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)gun);
        }
        return ActionResult.func_226248_a_((Object)gun);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entityLiving, int timeLeft) {
        if (!world.func_201670_d() && entityLiving instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entityLiving;
            if (this.getNumShotsRemaining(stack) > 0 || player.field_71075_bZ.field_75098_d) {
                PlayerLaserWeapon weapon = new PlayerLaserWeapon((LivingEntity)player);
                weapon.useWeapon((LivingEntity)player);
                weapon.setDamage(this.getCurrentTier(stack).getDamageInflicted());
            } else {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187576_at, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent charge = new TranslationTextComponent("tooltip.laser_gun.charge");
        if (this.getTotalCharge(stack) > 0.0f) {
            tooltip.add((ITextComponent)charge.func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.getTotalCharge(stack))).func_240699_a_(TextFormatting.LIGHT_PURPLE)).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS));
        } else {
            tooltip.add((ITextComponent)this.NONE.func_240699_a_(TextFormatting.RED));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.laser_gun.shots_left").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.getNumShotsRemaining(stack))).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_HOLD_SHIFT);
        tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_CONTROL);
        if (Screen.func_231173_s_()) {
            tooltip.clear();
            tooltip.add(0, stack.func_200301_q());
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.laser_gun.num_batteries").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.getNumBatteries(stack))).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
            IFormattableTextComponent tier = new TranslationTextComponent(this.getCurrentTier(stack).getTranslationKey()).func_240699_a_(TextFormatting.LIGHT_PURPLE);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.laser_gun.tier").func_230529_a_((ITextComponent)tier));
        }
        if (Screen.func_231172_r_()) {
            tooltip.clear();
            tooltip.add(0, stack.func_200301_q());
            tooltip.add((ITextComponent)TardisConstants.Translations.TOOLTIP_ARTRON_BATTERY_REQUIRED);
            TranslationTextComponent keyBind = new TranslationTextComponent(TClientRegistry.RELOAD_GUN.func_197982_m());
            IFormattableTextComponent description = new TranslationTextComponent("tooltip.laser_gun.description", new Object[]{keyBind}).func_240699_a_(TextFormatting.GRAY);
            IFormattableTextComponent finalDesc = TardisConstants.Prefix.TOOLTIP_ITEM_DESCRIPTION.func_230532_e_().func_230529_a_((ITextComponent)description);
            tooltip.add((ITextComponent)finalDesc);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

