/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tardis.mod.blocks.exteriors.ExteriorBlock;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.misc.ConsoleBoundWithTooltipItem;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.upgrades.KeyFobUpgrade;

public class KeyItem
extends ConsoleBoundWithTooltipItem {
    public KeyItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(TItemGroups.MAIN));
    }

    @Override
    public ResourceLocation getTardis(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("tardis_key_linked_console")) {
            return new ResourceLocation(stack.func_77978_p().func_74779_i("tardis_key_linked_console"));
        }
        return null;
    }

    @Override
    public void setTardis(ItemStack stack, ResourceLocation world) {
        stack.func_196082_o().func_74778_a("tardis_key_linked_console", world.toString());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77973_b() instanceof KeyItem) {
            if (!worldIn.field_72995_K) {
                if (this.getTardis(stack) != null) {
                    TardisHelper.getConsole(worldIn.func_73046_m(), this.getTardis(stack)).ifPresent(tile -> tile.getUpgrade(KeyFobUpgrade.class).ifPresent(fob -> {
                        if (fob.isUsable() && fob.isActivated()) {
                            if (tile.getCurrentLocation().func_218141_a((Vector3i)playerIn.func_233580_cy_(), 16.0) && tile.getCurrentDimension() == playerIn.field_70170_p.func_234923_W_()) {
                                ExteriorTile ext = tile.getExteriorType().getExteriorTile((ConsoleTile)((Object)tile));
                                if (ext != null) {
                                    ext.setLocked(!ext.getLocked());
                                    if (ext.getLocked()) {
                                        ext.setDoorState(EnumDoorState.CLOSED);
                                    }
                                    ext.copyDoorStateToInteriorDoor();
                                    worldIn.func_184133_a(null, playerIn.func_233580_cy_(), (SoundEvent)TSounds.CAR_LOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                                    playerIn.func_146105_b((ITextComponent)(ext.getLocked() ? ExteriorBlock.LOCKED : ExteriorBlock.UNLOCKED), true);
                                }
                            } else if (playerIn.field_70170_p == tile.func_145831_w()) {
                                tile.getDoor().ifPresent(door -> {
                                    door.setLocked(!door.isLocked());
                                    if (door.isLocked()) {
                                        door.setOpenState(EnumDoorState.CLOSED);
                                    }
                                    door.updateExteriorDoorData();
                                    worldIn.func_184133_a(null, playerIn.func_233580_cy_(), (SoundEvent)TSounds.CAR_LOCK.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                                });
                            }
                        }
                    }));
                }
                if (this.getTardis(stack) == null) {
                    PlayerHelper.sendMessageToPlayer(playerIn, TardisConstants.Translations.ITEM_NOT_ATTUNED, true);
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }
}

