/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.items.misc.TooltipProviderItem;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.tileentities.IMultiblock;
import net.tardis.mod.tileentities.WaypointBankTile;

public class DataCrystalItem
extends TooltipProviderItem {
    public static final String WAYPOINT_KEY = "waypoints";
    public static final int MAX_WAYPOINTS = 5;
    private final IFormattableTextComponent emptyDescription = TextHelper.createExtraLineItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.data_crystal.empty"));
    private final IFormattableTextComponent description = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.tardis.data_crystal_use"));

    public DataCrystalItem(Item.Properties properties) {
        super(properties);
        this.setShowTooltips(true);
        this.setHasStatisticsTooltips(true);
        this.setHasDescriptionTooltips(true);
    }

    public static List<SpaceTimeCoord> getStoredWaypoints(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(WAYPOINT_KEY)) {
            return Lists.newArrayList();
        }
        ArrayList coords = Lists.newArrayList();
        ListNBT list = stack.func_196082_o().func_150295_c(WAYPOINT_KEY, 10);
        for (INBT nbt : list) {
            coords.add(SpaceTimeCoord.deserialize((CompoundNBT)nbt));
        }
        return coords;
    }

    public static void setStoredWaypoints(ItemStack stack, List<SpaceTimeCoord> coords) {
        ListNBT list = new ListNBT();
        for (SpaceTimeCoord coord : coords) {
            list.add((Object)coord.serialize());
        }
        stack.func_196082_o().func_218657_a(WAYPOINT_KEY, (INBT)list);
    }

    public static boolean addWaypoint(ItemStack stack, SpaceTimeCoord coord) {
        List<SpaceTimeCoord> coords = DataCrystalItem.getStoredWaypoints(stack);
        if (coords.size() >= 5) {
            return false;
        }
        coords.add(coord);
        DataCrystalItem.setStoredWaypoints(stack, coords);
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
        WaypointBankTile bank = null;
        if (te instanceof WaypointBankTile) {
            bank = (WaypointBankTile)te;
        } else if (te instanceof IMultiblock && ((IMultiblock)te).getMasterTile() instanceof WaypointBankTile) {
            bank = (WaypointBankTile)((IMultiblock)te).getMasterTile();
        }
        if (bank == null) {
            return ActionResultType.PASS;
        }
        if (!context.func_195991_k().func_201670_d()) {
            List<SpaceTimeCoord> preSaved = DataCrystalItem.getStoredWaypoints(context.func_195996_i());
            if (!preSaved.isEmpty()) {
                Iterator<SpaceTimeCoord> it = preSaved.iterator();
                while (it.hasNext()) {
                    SpaceTimeCoord coord2 = it.next();
                    if (!bank.addWaypoint(coord2)) continue;
                    it.remove();
                }
                DataCrystalItem.setStoredWaypoints(context.func_195996_i(), preSaved);
                PlayerHelper.sendMessageToPlayer(context.func_195999_j(), new TranslationTextComponent("message.data_crystal.transfer_to_bank"), true);
            } else {
                ArrayList coords = Lists.newArrayList(bank.getWaypoints());
                coords.removeIf(coord -> coord.equals(SpaceTimeCoord.UNIVERAL_CENTER));
                DataCrystalItem.setStoredWaypoints(context.func_195996_i(), coords);
                bank.clearWaypoints();
                PlayerHelper.sendMessageToPlayer(context.func_195999_j(), new TranslationTextComponent("message.data_crystal.extract_from_bank"), true);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void createStatisticTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        List<SpaceTimeCoord> coords = DataCrystalItem.getStoredWaypoints(stack);
        if (!coords.isEmpty()) {
            for (SpaceTimeCoord coord : coords) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.tardis.data_crystal", new Object[]{coord.getName()}).func_240699_a_(TextFormatting.GRAY));
            }
        } else {
            tooltip.add((ITextComponent)this.emptyDescription);
        }
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.description);
    }
}

