/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import com.google.common.base.Supplier;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.hostile.dalek.types.DalekType;
import net.tardis.mod.itemgroups.TItemGroups;

public class DalekSpawnItem
extends Item {
    Supplier<DalekType> dalekType;

    public DalekSpawnItem(Supplier<DalekType> dalekType) {
        super(new Item.Properties().func_200916_a(TItemGroups.MAIN));
        this.dalekType = dalekType;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileentity;
        World world = context.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        EntityType dalekType = (EntityType)TEntities.DALEK.get();
        if (blockstate.func_203425_a(Blocks.field_150474_ac) && (tileentity = world.func_175625_s(blockpos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            abstractspawner.func_200876_a(dalekType);
            tileentity.func_70296_d();
            world.func_184138_a(blockpos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.CONSUME;
        }
        BlockPos testPos = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        Entity entity = dalekType.func_220331_a((ServerWorld)world, itemstack, context.func_195999_j(), testPos, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, testPos) && direction == Direction.UP);
        if (entity != null && entity instanceof DalekEntity) {
            DalekEntity dalek = (DalekEntity)entity;
            dalek.setDalekType((DalekType)((Object)this.dalekType.get()));
            itemstack.func_190918_g(1);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        BlockRayTraceResult raytraceresult = Item.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (worldIn.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            EntityType dalekType = (EntityType)TEntities.DALEK.get();
            Entity entity = dalekType.func_220331_a((ServerWorld)worldIn, itemstack, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false);
            if (entity != null && entity instanceof DalekEntity) {
                DalekEntity dalek = (DalekEntity)entity;
                dalek.setDalekType((DalekType)((Object)this.dalekType.get()));
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    return ActionResult.func_226248_a_((Object)itemstack);
                }
            }
        } else {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }
}

