/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.artron.IArtronItemStackBattery;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TextHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.misc.TooltipProviderItem;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.tileentities.ConsoleTile;

public class ArtronItemStackBatteryItem
extends TooltipProviderItem
implements IArtronItemStackBattery {
    private static final String CHARGE = "artron";
    private final float chargeRateMultiplier;
    private final float dischargeRateMultiplier;
    private final float maxChargeCapacity;
    private final boolean isCreative;
    protected final IFormattableTextComponent descriptionTooltip = TextHelper.createDescriptionItemTooltip((IFormattableTextComponent)new TranslationTextComponent("tooltip.artron_battery.howto"));

    public ArtronItemStackBatteryItem(float chargeRateMultiplier, float dischargeRateMultiplier, float maxChargeCapacity, boolean isCreative) {
        super(Prop.Items.ONE.get().func_200916_a(TItemGroups.MAINTENANCE));
        this.chargeRateMultiplier = chargeRateMultiplier;
        this.dischargeRateMultiplier = dischargeRateMultiplier;
        this.maxChargeCapacity = maxChargeCapacity;
        this.isCreative = isCreative;
        this.setShowTooltips(true);
        this.setHasStatisticsTooltips(true);
        this.setHasDescriptionTooltips(true);
    }

    @Override
    public float charge(ItemStack stack, float amount, boolean simulate) {
        float maxCharge;
        amount = this.getChargeRate(amount);
        float charge = stack.func_196082_o().func_74760_g(CHARGE);
        if (charge + amount >= (maxCharge = this.getMaxCharge(stack))) {
            float chargeToAdd = maxCharge - charge;
            if (!simulate) {
                this.writeCharge(stack, charge + chargeToAdd);
            }
            return chargeToAdd;
        }
        if (!simulate) {
            this.writeCharge(stack, charge + amount);
        }
        return amount;
    }

    @Override
    public float discharge(ItemStack stack, float amount, boolean simulate) {
        float current = stack.func_196082_o().func_74760_g(CHARGE);
        float takenAmount = this.getDischargeRate(amount);
        float updatedCharge = current - takenAmount;
        if (takenAmount <= current && updatedCharge > 0.0f) {
            if (!simulate) {
                this.writeCharge(stack, updatedCharge);
            }
            return takenAmount;
        }
        if (!simulate) {
            this.writeCharge(stack, 0.0f);
        }
        return current;
    }

    @Override
    public float getMaxCharge(ItemStack stack) {
        return this.maxChargeCapacity;
    }

    @Override
    public float getCharge(ItemStack stack) {
        return this.readCharge(stack);
    }

    public void writeCharge(ItemStack stack, float charge) {
        stack.func_196082_o().func_74776_a(CHARGE, charge);
    }

    public float readCharge(ItemStack stack) {
        return stack.func_196082_o().func_74760_g(CHARGE);
    }

    public float getDischargeRate(float amount) {
        return amount * this.dischargeRateMultiplier;
    }

    public float getChargeRate(float amount) {
        return amount * this.chargeRateMultiplier;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack;
        if (this.isCreative && this.getCharge(stack = playerIn.func_184586_b(handIn)) == 0.0f) {
            this.charge(stack, Float.MAX_VALUE);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ConsoleTile console;
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_177230_c() == TBlocks.engine.get() && (console = (ConsoleTile)TardisHelper.getConsoleInWorld(context.func_195991_k()).orElse(null)) != null) {
            float room = console.getMaxArtron() - console.getArtron();
            float accepted = this.discharge(context.func_195996_i(), room);
            console.setArtron(console.getArtron() + accepted);
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    @Override
    public void createStatisticTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.artron_battery.charge").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.getCharge(stack))).func_240699_a_(TextFormatting.LIGHT_PURPLE).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS)));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.artron_battery.max_charge").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.getMaxCharge(stack))).func_240699_a_(TextFormatting.LIGHT_PURPLE).func_230529_a_((ITextComponent)TardisConstants.Suffix.ARTRON_UNITS)));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.artron_battery.discharge_multiplier").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.dischargeRateMultiplier)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.artron_battery.charge_multiplier").func_230529_a_((ITextComponent)new StringTextComponent(String.valueOf(this.chargeRateMultiplier)).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        if (this.isCreative && this.getCharge(stack) == 0.0f) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.artron_battery.creative_setup"));
        }
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)this.descriptionTooltip);
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public float charge(ItemStack stack, float amount) {
        return this.charge(stack, amount, false);
    }

    @Override
    public float discharge(ItemStack stack, float amount) {
        return this.discharge(stack, amount, false);
    }
}

