/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.ars.ARSPiece;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.contexts.gui.BlockPosGuiContext;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.itemgroups.TItemGroups;
import net.tardis.mod.items.misc.TooltipProviderItem;
import net.tardis.mod.properties.Prop;
import net.tardis.mod.world.dimensions.TDimensions;

public class ARSTabletItem
extends TooltipProviderItem {
    public ARSTabletItem() {
        super(Prop.Items.ONE.get().func_200916_a(TItemGroups.MAIN));
        this.setShowTooltips(true);
        this.setHasDescriptionTooltips(true);
    }

    @Nullable
    public static ARSPiece getSelectedPiece(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("piece")) {
            return ARSPiece.getRegistry().get(new ResourceLocation(tag.func_74779_i("piece")));
        }
        return null;
    }

    public static void setPiece(ItemStack stack, ARSPiece piece) {
        stack.func_196082_o().func_74778_a("piece", piece.getRegistryName().toString());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (context.func_221531_n() != null && !context.func_195991_k().func_201670_d()) {
            boolean corridorBlock;
            boolean bl = corridorBlock = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == TBlocks.corridor_spawn.get();
            if (corridorBlock && WorldHelper.areDimensionTypesSame(context.func_195991_k(), TDimensions.DimensionTypes.TARDIS_TYPE)) {
                TardisHelper.getConsoleInWorld(context.func_195991_k()).ifPresent(tile -> {
                    if (tile.canDoAdminFunction(player)) {
                        context.func_195991_k().func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                            ARSPiece piece = ARSTabletItem.getSelectedPiece(context.func_195996_i());
                            player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                                if (cap.getCountdown() > 0) {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.ars.room.delete.concurrent_mod.denied"), true);
                                } else if (piece != null) {
                                    piece.spawn((ServerWorld)context.func_195991_k(), context.func_195995_a(), player, context.func_196000_l().func_176734_d());
                                    context.func_195991_k().func_184133_a(null, context.func_195995_a(), SoundEvents.field_206938_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                } else {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.tardis.ars.structure_null"), true);
                                }
                            });
                        }));
                    } else {
                        player.func_146105_b((ITextComponent)TardisConstants.Translations.NOT_ADMIN, true);
                    }
                });
            }
        }
        if (context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == TBlocks.corridor_kill.get() && context.func_195991_k().field_72995_K) {
            ClientHelper.openGUI(17, new BlockPosGuiContext(context.func_195995_a()));
            return ActionResultType.SUCCESS;
        }
        return context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c() == TBlocks.corridor_spawn.get() ? ActionResultType.SUCCESS : super.func_195939_a(context);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            ClientHelper.openGUI(14, null);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void createDescriptionTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.ars_tablet.spawn"));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.ars_tablet.remove"));
    }

    @Override
    public void createDefaultTooltips(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.ars_tablet.piece").func_230529_a_((ITextComponent)(ARSTabletItem.getSelectedPiece(stack) == null ? new StringTextComponent("None").func_240699_a_(TextFormatting.LIGHT_PURPLE) : (ARSTabletItem.getSelectedPiece(stack).isDataPack() ? new StringTextComponent(ARSTabletItem.getSelectedPiece(stack).getDisplayName().func_150268_i()) : ARSTabletItem.getSelectedPiece(stack).getDisplayName().func_240699_a_(TextFormatting.LIGHT_PURPLE)))));
    }
}

