/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.potion.Effect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tardis.api.events.EntityOutOfWorldEvent;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.TeleportUtil;
import net.tardis.mod.subsystem.TemporalGraceSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.world.dimensions.TDimensions;

public class WorldHelper {
    public static String formatBlockPos(BlockPos pos) {
        return pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }

    public static String formatBlockPosDebug(BlockPos pos) {
        return pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p();
    }

    public static String formatDimName(RegistryKey<World> dim) {
        if (dim == null) {
            return "UNKNOWN";
        }
        String original = dim.func_240901_a_().func_110623_a().trim().replace("    ", "").replace("_", " ");
        String output = Arrays.stream(original.split("\\s+")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        return output;
    }

    public static String formatBiomeKey(RegistryKey<Biome> biomeKey) {
        if (biomeKey == null) {
            return "UNKNOWN";
        }
        String original = biomeKey.func_240901_a_().func_110623_a().trim().replace("    ", "").replace("_", " ");
        String output = Arrays.stream(original.split("\\s+")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        return output;
    }

    public static String formatStructureKey(RegistryKey<StructureFeature<?, ?>> structureKey) {
        if (structureKey == null) {
            return "UNKNOWN";
        }
        String original = structureKey.func_240901_a_().func_110623_a().trim().replace("    ", "").replace("_", " ");
        String output = Arrays.stream(original.split("\\s+")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        return output;
    }

    public static String formatStructureKey(String structureKey) {
        if (structureKey == null) {
            return "UNKNOWN";
        }
        ResourceLocation parsedRL = new ResourceLocation(structureKey);
        String original = parsedRL.func_110623_a().trim().replace("    ", "").replace("_", " ");
        String output = Arrays.stream(original.split("\\s+")).map(t -> t.substring(0, 1).toUpperCase() + t.substring(1)).collect(Collectors.joining(" "));
        return output;
    }

    public static Effect getEffectFromRL(ResourceLocation loc) {
        return (Effect)ForgeRegistries.POTIONS.getValue(loc);
    }

    public static ResourceLocation getKeyFromEffect(Effect effect) {
        return ForgeRegistries.POTIONS.getKey((IForgeRegistryEntry)effect);
    }

    public static void setFluidStateIfNot(FluidState state, World world, BlockPos pos) {
        boolean isEmpty;
        BlockState currentState = world.func_180495_p(pos);
        boolean bl = isEmpty = state.func_206886_c() == Fluids.field_204541_a;
        if (world.func_204610_c(pos).func_206886_c() != state.func_206886_c()) {
            if (currentState.isAir((IBlockReader)world, pos) || isEmpty && currentState.func_185904_a().func_76224_d()) {
                world.func_175656_a(pos, state.func_206883_i());
            } else if (world.func_180495_p(pos).func_177230_c() instanceof IWaterLoggable) {
                IWaterLoggable wat = (IWaterLoggable)currentState.func_177230_c();
                if (wat.func_204510_a((IBlockReader)world, pos, currentState, state.func_206886_c())) {
                    wat.func_204509_a((IWorld)world, pos, currentState, state.getFluidState());
                } else if (state.func_206886_c() == Fluids.field_204541_a) {
                    wat.func_204508_a((IWorld)world, pos, currentState);
                }
            }
        }
    }

    public static float getAngleBetweenPoints(Vector3d start, Vector3d end) {
        float rot = 0.0f;
        Vector3d p = start.func_178788_d(end).func_72432_b();
        float hype = (float)Math.sqrt(p.field_72450_a * p.field_72450_a + p.field_72449_c * p.field_72449_c);
        rot = p.field_72449_c < 0.0 ? (float)Math.toDegrees(Math.asin(p.field_72450_a / (double)hype)) : -((float)Math.toDegrees(Math.asin(p.field_72450_a / (double)hype))) - 180.0f;
        return rot;
    }

    public static Rotation getRotationFromDirection(Direction dir) {
        switch (dir) {
            case NORTH: {
                return Rotation.NONE;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos rotateBlockPos(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos;
            }
            case EAST: {
                return new BlockPos(-pos.func_177952_p(), pos.func_177956_o(), pos.func_177958_n());
            }
            case SOUTH: {
                return new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), -pos.func_177952_p());
            }
            case WEST: {
                return new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n());
            }
        }
        return pos;
    }

    public static Vector3d vecFromPos(Vector3i location) {
        return new Vector3d((double)location.func_177958_n() + 0.5, (double)location.func_177956_o() + 0.5, (double)location.func_177952_p() + 0.5);
    }

    public static float getFixedRotation(float rot) {
        float newR = rot % 360.0f;
        if (newR < 0.0f) {
            return 360.0f + newR;
        }
        return newR;
    }

    public static BlockPos scaleBlockPos(BlockPos pos, double scale) {
        return new BlockPos((double)pos.func_177958_n() * scale, (double)pos.func_177956_o() * scale, (double)pos.func_177952_p() * scale);
    }

    public static float getAngleFromFacing(Direction dir) {
        switch (dir) {
            case EAST: {
                return 90.0f;
            }
            case SOUTH: {
                return 180.0f;
            }
            case WEST: {
                return 270.0f;
            }
        }
        return 0.0f;
    }

    public static float getRotationDifference(float one, float two) {
        if (one > two) {
            return one - two;
        }
        return two - one;
    }

    public static <T extends Comparable<T>> BlockState cycleBlockStateProperty(BlockState state, Property<T> propertyIn) {
        return (BlockState)state.func_206870_a(propertyIn, WorldHelper.getAdjacentValue(propertyIn.func_177700_c(), state.func_177229_b(propertyIn), false));
    }

    public static <T extends Comparable<T>> BlockState cycleBlockStateProperty(BlockState state, Property<T> propertyIn, boolean backwards) {
        return (BlockState)state.func_206870_a(propertyIn, WorldHelper.getAdjacentValue(propertyIn.func_177700_c(), state.func_177229_b(propertyIn), backwards));
    }

    private static <T> T getAdjacentValue(Iterable<T> allowedValues, @Nullable T currentValue, boolean backwards) {
        return (T)(backwards ? Util.func_195648_b(allowedValues, currentValue) : Util.func_195647_a(allowedValues, currentValue));
    }

    public static RegistryKey<World> getWorldKeyFromRL(ResourceLocation loc) {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)loc);
    }

    public static ServerWorld getWorldFromRL(MinecraftServer server, ResourceLocation loc) {
        return server.func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)loc));
    }

    public static ResourceLocation getKeyFromWorld(World world) {
        ResourceLocation rl = world.func_234923_W_().func_240901_a_();
        return rl != null ? rl : new ResourceLocation("overworld");
    }

    public static List<TileEntity> getTEsInChunks(ServerWorld world, ChunkPos chunkPos, int radius) {
        ArrayList list = Lists.newArrayList();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                list.addAll(world.func_212866_a_(chunkPos.field_77276_a + x, chunkPos.field_77275_b + z).func_177434_r().values());
            }
        }
        return list;
    }

    public static DimensionType getDimensionType(MinecraftServer server, RegistryKey<DimensionType> dimTypeKey) {
        return (DimensionType)server.func_244267_aX().func_243612_b(Registry.field_239698_ad_).func_243576_d(dimTypeKey);
    }

    public static DimensionType getDimensionType(ServerWorld world, RegistryKey<DimensionType> dimTypeKey) {
        return (DimensionType)world.func_73046_m().func_244267_aX().func_243612_b(Registry.field_239698_ad_).func_243576_d(dimTypeKey);
    }

    public static DimensionType getDimensionType(World world, RegistryKey<DimensionType> dimTypeKey) {
        return (DimensionType)world.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_243576_d(dimTypeKey);
    }

    public static boolean areDimensionTypesSame(World world, RegistryKey<DimensionType> dimTypeKey) {
        if (world.func_241828_r() == null || world.func_241828_r().func_243612_b(Registry.field_239698_ad_) == null) {
            return false;
        }
        DimensionType type = (DimensionType)world.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_230516_a_(dimTypeKey);
        return type != null && type.func_242714_a(world.func_230315_m_());
    }

    public static boolean canTravelToDimension(World world) {
        ResourceLocation key = world.func_234923_W_().func_240901_a_();
        if (key == null) {
            return false;
        }
        if (WorldHelper.canTravelInDimensionType(world, world.func_230315_m_())) {
            List blacklist = (List)TConfig.SERVER.blacklistedDims.get();
            for (String s : blacklist) {
                if (!key.toString().contentEquals(s)) continue;
                return false;
            }
            return !WorldHelper.areDimensionTypesSame(world, TDimensions.DimensionTypes.TARDIS_TYPE) && !WorldHelper.areDimensionTypesSame(world, TDimensions.DimensionTypes.VORTEX_TYPE);
        }
        return false;
    }

    public static boolean canVMTravelToDimension(World world) {
        return WorldHelper.canVMTravelToDimension((RegistryKey<World>)world.func_234923_W_()) && WorldHelper.canVMBeUsedInDim(world);
    }

    public static boolean canVMTravelToDimension(RegistryKey<World> worldKey) {
        ResourceLocation key = worldKey.func_240901_a_();
        if (key == null) {
            return false;
        }
        if (((Boolean)TConfig.SERVER.toggleVMWhitelistDims.get()).booleanValue()) {
            List whitelist = (List)TConfig.SERVER.whitelistedVMDims.get();
            for (String s : whitelist) {
                if (!key.toString().contentEquals(s)) continue;
                return true;
            }
            return false;
        }
        if (!((Boolean)TConfig.SERVER.toggleVMWhitelistDims.get()).booleanValue()) {
            List blacklist = (List)TConfig.SERVER.blacklistedVMDims.get();
            for (String s : blacklist) {
                if (!key.toString().contentEquals(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canVMBeUsedInDim(World world) {
        return !WorldHelper.areDimensionTypesSame(world, TDimensions.DimensionTypes.TARDIS_TYPE) && !WorldHelper.areDimensionTypesSame(world, TDimensions.DimensionTypes.VORTEX_TYPE);
    }

    public static boolean isDimensionBlocked(World world) {
        return !WorldHelper.areDimensionTypesSame(world, TDimensions.DimensionTypes.TARDIS_TYPE);
    }

    public static List<World> getAllValidDimensions() {
        ArrayList<World> dims = new ArrayList<World>();
        for (ServerWorld dimension : ServerLifecycleHooks.getCurrentServer().func_212370_w()) {
            if (!WorldHelper.canTravelToDimension((World)dimension)) continue;
            dims.add((World)dimension);
        }
        return dims;
    }

    public static boolean canTravelInDimensionType(World world, DimensionType dimType) {
        RegistryKey dimTypeKey = world.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_230519_c_((Object)dimType).orElse(null);
        if (dimTypeKey != null) {
            ResourceLocation dimTypeLoc = dimTypeKey.func_240901_a_();
            for (String blocked : (List)TConfig.SERVER.blacklistedDimTypes.get()) {
                if (dimTypeLoc.toString().equals(blocked)) {
                    return false;
                }
                if (!blocked.endsWith("*")) continue;
                String modid = blocked.substring(0, blocked.indexOf(58));
                if (!dimTypeLoc.func_110624_b().equals(modid)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canBrokenTardisSpawn(RegistryKey<World> worldKey) {
        ResourceLocation worldLoc = worldKey.func_240901_a_();
        for (String blocked : (List)TConfig.COMMON.tardisSpawnDimBlacklist.get()) {
            if (worldLoc.toString().equals(blocked)) {
                return false;
            }
            if (!blocked.endsWith("*")) continue;
            String modid = blocked.substring(0, blocked.indexOf(58));
            if (!worldLoc.func_110624_b().equals(modid)) continue;
            return false;
        }
        return true;
    }

    public static boolean canEntitySpawnInTardis(EntityType<?> type) {
        ResourceLocation entityTypeLoc = type.getRegistryName();
        for (String blocked : (List)TConfig.SERVER.tardisDimEntitySpawnBlacklist.get()) {
            if (entityTypeLoc.toString().equals(blocked)) {
                return false;
            }
            if (!blocked.endsWith("*")) continue;
            String modid = blocked.substring(0, blocked.indexOf(58));
            if (!entityTypeLoc.func_110624_b().equals(modid)) continue;
            return false;
        }
        return true;
    }

    public static boolean forceChunkIfNotLoaded(ServerWorld world, ChunkPos chunkPos, BlockPos blockPos) {
        if (ForgeChunkManager.forceChunk((ServerWorld)world, (String)"tardis", (BlockPos)blockPos, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (boolean)true, (boolean)true)) {
            WorldHelper.forceChunkVanillaIfNotLoaded(world, chunkPos);
            WorldHelper.markChunkDirty((World)world, blockPos);
            return true;
        }
        return false;
    }

    public static boolean unForceChunkIfLoaded(ServerWorld world, ChunkPos chunkPos, BlockPos blockPos) {
        if (ForgeChunkManager.forceChunk((ServerWorld)world, (String)"tardis", (BlockPos)blockPos, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (boolean)false, (boolean)true)) {
            WorldHelper.unforceChunkVanillaIfLoaded(world, chunkPos);
            WorldHelper.markChunkDirty((World)world, blockPos);
            return true;
        }
        return false;
    }

    public static boolean isBlockLoaded(@Nullable IBlockReader world, @Nonnull BlockPos pos) {
        if (world == null || !World.func_175701_a((BlockPos)pos)) {
            return false;
        }
        if (world instanceof IWorldReader) {
            return ((IWorldReader)world).func_175667_e(pos);
        }
        return true;
    }

    public static void markChunkDirty(World world, BlockPos pos) {
        if (WorldHelper.isBlockLoaded((IBlockReader)world, pos)) {
            world.func_175726_f(pos).func_76630_e();
        }
    }

    public static Map<ForgeChunkManager.TicketOwner<BlockPos>, LongSet> getTickingBlockForcedChunks(ServerWorld serverWorld) {
        ForcedChunksSaveData data = (ForcedChunksSaveData)serverWorld.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        if (data != null) {
            return data.getBlockForcedChunks().getTickingChunks();
        }
        return null;
    }

    public static boolean preLoadTardisInteriorChunks(ServerWorld targetWorld, boolean force) {
        if (WorldHelper.areDimensionTypesSame((World)targetWorld, TDimensions.DimensionTypes.TARDIS_TYPE)) {
            ServerWorld serverWorld = targetWorld.func_73046_m().func_71218_a(targetWorld.func_234923_W_());
            ChunkPos cPos = new ChunkPos(TardisHelper.TARDIS_POS);
            for (int xPos = -3; xPos < 3; ++xPos) {
                for (int zPos = -3; zPos < 3; ++zPos) {
                    ChunkPos toLoadPos = new ChunkPos(cPos.field_77276_a + xPos, cPos.field_77275_b + zPos);
                    if (force) {
                        WorldHelper.forceChunkIfNotLoaded(serverWorld, toLoadPos, TardisHelper.TARDIS_POS);
                        continue;
                    }
                    WorldHelper.unForceChunkIfLoaded(serverWorld, toLoadPos, TardisHelper.TARDIS_POS);
                }
            }
            return true;
        }
        return false;
    }

    public static Entity teleportEntities(Entity e, ServerWorld world, BlockPos pos, float yaw, float pitch) {
        return WorldHelper.teleportEntities(e, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), yaw, pitch);
    }

    public static Entity teleportEntities(Entity e, ServerWorld world, double x, double y, double z, float yaw, float pitch) {
        return TeleportUtil.teleportEntity(e, world, x, y, z, yaw, pitch);
    }

    public static boolean forceChunkVanillaIfNotLoaded(ServerWorld world, ChunkPos pos) {
        if (!world.func_217469_z().contains(pos.func_201841_a())) {
            world.func_217458_b(pos.field_77276_a, pos.field_77275_b, true);
            return true;
        }
        return false;
    }

    public static boolean unforceChunkVanillaIfLoaded(ServerWorld world, ChunkPos pos) {
        if (world.func_217469_z().contains(pos.func_201841_a())) {
            world.func_217458_b(pos.field_77276_a, pos.field_77275_b, false);
            return true;
        }
        return false;
    }

    public static void maybeDisableShield(PlayerEntity player, LivingEntity attackingEntity, ItemStack heldItem, ItemStack playerHeldItem) {
        if (!heldItem.func_190926_b() && !playerHeldItem.func_190926_b() && heldItem.func_77973_b() instanceof AxeItem && playerHeldItem.func_77973_b() instanceof ShieldItem) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)attackingEntity) * 0.05f;
            if (attackingEntity.field_70170_p.field_73012_v.nextFloat() < f) {
                ShieldItem shield = (ShieldItem)playerHeldItem.func_77973_b();
                player.func_184811_cZ().func_185145_a((Item)shield, 100);
                player.func_184602_cy();
                attackingEntity.field_70170_p.func_72960_a((Entity)player, (byte)30);
            }
        }
    }

    public static void maybeDisableShieldNoEnchant(PlayerEntity player, LivingEntity attackingEntity, ItemStack heldItem, ItemStack playerHeldItem) {
        if (!heldItem.func_190926_b() && !playerHeldItem.func_190926_b() && playerHeldItem.func_77973_b() instanceof ShieldItem) {
            float f = 0.25f;
            if (attackingEntity.field_70170_p.field_73012_v.nextFloat() < f) {
                ShieldItem shield = (ShieldItem)playerHeldItem.func_77973_b();
                player.func_184811_cZ().func_185145_a((Item)shield, 100);
                player.func_184602_cy();
                attackingEntity.field_70170_p.func_72960_a((Entity)player, (byte)30);
            }
        }
    }

    public static Quaternion getStandardRotationFor(BlockState state) {
        return Vector3f.field_229181_d_.func_229187_a_(WorldHelper.getAngleFromFacing(WorldHelper.getFacingForState(state)));
    }

    public static Direction getFacingForState(BlockState state) {
        if (state.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208156_I)) {
            return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208156_I);
        }
        return Direction.NORTH;
    }

    public static void handleEntityOutOfWorld(Entity entity) {
        if (entity == null) {
            return;
        }
        EntityOutOfWorldEvent event = new EntityOutOfWorldEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            entity.func_70106_y();
        }
    }

    public static boolean handleTardisVoidSaving(Entity entity) {
        if (entity != null) {
            if (!entity.func_130014_f_().func_201670_d() && (entity instanceof LivingEntity && entity.func_200600_R().func_220339_d() != EntityClassification.MONSTER || entity.func_200600_R() != TEntities.TARDIS.get() && entity.func_200600_R() != TEntities.TARDIS_BACKDOOR.get() && entity.func_200600_R() != TEntities.CONTROL.get())) {
                if (WorldHelper.areDimensionTypesSame(entity.func_130014_f_(), TDimensions.DimensionTypes.TARDIS_TYPE)) {
                    ConsoleTile tile;
                    if (entity.func_233580_cy_().func_177956_o() <= -64 && TardisHelper.getConsoleInWorld(entity.func_130014_f_()).isPresent() && (tile = TardisHelper.getConsoleInWorld(entity.func_130014_f_()).get()).getSubsystem(TemporalGraceSubsystem.class).isPresent()) {
                        TemporalGraceSubsystem grace = (TemporalGraceSubsystem)tile.getSubsystem(TemporalGraceSubsystem.class).orElseGet(null);
                        if (grace.canBeUsed() && grace.isActivated()) {
                            if (tile.getDoor().isPresent()) {
                                tile.getDoor().ifPresent(door -> WorldHelper.teleportEntities(entity, (ServerWorld)entity.func_130014_f_(), door.func_233580_cy_(), entity.field_70177_z, entity.field_70125_A));
                            } else {
                                BlockPos fallBackTeleportPos = TardisHelper.TARDIS_POS.func_177984_a().func_185334_h();
                                WorldHelper.teleportEntities(entity, (ServerWorld)entity.func_130014_f_(), fallBackTeleportPos, entity.field_70177_z, entity.field_70125_A);
                            }
                            entity.field_70143_R = 0.0f;
                            entity.func_230245_c_(true);
                            return true;
                        }
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return false;
        }
        return false;
    }
}

