/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.mojang.authlib.GameProfile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.schematics.Schematic;
import net.tardis.mod.tileentities.ConsoleTile;

public class TextHelper {
    public static TextComponent createTextComponentWithTip(String text, String tooltipText) {
        StringTextComponent textComponent = new StringTextComponent("[" + text + "]");
        textComponent.func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(tooltipText))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, tooltipText)));
        return textComponent;
    }

    public static TextComponent createTextComponentWithTipSuggest(String text, String tooltipText) {
        StringTextComponent textComponent = new StringTextComponent("[" + text + "]");
        textComponent.func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(tooltipText))).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, tooltipText)));
        return textComponent;
    }

    public static TextComponent createTextWithoutTooltipCopying(String text, String tooltipText) {
        StringTextComponent textComponent = new StringTextComponent("[" + text + "]");
        textComponent.func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(tooltipText))).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)));
        return textComponent;
    }

    public static TextComponent createTextWithoutTooltip(String text) {
        StringTextComponent textComponent = new StringTextComponent("[" + text + "]");
        textComponent.func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, text)));
        return textComponent;
    }

    public static TextComponent getTardisTextObject(ServerWorld world, ITardisWorldData data) {
        return TextHelper.createTextComponentWithTip(data.getTARDISName(), world.func_234923_W_().func_240901_a_().toString());
    }

    public static TextComponent getTardisDimObject(ServerWorld world, ITardisWorldData data) {
        return TextHelper.createTextWithoutTooltipCopying(world.func_234923_W_().func_240901_a_().toString(), data.getTARDISName());
    }

    public static TextComponent getTardisTextObject(ServerWorld world) {
        Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
        TextComponent[] tardisTextObject = new TextComponent[1];
        console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
            tardisTextObject[0] = TextHelper.getTardisTextObject(world, data);
        }));
        return tardisTextObject != null ? tardisTextObject[0] : new StringTextComponent(world.func_234923_W_().func_240901_a_().toString());
    }

    public static TextComponent getTardisDimObject(ServerWorld world) {
        Optional<ConsoleTile> console = TardisHelper.getConsoleInWorld((World)world);
        TextComponent[] tardisTextObject = new TextComponent[1];
        console.ifPresent(tile -> tile.func_145831_w().getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
            tardisTextObject[0] = TextHelper.getTardisDimObject(world, data);
        }));
        return tardisTextObject[0] != null ? tardisTextObject[0] : new StringTextComponent(world.func_234923_W_().func_240901_a_().toString());
    }

    public static TextComponent getPlayerTextObject(ServerWorld world, UUID id) {
        GameProfile profileByUUID = world.func_73046_m().func_152358_ax().func_152652_a(id);
        String playerName = profileByUUID != null ? profileByUUID.getName() : "OFFLINE Player";
        return TextHelper.createTextComponentWithTip(playerName, id.toString());
    }

    public static TextComponent getBlockPosObject(BlockPos pos) {
        String formattedPos = WorldHelper.formatBlockPosDebug(pos);
        return TextHelper.createTextWithoutTooltip(formattedPos);
    }

    public static List<ITextComponent> combineMultipleComponents(ITextComponent ... components) {
        ArrayList<ITextComponent> allComponents = new ArrayList<ITextComponent>();
        for (ITextComponent component : components) {
            allComponents.add(component);
        }
        return allComponents;
    }

    public static List<ITextComponent> createFluidTankToolTip(FluidTank tank) {
        if (tank.getFluid().isEmpty()) {
            return TextHelper.combineMultipleComponents(new ITextComponent[]{TardisConstants.ContainerComponentTranslations.EMPTY_FLUID});
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        FluidStack fluid = tank.getFluid();
        IFormattableTextComponent fluidComponent = new TranslationTextComponent("tooltip.tardis.container.fluid").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD)).func_240702_b_(TextHelper.getFluidName(fluid));
        IFormattableTextComponent component = new StringTextComponent(decimalFormat.format(tank.getFluidAmount())).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)TardisConstants.ContainerComponentTranslations.FORWARD_SLASH).func_230529_a_((ITextComponent)new StringTextComponent(decimalFormat.format(tank.getCapacity())).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD)).func_230529_a_((ITextComponent)TardisConstants.Suffix.MILLIBUCKETS));
        return TextHelper.combineMultipleComponents(new ITextComponent[]{fluidComponent, component});
    }

    public static List<ITextComponent> createSpecialCaseFluidTankToolTip(int currentFluid, int maxFluid, IFormattableTextComponent fluidName) {
        if (currentFluid == 0) {
            return TextHelper.combineMultipleComponents(new ITextComponent[]{TardisConstants.ContainerComponentTranslations.EMPTY_FLUID});
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        IFormattableTextComponent fluidComponent = new TranslationTextComponent("tooltip.tardis.container.fluid").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD)).func_230529_a_((ITextComponent)fluidName);
        IFormattableTextComponent component = new StringTextComponent(decimalFormat.format(currentFluid)).func_240699_a_(TextFormatting.GOLD).func_230529_a_((ITextComponent)TardisConstants.ContainerComponentTranslations.FORWARD_SLASH).func_230529_a_((ITextComponent)new StringTextComponent(decimalFormat.format(maxFluid)).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD)).func_230529_a_((ITextComponent)TardisConstants.Suffix.MILLIBUCKETS));
        return TextHelper.combineMultipleComponents(new ITextComponent[]{fluidComponent, component});
    }

    public static String getFluidName(FluidStack stack) {
        return new TranslationTextComponent(stack.getFluid().getAttributes().getTranslationKey(stack)).getString();
    }

    public static TranslationTextComponent getFluidNameTranslation(FluidStack stack) {
        return new TranslationTextComponent(stack.getFluid().getAttributes().getTranslationKey(stack));
    }

    public static List<ITextComponent> createProgressBarTooltip(int currentProgress, int maxProgressTicks, boolean staticDisplay) {
        DecimalFormat decimalFormat = new DecimalFormat();
        StringTextComponent currentProgressText = new StringTextComponent(decimalFormat.format(currentProgress));
        currentProgressText.func_240700_a_(style -> style.func_240712_a_(TextFormatting.WHITE));
        StringTextComponent maxProgressText = new StringTextComponent(decimalFormat.format(maxProgressTicks));
        maxProgressText.func_240700_a_(style -> style.func_240712_a_(TextFormatting.WHITE));
        IFormattableTextComponent progress = new TranslationTextComponent("tooltip.tardis.container.progress").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD));
        progress.func_230529_a_((ITextComponent)currentProgressText).func_230529_a_((ITextComponent)TardisConstants.ContainerComponentTranslations.FORWARD_SLASH).func_230529_a_((ITextComponent)maxProgressText);
        IFormattableTextComponent eta = new TranslationTextComponent("tooltip.tardis.container.estimated_time_arrival").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD));
        double time = (double)(maxProgressTicks - currentProgress) / 20.0;
        double etaTime = currentProgress <= maxProgressTicks && currentProgress != 0 ? time : (staticDisplay ? time : 0.0);
        StringTextComponent maxEtaText = new StringTextComponent(decimalFormat.format(Math.ceil(etaTime)));
        maxEtaText.func_240700_a_(style -> style.func_240712_a_(TextFormatting.WHITE));
        TranslationTextComponent seconds = new TranslationTextComponent("tooltip.tardis.container.seconds");
        eta.func_230529_a_((ITextComponent)maxEtaText).func_230529_a_((ITextComponent)seconds);
        return (Boolean)TConfig.CLIENT.showMoreMachineTooltips.get() != false ? TextHelper.combineMultipleComponents(new ITextComponent[]{progress, eta}) : TextHelper.combineMultipleComponents(new ITextComponent[]{eta});
    }

    public static List<ITextComponent> createProgressBarTooltip(int currentProgress, int maxProgressTicks) {
        return TextHelper.createProgressBarTooltip(currentProgress, maxProgressTicks, false);
    }

    public static List<ITextComponent> createProgressBarTooltipPercentage(float progressPercent) {
        DecimalFormat decimalFormat = new DecimalFormat();
        double currentProgress = (double)progressPercent * 100.0;
        int maxProgress = 100;
        StringTextComponent currentProgressText = new StringTextComponent(decimalFormat.format(currentProgress));
        currentProgressText.func_240700_a_(style -> style.func_240712_a_(TextFormatting.WHITE));
        StringTextComponent maxProgressText = new StringTextComponent(decimalFormat.format(maxProgress));
        maxProgressText.func_240700_a_(style -> style.func_240712_a_(TextFormatting.WHITE));
        IFormattableTextComponent progress = new TranslationTextComponent("tooltip.tardis.container.progress").func_240700_a_(style -> style.func_240712_a_(TextFormatting.GOLD));
        progress.func_230529_a_((ITextComponent)currentProgressText).func_230529_a_((ITextComponent)TardisConstants.ContainerComponentTranslations.FORWARD_SLASH).func_230529_a_((ITextComponent)maxProgressText);
        return TextHelper.combineMultipleComponents(new ITextComponent[]{progress});
    }

    public static IFormattableTextComponent createDescriptionItemTooltip(IFormattableTextComponent descriptionTooltip) {
        return TardisConstants.Prefix.TOOLTIP_ITEM_DESCRIPTION.func_230532_e_().func_230529_a_((ITextComponent)descriptionTooltip.func_240699_a_(TextFormatting.GRAY));
    }

    public static IFormattableTextComponent createExtraLineItemTooltip(IFormattableTextComponent descriptionTooltip) {
        return descriptionTooltip.func_240699_a_(TextFormatting.GRAY).func_230532_e_();
    }

    public static IFormattableTextComponent createVortexManipMessage(IFormattableTextComponent descriptionTooltip) {
        return TardisConstants.Prefix.VORTEX_M_HEADER.func_230532_e_().func_240702_b_("\n").func_230529_a_((ITextComponent)descriptionTooltip.func_230532_e_());
    }

    public static List<ITextComponent> getSchematicsInList(List<Schematic> schematics) {
        HashSet<Schematic> distinctSchematics = new HashSet<Schematic>();
        distinctSchematics.addAll(schematics);
        ArrayList<ITextComponent> schematicTexts = new ArrayList<ITextComponent>();
        distinctSchematics.forEach(entry -> {
            int count = Collections.frequency(schematics, entry);
            if (entry != null) {
                schematicTexts.add((ITextComponent)new StringTextComponent("- " + entry.getDisplayName()).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.gui.count", new Object[]{count})));
            }
        });
        return schematicTexts;
    }
}

