/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.MinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.network.play.server.SServerDifficultyPacket;
import net.minecraft.network.play.server.SSetExperiencePacket;
import net.minecraft.network.play.server.SSetPassengersPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.helper.WorldHelper;

public class TeleportUtil {
    public static Entity teleportEntity(Entity entity, ServerWorld dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        ServerWorld sourceDim = entity.func_184102_h().func_71218_a(entity.func_130014_f_().func_234923_W_());
        if (!entity.func_184207_aI() && !entity.func_184218_aH()) {
            return TeleportUtil.handleEntityTeleport(entity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        }
        Entity rootEntity = entity.func_184208_bv();
        TeleportUtil.handleEntityTeleport(rootEntity, server, sourceDim, dimension, xCoord, yCoord, zCoord, yaw, pitch);
        return rootEntity;
    }

    public static Entity teleportEntity(Entity entity, ServerWorld dimension, double xCoord, double yCoord, double zCoord) {
        return TeleportUtil.teleportEntity(entity, dimension, xCoord, yCoord, zCoord, entity.field_70177_z, entity.field_70125_A);
    }

    private static Entity handleEntityTeleport(Entity entity, MinecraftServer server, ServerWorld sourceDim, ServerWorld targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.func_201670_d()) {
            return entity;
        }
        if (entity.func_200600_R() == ForgeRegistries.ENTITIES.getValue(EntityType.field_200802_p.getRegistryName()) || entity.func_200600_R() == TEntities.TARDIS.get() || entity.func_200600_R() == TEntities.DISPLAY_TARDIS.get()) {
            return entity;
        }
        boolean bl = interDimensional = !sourceDim.func_234923_W_().func_240901_a_().equals((Object)targetDim.func_234923_W_().func_240901_a_());
        if (!interDimensional) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).func_184613_cA()) {
                entity.func_213317_d(entity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                entity.func_230245_c_(true);
            }
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                if (player.func_130014_f_().func_234923_W_() == targetDim.func_234923_W_()) {
                    player.field_71135_a.func_147364_a(xCoord, yCoord, zCoord, yaw, pitch);
                }
            } else {
                entity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
                entity.func_70034_d(yaw);
            }
            return entity;
        }
        if (interDimensional && !ForgeHooks.onTravelToDimension((Entity)entity, (RegistryKey)targetDim.func_234923_W_())) {
            return entity;
        }
        if (entity instanceof ServerPlayerEntity) {
            return TeleportUtil.teleportPlayerInterdimensional((ServerPlayerEntity)entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }
        return TeleportUtil.teleportEntityInterdimensional(entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
    }

    private static Entity teleportEntityInterdimensional(Entity entity, MinecraftServer server, ServerWorld sourceDim, ServerWorld targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ServerWorld sourceWorld = sourceDim;
        ServerWorld targetWorld = targetDim;
        Entity old = entity;
        old.func_213319_R();
        Entity newEntity = entity.func_200600_R().func_200721_a((World)targetWorld);
        if (old.func_70089_S() && entity instanceof MinecartEntity) {
            old.remove(true);
            old.func_241206_a_(targetWorld);
            old.revive();
        }
        if (old instanceof FishingBobberEntity) {
            FishingBobberEntity bobber = (FishingBobberEntity)old;
            old.remove(true);
            ServerPlayerEntity player = (ServerPlayerEntity)bobber.func_234606_i_();
            newEntity = new FishingBobberEntity((PlayerEntity)player, (World)targetWorld, 0, 0);
        }
        sourceWorld.func_217467_h(old);
        sourceWorld.func_217479_a(old);
        if (newEntity != null) {
            newEntity.func_180432_n(old);
            newEntity.func_70012_b(xCoord, yCoord, zCoord, yaw, pitch);
            targetWorld.func_217460_e(newEntity);
            targetWorld.func_217479_a(newEntity);
        } else {
            System.err.println("Error teleporting entity: " + old);
            System.err.println("Entity that was teleported: " + newEntity);
        }
        sourceWorld.func_82742_i();
        targetWorld.func_82742_i();
        if (!(newEntity instanceof LivingEntity) || !((LivingEntity)newEntity).func_184613_cA()) {
            newEntity.func_213317_d(newEntity.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            newEntity.func_230245_c_(true);
        }
        return newEntity;
    }

    private static PlayerEntity teleportPlayerInterdimensional(ServerPlayerEntity player, MinecraftServer server, ServerWorld sourceDim, ServerWorld destination, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(xCoord, yCoord, zCoord));
        destination.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkpos, 1, (Object)player.func_145782_y());
        WorldHelper.preLoadTardisInteriorChunks(destination.getWorldServer(), true);
        if (player.func_70608_bn()) {
            player.func_213366_dy();
        }
        ServerWorld destinationServerWorld = destination;
        player.func_200619_a(destinationServerWorld, xCoord, yCoord, zCoord, yaw, pitch);
        for (EffectInstance effectinstance : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effectinstance));
        }
        IWorldInfo worldinfo = player.field_70170_p.func_72912_H();
        player.field_71135_a.func_147359_a((IPacket)new SSetExperiencePacket(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        player.field_71135_a.func_147359_a((IPacket)new SServerDifficultyPacket(worldinfo.func_176130_y(), worldinfo.func_176123_z()));
        return player;
    }

    public static Entity getHighestRidingEntity(Entity mount) {
        Entity entity = mount;
        while (entity.func_184188_bt().size() > 0) {
            entity = (Entity)entity.func_184188_bt().get(0);
        }
        return entity;
    }

    public static class PassengerHelper {
        public Entity entity;
        public LinkedList<PassengerHelper> passengers = new LinkedList();
        public double offsetX;
        public double offsetY;
        public double offsetZ;

        public PassengerHelper(Entity entity) {
            this.entity = entity;
            if (entity.func_184218_aH()) {
                this.offsetX = entity.func_226277_ct_() - entity.func_184187_bx().func_226277_ct_();
                this.offsetY = entity.func_226278_cu_() - entity.func_184187_bx().func_226278_cu_();
                this.offsetZ = entity.func_226281_cx_() - entity.func_184187_bx().func_226281_cx_();
            }
            for (Entity passenger : entity.func_184188_bt()) {
                this.passengers.add(new PassengerHelper(passenger));
            }
        }

        public void teleport(MinecraftServer server, ServerWorld sourceDim, ServerWorld targetDim, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
            this.entity.func_184226_ay();
            for (PassengerHelper passenger : this.passengers) {
                TeleportUtil.handleEntityTeleport(passenger.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
            }
            this.entity = TeleportUtil.handleEntityTeleport(this.entity, server, sourceDim, targetDim, xCoord, yCoord, zCoord, yaw, pitch);
        }

        public void remountRiders() {
            if (this.entity.func_184218_aH()) {
                this.entity.func_70012_b(this.entity.func_226277_ct_() + this.offsetX, this.entity.func_226278_cu_() + this.offsetY, this.entity.func_226281_cx_() + this.offsetZ, this.entity.field_70177_z, this.entity.field_70125_A);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.entity.func_184205_a(this.entity, true);
                passenger.remountRiders();
            }
        }

        public void updateClients() {
            if (this.entity instanceof ServerPlayerEntity) {
                this.updateClient((ServerPlayerEntity)this.entity);
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        private void updateClient(ServerPlayerEntity playerMP) {
            if (this.entity.func_184207_aI()) {
                playerMP.field_71135_a.func_147359_a((IPacket)new SSetPassengersPacket(this.entity));
            }
            for (PassengerHelper passenger : this.passengers) {
                passenger.updateClients();
            }
        }

        public PassengerHelper getPassenger(Entity passenger) {
            if (this.entity == passenger) {
                return this;
            }
            for (PassengerHelper rider : this.passengers) {
                PassengerHelper re = rider.getPassenger(passenger);
                if (re == null) continue;
                return re;
            }
            return null;
        }
    }
}

