/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.tardis.mod.Tardis;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.TItems;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.inventory.PanelInventory;
import net.tardis.mod.world.dimensions.TDimensions;
import org.apache.logging.log4j.Level;

public class TardisHelper {
    public static final BlockPos TARDIS_POS = new BlockPos(0, 128, 0).func_185334_h();

    public static boolean isInATardis(PlayerEntity player) {
        return WorldHelper.areDimensionTypesSame(player.func_130014_f_(), TDimensions.DimensionTypes.TARDIS_TYPE);
    }

    public static ServerWorld setupTardisDim(MinecraftServer server, BlockState consoleBlock, ConsoleRoom room) {
        ServerWorld tardisWorld = TDimensions.registerOrGetTardisDim(UUID.randomUUID().toString(), server);
        if (tardisWorld != null && !(tardisWorld.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) {
            tardisWorld.func_180501_a(TARDIS_POS, consoleBlock, 3);
            ConsoleTile console = (ConsoleTile)tardisWorld.func_175625_s(TARDIS_POS);
            console.onInitialSpawn();
        }
        room.spawnConsoleRoom(tardisWorld, true);
        tardisWorld.getCapability(Capabilities.TARDIS_DATA).ifPresent(cap -> {
            PanelInventory inv = cap.getEngineInventoryForSide(Direction.WEST);
            for (int i = 0; i < inv.getSlots(); ++i) {
                inv.setStackInSlot(i, tardisWorld.field_73012_v.nextDouble() < 0.1 ? new ItemStack((IItemProvider)TItems.LEAKY_ARTRON_CAPACITOR.get()) : ItemStack.field_190927_a);
            }
        });
        return tardisWorld;
    }

    public static Optional<ConsoleTile> getConsole(MinecraftServer server, ResourceLocation key) {
        for (ServerWorld nextWorld : server.func_212370_w()) {
            TileEntity te;
            ServerWorld world;
            ResourceLocation name = nextWorld.func_234923_W_().func_240901_a_();
            if (name == null || !name.toString().contentEquals(key.toString()) || (world = server.func_71218_a(nextWorld.func_234923_W_())) == null || !((te = world.func_175625_s(TARDIS_POS)) instanceof ConsoleTile)) continue;
            return Optional.of((ConsoleTile)te);
        }
        return Optional.empty();
    }

    public static LazyOptional<ConsoleTile> getConsole(MinecraftServer server, RegistryKey<World> worldKey) {
        ServerWorld serverWorld = server.func_71218_a(worldKey);
        return TardisHelper.getConsole(server, (World)serverWorld);
    }

    public static LazyOptional<ConsoleTile> getConsole(MinecraftServer server, World world) {
        try {
            TileEntity te;
            ServerWorld serverWorld = server.func_71218_a(world.func_234923_W_());
            if (serverWorld != null && (te = serverWorld.func_175625_s(TARDIS_POS)) instanceof ConsoleTile) {
                return LazyOptional.of(() -> (ConsoleTile)te);
            }
            return LazyOptional.empty();
        }
        catch (Exception e) {
            Tardis.LOGGER.catching(Level.DEBUG, (Throwable)e);
            return LazyOptional.empty();
        }
    }

    public static Optional<ConsoleTile> getConsoleInWorld(World world) {
        TileEntity te = world.func_175625_s(TARDIS_POS);
        if (te instanceof ConsoleTile) {
            return Optional.of((ConsoleTile)te);
        }
        return Optional.empty();
    }

    public static List<ServerWorld> getTardises(MinecraftServer server) {
        ArrayList list = Lists.newArrayList();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) continue;
            list.add(world);
        }
        return list;
    }

    public static Set<RegistryKey<World>> getTardisWorldKeys(MinecraftServer server) {
        HashSet set = Sets.newHashSet();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) continue;
            set.add(world.func_234923_W_());
        }
        return set;
    }

    public static Set<RegistryKey<World>> getTardisWorldKeysByPlayer(MinecraftServer server, ServerPlayerEntity player) {
        HashSet set = Sets.newHashSet();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) continue;
            ConsoleTile console = (ConsoleTile)world.func_175625_s(TARDIS_POS);
            for (UUID uuid : console.getEmotionHandler().getLoyaltyTrackingCrew()) {
                if (!uuid.equals(player.func_110124_au())) continue;
                set.add(world.func_234923_W_());
            }
        }
        return set;
    }

    public static Set<String> getTardisNames(MinecraftServer server) {
        HashSet set = Sets.newHashSet();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) continue;
            world.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> set.add(data.getTARDISName().replace(" ", "")));
        }
        return set;
    }

    public static Set<String> getTardisNamesByWorldKey(MinecraftServer server, RegistryKey<World> worldKey) {
        HashSet set = Sets.newHashSet();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile) || world.func_234923_W_() != worldKey) continue;
            world.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> set.add(data.getTARDISName().replace(" ", "")));
        }
        return set;
    }

    public static Map<RegistryKey<World>, String> getTardisNamesAndWorldsByPlayer(MinecraftServer server, ServerPlayerEntity player) {
        HashMap<RegistryKey<World>, String> map = new HashMap<RegistryKey<World>, String>();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) continue;
            ConsoleTile console = (ConsoleTile)world.func_175625_s(TARDIS_POS);
            for (UUID uuid : console.getEmotionHandler().getLoyaltyTrackingCrew()) {
                if (!uuid.equals(player.func_110124_au())) continue;
                world.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> map.put(world.func_234923_W_(), data.getTARDISName()));
            }
        }
        return map;
    }

    public static Collection<String> getTardisNamesForPlayer(MinecraftServer server, ServerPlayerEntity player) {
        Collection<String> collection = TardisHelper.getTardisNamesAndWorldsByPlayer(server, player).values();
        return collection;
    }

    public static Set<RegistryKey<World>> getTardisWorldKeyByName(MinecraftServer server, String tardisName) {
        HashSet set = Sets.newHashSet();
        for (ServerWorld world : server.func_212370_w()) {
            world.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> {
                if (data.getTARDISName().replace(" ", "").contentEquals(tardisName)) {
                    set.add(world.func_234923_W_());
                }
            });
        }
        return set;
    }

    public static Map<RegistryKey<World>, String> getTardisWorldKeyAndNames(MinecraftServer server) {
        HashMap<RegistryKey<World>, String> map = new HashMap<RegistryKey<World>, String>();
        for (ServerWorld world : server.func_212370_w()) {
            if (!world.isAreaLoaded(TARDIS_POS, 0) || !(world.func_175625_s(TARDIS_POS) instanceof ConsoleTile)) continue;
            world.getCapability(Capabilities.TARDIS_DATA).ifPresent(data -> map.put(world.func_234923_W_(), data.getTARDISName()));
        }
        return map;
    }
}

