/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.tardis.mod.Tardis;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.items.DebugItem;
import net.tardis.mod.items.PlasmicShellItem;
import net.tardis.mod.items.SquarenessGunItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.items.misc.IAttunable;
import net.tardis.mod.registries.SonicModeRegistry;
import net.tardis.mod.tileentities.machines.TransductionBarrierTile;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class TRenderHelper {
    private static float lastBrightnessX = GlStateManager.lastBrightnessX;
    private static float lastBrightnessY = GlStateManager.lastBrightnessY;
    private static final FloatBuffer FLOAT_4_BUFFER = GLAllocation.func_74529_h((int)4);

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = GlStateManager.lastBrightnessX;
        lastBrightnessY = GlStateManager.lastBrightnessY;
        GL13.glMultiTexCoord2f((int)33985, (float)x, (float)y);
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static float getRenderPartialTicks() {
        return TRenderHelper.mc().func_184121_ak();
    }

    public static void restoreLightMap() {
        GL13.glMultiTexCoord2f((int)33985, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void renderFilledBox(Matrix4f matrix, IVertexBuilder builder, AxisAlignedBB boundingBox, float red, float green, float blue, float alpha, int combinedLightIn) {
        TRenderHelper.renderFilledBox(matrix, builder, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f, red, green, blue, alpha, combinedLightIn);
    }

    public static void renderFilledBox(Matrix4f matrix, IVertexBuilder builder, float startX, float startY, float startZ, float endX, float endY, float endZ, float red, float green, float blue, float alpha, int combinedLightIn) {
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
    }

    public static void renderInsideBox(MatrixStack matrixStack, IVertexBuilder buffer, float partialTicks, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, float red, float green, float blue, float alpha) {
        MatrixStack.Entry matrixstackEntry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = matrixstackEntry.func_227870_a_();
        Matrix3f matrix3f = matrixstackEntry.func_227872_b_();
        float per = (float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 200L) / 200.0f;
        float maxU = 1.0f;
        float maxV = per + 0.25f;
        float minV = per;
        buffer.func_227888_a_(matrix4f, (float)minX, (float)minY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)minY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, minV).func_227885_a_(red, green, blue, alpha).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)maxY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)maxY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)minY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)maxY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)maxY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)minY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)minY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)maxY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)maxY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)minX, (float)minY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)minY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)minY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, minV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)maxY, (float)maxZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(maxU, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix4f, (float)maxX, (float)maxY, (float)minZ).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, maxV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrix3f, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void drawSelectionBoxMask(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        TRenderHelper.drawMask(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, red, green, blue, alpha);
    }

    public static void drawMask(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        TRenderHelper.drawMask(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        tessellator.func_78381_a();
    }

    public static void drawMask(BufferBuilder b, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        b.func_225582_a_(minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(maxX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, maxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, maxY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        b.func_225582_a_(minX, minY, minZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void renderAABB(MatrixStack matrixStack, IVertexBuilder builder, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        float boxMinX = (float)box.field_72340_a;
        float boxMinY = (float)box.field_72338_b;
        float boxMinZ = (float)box.field_72339_c;
        float boxMaxX = (float)box.field_72336_d;
        float boxMaxY = (float)box.field_72337_e;
        float boxMaxZ = (float)box.field_72334_f;
        builder.func_227888_a_(matrix4f, boxMinX, boxMinY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMinY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMaxY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMaxY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMinY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMaxY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMaxY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMinY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMinY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMinY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMaxY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMaxY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMinY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMaxY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMaxY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMinY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMinY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMinY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMinY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMinY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMaxY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMinX, boxMaxY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMaxY, boxMaxZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix4f, boxMaxX, boxMaxY, boxMinZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void renderSineWave(int x, int y, int width, int height, double amp) {
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        double t = (double)System.currentTimeMillis() * 0.02;
        for (int point = 0; point < width; ++point) {
            builder.func_225582_a_((double)x + (double)point * 0.75, (double)y + Math.sin(((double)point + t) * amp) * (double)height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            builder.func_225582_a_((double)x + (double)(point + 1) * 0.75, (double)y + Math.sin(((double)point + t + 1.0) * amp) * (double)height, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    public static double calculateColorBrightness(Vector3d c) {
        float r = (float)c.field_72450_a;
        float g = (float)c.field_72448_b;
        float b = (float)c.field_72449_c;
        r = (double)r <= 0.03928 ? r / 12.92f : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.03928 ? g / 12.92f : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.03928 ? b / 12.92f : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        return 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
    }

    public static void drawModelToGui(MatrixStack stack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, EntityModel<ClientPlayerEntity> model, int xPos, int yPos, float scale, float rotation) {
        RenderSystem.pushMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        GL11.glBlendFunc((int)770, (int)771);
        RenderSystem.translatef((float)xPos, (float)yPos, (float)100.0f);
        RenderSystem.rotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_227784_d_();
        GlStateManager.func_227656_a_((int)2899, (FloatBuffer)TRenderHelper.getBuffer(0.75f, 0.75f, 0.75f, 1.0f));
        RenderSystem.scalef((float)(38.0f * scale), (float)(34.0f * scale), (float)(38.0f * scale));
        RenderSystem.scalef((float)-1.0f, (float)1.0f, (float)1.0f);
        model.func_225598_a_(stack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        RenderHelper.func_74518_a();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
    }

    public static void copyModelAngles(ModelRenderer src, ModelRenderer dest) {
        dest.field_78795_f = src.field_78795_f;
        dest.field_78796_g = src.field_78796_g;
        dest.field_78808_h = src.field_78808_h;
        dest.field_78800_c = src.field_78800_c;
        dest.field_78797_d = src.field_78797_d;
        dest.field_78798_e = src.field_78798_e;
    }

    public static void blit(int left, int top, int right, int bottom, float red, float green, float blue, float alpha) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_225582_a_((double)left, (double)bottom, 0.0).func_181675_d();
        bufferBuilder.func_225582_a_((double)right, (double)bottom, 0.0).func_181675_d();
        bufferBuilder.func_225582_a_((double)right, (double)top, 0.0).func_181675_d();
        bufferBuilder.func_225582_a_((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    private static FloatBuffer getBuffer(float float1, float float2, float float3, float float4) {
        FLOAT_4_BUFFER.clear();
        FLOAT_4_BUFFER.put(float1).put(float2).put(float3).put(float4);
        FLOAT_4_BUFFER.flip();
        return FLOAT_4_BUFFER;
    }

    public static void renderFilledBox(Matrix4f matrix, IVertexBuilder builder, AxisAlignedBB boundingBox, double red, double green, double blue, float alpha, int combinedLightIn) {
        TRenderHelper.renderFilledBox(matrix, builder, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f, (float)red, (float)green, (float)blue, alpha, combinedLightIn);
    }

    public static void renderFilledBox(Matrix4f matrix, IVertexBuilder builder, float startX, float startY, float startZ, float endX, float endY, float endZ, double red, double green, double blue, float alpha, int combinedLightIn) {
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_((float)red, (float)green, (float)blue, alpha).func_227886_a_(combinedLightIn).func_181675_d();
    }

    public static void drawGlowingLine(Matrix4f matrix, IVertexBuilder builder, float length, float width, double red, double green, double blue, float alpha, int combinedLightIn) {
        AxisAlignedBB box = new AxisAlignedBB((double)(-width / 2.0f), 0.0, (double)(-width / 2.0f), (double)(width / 2.0f), (double)length, (double)(width / 2.0f));
        TRenderHelper.renderFilledBox(matrix, builder, box, 1.0f, 1.0f, 1.0f, alpha, combinedLightIn);
        for (int i = 0; i < 3; ++i) {
            TRenderHelper.renderFilledBox(matrix, builder, box.func_186662_g((double)((float)i * 0.5f * 0.0625f)), (float)red, (float)green, (float)blue, 1.0f / (float)i / 2.0f * alpha, combinedLightIn);
        }
    }

    public static void renderItem(MatrixStack matrix, ItemRenderer renderer, @Nonnull ItemStack stack, int xAxis, int yAxis, float scale, FontRenderer font, String text, boolean overlay) {
        if (!stack.func_190926_b()) {
            try {
                matrix.func_227860_a_();
                RenderSystem.enableDepthTest();
                RenderHelper.func_227780_a_();
                if (scale != 1.0f) {
                    RenderSystem.enableRescaleNormal();
                    matrix.func_227862_a_(scale, scale, scale);
                    RenderSystem.disableRescaleNormal();
                }
                RenderSystem.pushMatrix();
                RenderSystem.multMatrix((Matrix4f)matrix.func_227866_c_().func_227870_a_());
                renderer.func_180450_b(stack, xAxis, yAxis);
                if (overlay) {
                    renderer.func_180453_a(font, stack, xAxis, yAxis, text);
                }
                RenderSystem.popMatrix();
                RenderHelper.func_74518_a();
                RenderSystem.disableDepthTest();
                matrix.func_227865_b_();
            }
            catch (Exception e) {
                Tardis.LOGGER.error("Failed to render stack into gui: {}", (Object)stack, (Object)e);
            }
        }
    }

    public static void renderItemOnScreenBackground(MatrixStack matrixStack, ItemRenderer itemRenderer, @Nonnull ItemStack stack, float translateX, float translateY, float translateZ) {
        IRenderTypeBuffer.Impl iRenderBufferImpl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        int combinedLight = 0xF000F0;
        int combinedOverlay = OverlayTexture.field_229196_a_;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)translateX, (double)translateY, (double)translateZ);
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        itemRenderer.func_229110_a_(stack, ItemCameraTransforms.TransformType.GUI, combinedLight, combinedOverlay, matrixStack, (IRenderTypeBuffer)iRenderBufferImpl);
        RenderSystem.popMatrix();
        matrixStack.func_227865_b_();
    }

    public static void drawPlayerCapabilityText(PlayerEntity player, MatrixStack matrixStack, FontRenderer fr, int scaledWidth, int scaledHeight) {
        if (player != null) {
            if (PlayerHelper.isInEitherHand((LivingEntity)player, (Item)TItems.SONIC.get())) {
                ItemStack stack = PlayerHelper.getHeldStack((LivingEntity)player, Hand.MAIN_HAND);
                stack.getCapability(Capabilities.SONIC_CAPABILITY).ifPresent(sonic -> {
                    BlockRayTraceResult btr;
                    TileEntity te;
                    RayTraceResult result;
                    if (sonic.getMode() == SonicModeRegistry.BLOCK_INTERACT.get() && (result = PlayerHelper.getPosLookingAt((Entity)player, 4.0)) instanceof BlockRayTraceResult && (te = player.field_70170_p.func_175625_s((btr = (BlockRayTraceResult)result).func_216350_a())) != null) {
                        te.getCapability(CapabilityEnergy.ENERGY).ifPresent(cap -> {
                            int oldFE = sonic.getForgeEnergy();
                            int maxStorage = cap.getMaxEnergyStored();
                            int storage = cap.getEnergyStored();
                            TranslationTextComponent energy = new TranslationTextComponent("message.tardis.energy_buffer", new Object[]{oldFE, maxStorage});
                            if (oldFE != storage) {
                                sonic.setForgeEnergy(storage);
                            } else {
                                matrixStack.func_227860_a_();
                                fr.func_238405_a_(matrixStack, energy.getString(), (float)(scaledWidth / 2 - 60), (float)(scaledHeight / 2 - 45), 0xFFFFFF);
                                matrixStack.func_227865_b_();
                            }
                        });
                        if (te instanceof TransductionBarrierTile) {
                            TransductionBarrierTile barrier = (TransductionBarrierTile)te;
                            String code = barrier.getCode();
                            TranslationTextComponent codeText = new TranslationTextComponent("message.tardis.transduction_barrier.code", new Object[]{code.isEmpty() ? "null" : code});
                            matrixStack.func_227860_a_();
                            fr.func_238405_a_(matrixStack, codeText.getString(), (float)(scaledWidth / 2 - 60), (float)(scaledHeight / 2 - 55), 0xFFFFFF);
                            matrixStack.func_227865_b_();
                        }
                    }
                });
            }
            player.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> {
                if (cap.getCountdown() > 0) {
                    String countDown = "" + cap.getCountdown() / 20;
                    int countWidth = fr.func_78256_a(countDown);
                    TranslationTextComponent roomDeletionMessage = new TranslationTextComponent("message.tardis.ars.room.delete_countdown", new Object[]{countDown});
                    fr.func_238405_a_(matrixStack, roomDeletionMessage.getString(), (float)(scaledWidth / 2 - countWidth / 2 - 100), (float)(scaledHeight / 2 - 30), 0xFFFFFF);
                }
            });
        }
    }

    public static void drawTextAtLookVec(PlayerEntity player, MatrixStack matrixStack, FontRenderer fr, int scaledWidth, int scaledHeight) {
        RayTraceResult result;
        if (player != null && (result = PlayerHelper.getPosLookingAt((Entity)player, 4.0)) instanceof BlockRayTraceResult) {
            BlockRayTraceResult btr = (BlockRayTraceResult)result;
            BlockState state = player.field_70170_p.func_180495_p(btr.func_216350_a());
            TileEntity te = player.field_70170_p.func_175625_s(btr.func_216350_a());
            if (te != null) {
                // empty if block
            }
        }
    }

    public static void drawDebugBoundingBoxes(PlayerEntity player, MatrixStack matrixStack, IVertexBuilder builder, double correctedRenderPosX, double correctedRenderPosY, double correctedRenderPosZ) {
        if (player != null) {
            ItemStack main = player.func_184614_ca();
            if (main.func_77973_b() == TItems.PLASMIC_SHELL_GENERATOR.get()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(-correctedRenderPosX, -correctedRenderPosY, -correctedRenderPosZ);
                if (player.func_184614_ca().func_196082_o().func_74764_b("pos1")) {
                    BlockPos pos = BlockPos.func_218283_e((long)main.func_196082_o().func_74763_f("pos1"));
                    BlockPos pos1 = main.func_196082_o().func_74764_b("pos2") ? BlockPos.func_218283_e((long)main.func_196082_o().func_74763_f("pos2")) : player.func_233580_cy_();
                    boolean green = main.func_196082_o().func_74764_b("complete") && main.func_196082_o().func_74767_n("complete");
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)builder, (AxisAlignedBB)PlasmicShellItem.getBox(pos, pos1).func_186662_g(0.1), (float)(!green ? 1.0f : 0.0f), (float)(green ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
                }
                matrixStack.func_227865_b_();
            }
            if (main.func_77973_b() == TItems.DEBUG.get()) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(-correctedRenderPosX, -correctedRenderPosY, -correctedRenderPosZ);
                WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)builder, (AxisAlignedBB)((DebugItem)TItems.DEBUG.get()).box, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                matrixStack.func_227865_b_();
            }
        }
    }

    public static void drawSquarenessGunOutline(PlayerEntity player, MatrixStack matrixStack, ActiveRenderInfo information, DrawHighlightEvent event) {
        if (player != null && PlayerHelper.isInEitherHand((LivingEntity)player, (Item)TItems.SQUARENESS_GUN.get())) {
            event.setCanceled(true);
            RayTraceResult result = PlayerHelper.getPosLookingAt((Entity)player, 5.0);
            if (result != null && result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
                BlockPos pos = blockRayTraceResult.func_216350_a();
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                Vector3d projectedView = information.func_216785_c();
                double correctedRenderPosX = projectedView.func_82615_a();
                double correctedRenderPosY = projectedView.func_82617_b();
                double correctedRenderPosZ = projectedView.func_82616_c();
                AxisAlignedBB box = SquarenessGunItem.getSelection(pos, player.func_174811_aO());
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(correctedRenderPosX, correctedRenderPosY, correctedRenderPosZ);
                for (int iteratedX = (int)box.field_72340_a; iteratedX < (int)box.field_72336_d; ++iteratedX) {
                    for (int iteratedY = (int)box.field_72338_b; iteratedY < (int)box.field_72337_e; ++iteratedY) {
                        for (int iteratedZ = (int)box.field_72339_c; iteratedZ < (int)box.field_72334_f; ++iteratedZ) {
                            if (world.func_175623_d(pos.func_177982_a(iteratedX, iteratedY, iteratedZ))) continue;
                            matrixStack.func_227860_a_();
                            matrixStack.func_227861_a_((double)iteratedX, (double)iteratedY, (double)iteratedZ);
                            BlockState blockState = world.func_180495_p(pos.func_177982_a(iteratedX, iteratedY, iteratedZ));
                            VoxelShape collisionShape = blockState.func_196951_e((IBlockReader)world, pos);
                            if (!collisionShape.func_197766_b()) {
                                TRenderHelper.drawSelectionBoxMask(collisionShape.func_197752_a(), 0.2f, 0.6f, 0.8f, 0.9f);
                            }
                            matrixStack.func_227865_b_();
                        }
                    }
                }
                matrixStack.func_227865_b_();
                double projectedX = information.func_216785_c().field_72450_a;
                double projectedY = information.func_216785_c().field_72448_b;
                double projectedZ = information.func_216785_c().field_72449_c;
                Iterator iterator = BlockPos.func_218281_b((BlockPos)new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f), (BlockPos)new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c)).iterator();
                while (iterator.hasNext()) {
                    BlockPos blockPos = (BlockPos)iterator.next();
                    BlockState shape = player.field_70170_p.func_180495_p(blockPos);
                    IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
                    WorldRenderer.func_228431_a_((MatrixStack)matrixStack, (IVertexBuilder)ivertexbuilder, (VoxelShape)shape.func_215700_a((IBlockReader)((ClientWorld)player.field_70170_p), blockPos, ISelectionContext.func_216374_a((Entity)information.func_216773_g())), (double)((double)blockPos.func_177958_n() - projectedX), (double)((double)blockPos.func_177956_o() - projectedY), (double)((double)blockPos.func_177952_p() - projectedZ), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                }
            }
        }
    }

    public static void handleTooltipRendering(ItemStack stack, List<ITextComponent> tooltips, ITooltipFlag flag, PlayerEntity player) {
        String tardisName;
        if (stack != null && player != null && !(stack.func_77973_b() instanceof IAttunable) && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("attuned_console") && stack.func_77978_p().func_74764_b("tardis_name") && (tardisName = stack.func_77978_p().func_74779_i("tardis_name")) != null) {
            tooltips.add(1, (ITextComponent)new TranslationTextComponent("tooltip.item.attuned.owner").func_230529_a_((ITextComponent)new StringTextComponent(tardisName).func_240699_a_(TextFormatting.LIGHT_PURPLE)));
        }
    }
}

