/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.tardis.mod.containers.BaseContainer;

public class TInventoryHelper {
    public static void giveStackTo(Entity ent, ItemStack stack) {
        InventoryHelper.func_180173_a((World)ent.field_70170_p, (double)ent.func_226277_ct_(), (double)ent.func_226278_cu_(), (double)ent.func_226281_cx_(), (ItemStack)stack);
    }

    public static void dropEntityLoot(Entity target, PlayerEntity attacker) {
        LivingEntity targeted = (LivingEntity)target;
        ResourceLocation resourcelocation = targeted.func_213346_cF();
        LootTable loot_table = target.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        LootContext.Builder lootcontext$builder = TInventoryHelper.getLootContextBuilder(true, DamageSource.field_76377_j, targeted, attacker);
        LootContext ctx = lootcontext$builder.func_216022_a(LootParameterSets.field_216263_d);
        loot_table.func_216113_a(ctx).forEach(arg_0 -> ((Entity)target).func_199701_a_(arg_0));
    }

    public static LootContext.Builder getLootContextBuilder(boolean p_213363_1_, DamageSource damageSourceIn, LivingEntity entity, PlayerEntity attacker) {
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)entity.field_70170_p).func_216023_a(entity.field_70170_p.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)damageSourceIn).func_216021_b(LootParameters.field_216284_d, (Object)damageSourceIn.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)damageSourceIn.func_76364_f());
        if (p_213363_1_ && entity.func_94060_bK() != null) {
            attacker = (PlayerEntity)entity.func_94060_bK();
            builder = builder.func_216015_a(LootParameters.field_216282_b, (Object)attacker).func_186469_a(attacker.func_184817_da());
        }
        return builder;
    }

    public static void addPlayerInvContainer(BaseContainer container, PlayerInventory player, int x, int y) {
        int i;
        for (i = 0; i < player.field_70462_a.size() - 9; ++i) {
            container.func_75146_a(new Slot((IInventory)player, i + 9, x + 8 + i % 9 * 18, 86 + y + i / 9 * 18));
        }
        for (i = 0; i < 9; ++i) {
            container.func_75146_a(new Slot((IInventory)player, i, 8 + x + i * 18, y + 144));
        }
    }

    public static List<Slot> createPlayerInv(PlayerInventory player, int x, int y) {
        int i;
        ArrayList slots = Lists.newArrayList();
        for (i = 0; i < player.field_70462_a.size() - 9; ++i) {
            slots.add(new Slot((IInventory)player, i + 9, x + 8 + i % 9 * 18, 86 + y + i / 9 * 18));
        }
        for (i = 0; i < 9; ++i) {
            slots.add(new Slot((IInventory)player, i, 8 + x + i * 18, y + 144));
        }
        return slots;
    }

    public static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }
}

