/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;

public class TFrustrum {
    private final Vector4f[] frustum = new Vector4f[6];
    private double cameraX;
    private double cameraY;
    private double cameraZ;

    public TFrustrum(Matrix4f matrix4f, Matrix4f projection) {
        this.calculateFrustum(matrix4f, projection);
    }

    public void setCameraPosition(double camX, double camY, double camZ) {
        this.cameraX = camX;
        this.cameraY = camY;
        this.cameraZ = camZ;
    }

    public void calculateFrustum(Matrix4f projection, Matrix4f frustrumMatrix) {
        Matrix4f matrix4f = frustrumMatrix.func_226601_d_();
        matrix4f.func_226595_a_(projection);
        matrix4f.func_226602_e_();
        this.setFrustumPlane(matrix4f, -1, 0, 0, 0);
        this.setFrustumPlane(matrix4f, 1, 0, 0, 1);
        this.setFrustumPlane(matrix4f, 0, -1, 0, 2);
        this.setFrustumPlane(matrix4f, 0, 1, 0, 3);
        this.setFrustumPlane(matrix4f, 0, 0, -1, 4);
        this.setFrustumPlane(matrix4f, 0, 0, 1, 5);
    }

    public void setFrustumPlane(Matrix4f frustrumMatrix, int x, int y, int z, int id) {
        Vector4f vector4f = new Vector4f((float)x, (float)y, (float)z, 1.0f);
        vector4f.func_229372_a_(frustrumMatrix);
        vector4f.func_229374_e_();
        this.frustum[id] = vector4f;
    }

    public void setFrustumPlane(Matrix4f frustrumMatrix, float x, float y, float z, int id) {
        Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
        vector4f.func_229372_a_(frustrumMatrix);
        vector4f.func_229374_e_();
        this.frustum[id] = vector4f;
    }

    public boolean isBoundingBoxInFrustum(AxisAlignedBB aabbIn) {
        return this.isBoxInFrustum(aabbIn.field_72340_a, aabbIn.field_72338_b, aabbIn.field_72339_c, aabbIn.field_72336_d, aabbIn.field_72337_e, aabbIn.field_72334_f);
    }

    public boolean isBoxInFrustum(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        float f = (float)(minX - this.cameraX);
        float f1 = (float)(minY - this.cameraY);
        float f2 = (float)(minZ - this.cameraZ);
        float f3 = (float)(maxX - this.cameraX);
        float f4 = (float)(maxY - this.cameraY);
        float f5 = (float)(maxZ - this.cameraZ);
        return this.isBoxInFrustumRaw(f, f1, f2, f3, f4, f5);
    }

    private boolean isBoxInFrustumRaw(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        for (int i = 0; i < 6; ++i) {
            Vector4f vector4f = this.frustum[i];
            if (vector4f.func_229373_a_(new Vector4f(minX, minY, minZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(maxX, minY, minZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(minX, maxY, minZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(maxX, maxY, minZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(minX, minY, maxZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(maxX, minY, maxZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(minX, maxY, maxZ, 1.0f)) > 0.0f || vector4f.func_229373_a_(new Vector4f(maxX, maxY, maxZ, 1.0f)) > 0.0f) continue;
            return false;
        }
        return true;
    }
}

