/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.exceptions.NoPlayerFoundException;
import net.tardis.mod.items.TItems;

public class PlayerHelper {
    public static UUID getOnlinePlayerUUID(String username) throws NoPlayerFoundException {
        Optional<ServerPlayerEntity> player = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v().stream().filter(p -> p.func_200200_C_().getString().equals(username)).findFirst();
        if (player.isPresent()) {
            return player.get().func_110124_au();
        }
        throw new NoPlayerFoundException(username);
    }

    public static String getPlayerUsername(UUID uuid) {
        if (ServerLifecycleHooks.getCurrentServer() == null || uuid == null) {
            return "Unknown Timelord";
        }
        PlayerProfileCache cache = ServerLifecycleHooks.getCurrentServer().func_152358_ax();
        GameProfile profile = cache.func_152652_a(uuid);
        if (profile != null) {
            return profile.getName();
        }
        return "Undefined";
    }

    public static String getClientPlayerUsername(String input) {
        NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175104_a(input);
        if (info != null && info.func_178845_a() != null) {
            return info.func_178845_a().getName();
        }
        if (info == null) {
            NetworkPlayerInfo infoTwo = Minecraft.func_71410_x().func_147114_u().func_175102_a(UUID.fromString(input));
            if (PlayerHelper.doesPlayerInfoExist(infoTwo)) {
                return infoTwo.func_178845_a().getName();
            }
            return "Undefined";
        }
        return "Undefined";
    }

    public static String getClientPlayerUsername(UUID id) {
        NetworkPlayerInfo player = Minecraft.func_71410_x().func_147114_u().func_175102_a(id);
        if (player != null && player.func_178845_a() != null) {
            return player.func_178845_a().getName();
        }
        return "Undefined";
    }

    public static boolean doesPlayerInfoExist(NetworkPlayerInfo info) {
        return info != null;
    }

    public static boolean doesPlayerInfoExist(UUID id) {
        NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175102_a(id);
        return info != null;
    }

    public static NetworkPlayerInfo getClientPlayerFromUsername(String username) {
        NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175104_a(username);
        if (PlayerHelper.doesPlayerInfoExist(info)) {
            return info;
        }
        return null;
    }

    public static NetworkPlayerInfo getClientPlayerFromUUID(UUID id) {
        NetworkPlayerInfo info = Minecraft.func_71410_x().func_147114_u().func_175102_a(id);
        if (PlayerHelper.doesPlayerInfoExist(info)) {
            return info;
        }
        return null;
    }

    public static ItemStack getHeldStack(LivingEntity holder, Hand hand) {
        return holder.func_184586_b(hand);
    }

    public static boolean isInHand(Hand hand, LivingEntity holder, Item item) {
        ItemStack heldItem = holder.func_184586_b(hand);
        return heldItem.func_77973_b() == item;
    }

    public static boolean isInMainHand(LivingEntity holder, Item item) {
        return PlayerHelper.isInHand(Hand.MAIN_HAND, holder, item);
    }

    public static boolean isInOffHand(LivingEntity holder, Item item) {
        return PlayerHelper.isInHand(Hand.OFF_HAND, holder, item);
    }

    public static boolean isInEitherHand(LivingEntity holder, Item item) {
        return PlayerHelper.isInMainHand(holder, item) || PlayerHelper.isInOffHand(holder, item);
    }

    public static boolean InEitherHand(LivingEntity entity, Predicate<ItemStack> stack) {
        return stack.test(entity.func_184614_ca()) || stack.test(entity.func_184592_cb());
    }

    public static boolean isInOneHand(LivingEntity holder, Item item) {
        boolean mainHand = PlayerHelper.isInMainHand(holder, item) && !PlayerHelper.isInOffHand(holder, item);
        boolean offHand = PlayerHelper.isInOffHand(holder, item) && !PlayerHelper.isInMainHand(holder, item);
        return mainHand || offHand;
    }

    public static void sendMessageToPlayer(PlayerEntity player, TranslationTextComponent textComponent, boolean isHotBar) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.func_146105_b((ITextComponent)textComponent, isHotBar);
    }

    public static void sendMessageToPlayer(PlayerEntity player, IFormattableTextComponent textComponent, boolean isHotBar) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.func_146105_b((ITextComponent)textComponent, isHotBar);
    }

    public static void closeVMModel(PlayerEntity player) {
        if (player != null) {
            NonNullConsumer cons = cap -> cap.setOpen(false);
            ItemStack vm = new ItemStack((IItemProvider)TItems.VORTEX_MANIP.get());
            ItemStack stack = PlayerHelper.getHeldOrNearestStack(player, vm);
            stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cons);
        }
    }

    public static int getSlotIndexOfStackInInventory(PlayerEntity player, ItemStack stack) {
        PlayerInventory inv = player.field_71071_by;
        ImmutableList allInventories = ImmutableList.of((Object)inv.field_70462_a, (Object)inv.field_184439_c);
        Iterator iterator = allInventories.iterator();
        if (iterator.hasNext()) {
            ItemStack itemstack;
            NonNullList nonnulllist = (NonNullList)iterator.next();
            Iterator iterator2 = nonnulllist.iterator();
            while (true) {
                if (!iterator2.hasNext() || (itemstack = (ItemStack)iterator2.next()).func_190926_b()) {
                    continue;
                }
                if (itemstack == player.func_184614_ca()) {
                    return EquipmentSlotType.MAINHAND.func_188452_c();
                }
                if (itemstack == player.func_184592_cb()) {
                    return EquipmentSlotType.OFFHAND.func_188452_c();
                }
                if (itemstack.func_77969_a(stack)) break;
            }
            return nonnulllist.indexOf((Object)itemstack);
        }
        return 0;
    }

    public static OptionalInt findItem(PlayerEntity player, ItemStack stack) {
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i <= inv.func_70302_i_(); ++i) {
            if (!inv.func_70301_a(i).func_77969_a(stack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public static ItemStack getHeldOrNearestStack(PlayerEntity player, ItemStack stack) {
        if (player.field_71071_by.func_70431_c(stack)) {
            int index = PlayerHelper.findItem(player, stack).getAsInt();
            return PlayerHelper.isInMainHand((LivingEntity)player, stack.func_77973_b()) ? player.func_184614_ca() : (PlayerHelper.isInOffHand((LivingEntity)player, stack.func_77973_b()) ? player.func_184592_cb() : player.field_71071_by.func_70301_a(index));
        }
        return PlayerHelper.isInMainHand((LivingEntity)player, stack.func_77973_b()) ? player.func_184614_ca() : player.func_184592_cb();
    }

    public static RayTraceResult getPosLookingAt(Entity entity, double distance) {
        Vector3d lookVec = entity.func_70040_Z();
        int i = 0;
        while ((double)i < distance * 2.0) {
            float scale = (float)i / 2.0f;
            Vector3d pos = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0).func_178787_e(lookVec.func_186678_a((double)scale));
            if (entity.field_70170_p.func_180495_p(new BlockPos(pos)).func_196951_e((IBlockReader)entity.field_70170_p, new BlockPos(pos)) != VoxelShapes.func_197880_a() && !entity.field_70170_p.func_175623_d(new BlockPos(pos))) {
                return new BlockRayTraceResult(pos, Direction.func_210769_a((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c), new BlockPos(pos), false);
            }
            Vector3d min = pos.func_72441_c(0.25, 0.25, 0.25);
            Vector3d max = pos.func_72441_c(-0.25, -0.25, -0.25);
            Iterator iterator = entity.field_70170_p.func_72839_b(entity, new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c)).iterator();
            if (iterator.hasNext()) {
                Entity e = (Entity)iterator.next();
                return new EntityRayTraceResult(e);
            }
            ++i;
        }
        return null;
    }

    public static void sendMessageToPlayer(ClientPlayerEntity player, StringTextComponent stringTextComponent, boolean isHotBar) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.func_146105_b((ITextComponent)stringTextComponent, isHotBar);
    }
}

