/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.controls.LandingTypeControl;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.misc.SpaceTimeCoord;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.ShieldGeneratorSubsystem;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.IAffectTARDISLanding;
import net.tardis.mod.tileentities.console.misc.AlarmType;
import net.tardis.mod.tileentities.console.misc.MonitorOverride;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.tileentities.machines.TransductionBarrierTile;

public class LandingSystem {
    public static boolean isSafe(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76222_j();
    }

    public static boolean canLand(World world, BlockPos pos, AbstractExterior exterior, ConsoleTile console) {
        BlockPos up = new BlockPos(exterior.getWidth(console), exterior.getHeight(console), exterior.getWidth(console));
        BlockPos down = new BlockPos(exterior.getWidth(console), 0, exterior.getWidth(console));
        for (BlockPos check : BlockPos.func_218278_a((BlockPos)pos.func_177973_b((Vector3i)down), (BlockPos)pos.func_177971_a((Vector3i)up))) {
            if (LandingSystem.isSafe(world, check)) continue;
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public static BlockPos findValidLandSpot(World world, BlockPos dest, LandingTypeControl.EnumLandType type, AbstractExterior ext, ConsoleTile console) {
        if (LandingSystem.canLand(world, dest, ext, console)) {
            return dest;
        }
        if (type == LandingTypeControl.EnumLandType.UP) {
            return LandingSystem.getLandSpotUp(world, dest, ext, console);
        }
        if (type == LandingTypeControl.EnumLandType.DOWN) {
            return LandingSystem.getLandSpotDown(world, dest, ext, console);
        }
        return BlockPos.field_177992_a;
    }

    public static BlockPos getLandSpotUp(World world, BlockPos dest, AbstractExterior ext, ConsoleTile console) {
        for (int y = dest.func_177956_o(); y < LandingSystem.calculateHeight(world, console, ext); ++y) {
            BlockPos test = new BlockPos(dest.func_177958_n(), y, dest.func_177952_p());
            if (!LandingSystem.canLand(world, test, ext, console)) continue;
            return test;
        }
        return BlockPos.field_177992_a;
    }

    public static BlockPos getLandSpotDown(World world, BlockPos dest, AbstractExterior ext, ConsoleTile console) {
        for (int y = dest.func_177956_o(); y > 0; --y) {
            BlockPos test = new BlockPos(dest.func_177958_n(), y, dest.func_177952_p());
            if (!LandingSystem.canLand(world, test, ext, console)) continue;
            return test;
        }
        return BlockPos.field_177992_a;
    }

    public static BlockPos getTopBlock(World world, BlockPos pos) {
        for (int y = world.func_217301_I(); y > 0; --y) {
            BlockPos newPos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            BlockState underState = world.func_180495_p(newPos.func_177977_b());
            if (LandingSystem.willBlockStateCauseSuffocation(world, newPos) || !underState.func_200132_m() || LandingSystem.isPosBelowOrAboveWorld(world, newPos.func_177956_o())) continue;
            return newPos;
        }
        return pos;
    }

    public static boolean isBlockWithinWorldBorder(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos);
    }

    public static boolean isBlockWithinWorldBorder(World world, int x, int y, int z) {
        return world.func_175723_af().func_177746_a(new BlockPos(x, y, z));
    }

    public static BlockPos getLand(World world, BlockPos dest, LandingTypeControl.EnumLandType type, ConsoleTile console) {
        BlockPos pos = LandingSystem.findValidLandSpot(world, dest, type, console.getExteriorType(), console);
        if (pos.equals((Object)BlockPos.field_177992_a)) {
            pos = LandingSystem.findValidLandSpot(world, dest, type == LandingTypeControl.EnumLandType.DOWN ? LandingTypeControl.EnumLandType.UP : LandingTypeControl.EnumLandType.DOWN, console.getExteriorType(), console);
        }
        return pos;
    }

    public static boolean isPosBelowOrAboveWorld(World dim, int y) {
        if (dim.func_234923_W_() == World.field_234919_h_) {
            return y <= 0 || y >= 126;
        }
        return y <= 0 || y >= dim.func_217301_I();
    }

    public static boolean willBlockStateCauseSuffocation(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_185904_a().func_76230_c() && state.func_235785_r_((IBlockReader)world, pos);
    }

    public static BlockPos validateBlockPos(BlockPos pos, World world, ConsoleTile tile, AbstractExterior exterior) {
        int maxHeight = LandingSystem.calculateHeight(world, tile, exterior);
        if (pos.func_177956_o() < 0) {
            return new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (pos.func_177956_o() >= maxHeight) {
            if (pos.func_177956_o() >= world.func_217301_I()) {
                return new BlockPos(pos.func_177958_n(), world.func_217301_I() - 1, pos.func_177952_p());
            }
            return new BlockPos(pos.func_177958_n(), maxHeight - 1, pos.func_177952_p());
        }
        return pos;
    }

    public static boolean shouldTARDISFall(World world, BlockPos pos) {
        ObjectWrapper<Boolean> hasGrav = new ObjectWrapper<Boolean>(true);
        world.getCapability(Capabilities.SPACE_DIM_PROPERTIES).ifPresent(cap -> {
            if (cap.isZeroG()) {
                hasGrav.setValue(false);
            }
        });
        if (!hasGrav.getValue().booleanValue()) {
            return false;
        }
        return (world.func_180495_p(pos).func_196951_e((IBlockReader)world, pos).func_197766_b() || !world.func_180495_p(pos).func_200132_m()) && world.func_180495_p(pos).func_185904_a() == Material.field_151579_a;
    }

    public static BlockPos tryToKill(World world, BlockPos pos, Direction facing, int range) {
        Optional<BlockPos> landPos = BlockPos.func_239581_a_((AxisAlignedBB)new AxisAlignedBB(pos).func_186662_g((double)range)).filter(p -> LandingSystem.isSafe(world, p)).filter(p -> LandingSystem.isDanger(world.func_180495_p(p.func_177972_a(facing))) || LandingSystem.isDanger(world.func_180495_p(p.func_177972_a(facing).func_177977_b()))).findAny();
        return landPos.orElse(pos);
    }

    public static boolean isDanger(BlockState state) {
        return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b);
    }

    public static BlockPos redirectBehindBorder(ServerWorld world, BlockPos destination, ConsoleTile console) {
        BlockPos finalDestination = destination;
        if (!world.func_175723_af().func_177746_a(destination)) {
            BlockPos pos = world.func_241135_u_();
            if (pos == null) {
                pos = BlockPos.field_177992_a;
            }
            finalDestination = console.randomizeCoords(world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos), 50);
            for (PlayerEntity ent : console.func_145831_w().func_217357_a(PlayerEntity.class, new AxisAlignedBB(console.func_174877_v()).func_186662_g(30.0))) {
                ent.func_146105_b((ITextComponent)TardisConstants.Translations.OUTSIDE_BORDER, true);
            }
            console.getInteriorManager().soundAlarm(AlarmType.LOW);
            console.getInteriorManager().setMonitorOverrides(new MonitorOverride(console, 100, TardisConstants.Translations.OUTSIDE_BORDER.getString()));
        }
        return finalDestination;
    }

    @Nullable
    public static SpaceTimeCoord handleTardisInTardis(ServerWorld serverWorld, BlockPos destination, ConsoleTile console) {
        ExteriorTile other;
        TileEntity te = serverWorld.func_175625_s(destination.func_177977_b());
        if (te instanceof ExteriorTile && (other = (ExteriorTile)te).getInteriorDimensionKey() != console.func_145831_w().func_234923_W_()) {
            RegistryKey<World> otherTardisWorldInteriorKey = other.getInteriorDimensionKey();
            ServerWorld otherTardisWorld = console.func_145831_w().func_73046_m().func_71218_a(otherTardisWorldInteriorKey);
            ConsoleTile otherConsole = TardisHelper.getConsoleInWorld((World)otherTardisWorld).orElse(null);
            if (otherConsole != null) {
                ShieldGeneratorSubsystem sys = (ShieldGeneratorSubsystem)otherConsole.getSubsystem(ShieldGeneratorSubsystem.class).orElse(null);
                if (sys == null || !sys.canBeUsed()) {
                    return new SpaceTimeCoord(otherTardisWorldInteriorKey, LandingSystem.getLand((World)serverWorld, console.randomizeCoords(new BlockPos(0, 128, 0), 10), LandingTypeControl.EnumLandType.DOWN, console));
                }
                if (sys != null) {
                    sys.damage(null, 1);
                }
            }
        }
        return null;
    }

    @Nullable
    public static SpaceTimeCoord affectFromWorldBlocks(ServerWorld serverWorld, BlockPos pos, LandingTypeControl.EnumLandType type, ConsoleTile console) {
        List<TileEntity> possibleHazards = WorldHelper.getTEsInChunks(serverWorld, new ChunkPos(pos), 3);
        possibleHazards.removeIf(te -> !(te instanceof IAffectTARDISLanding));
        for (TileEntity te2 : possibleHazards) {
            SpaceTimeCoord coord;
            IAffectTARDISLanding affect = (IAffectTARDISLanding)te2;
            if (!pos.func_218141_a((Vector3i)te2.func_174877_v(), (double)affect.getEffectiveRange()) || (coord = affect.affectTARDIS(serverWorld, new SpaceTimeCoord((RegistryKey<World>)serverWorld.func_234923_W_(), pos, console.getExteriorFacingDirection()), console)) == null) continue;
            if (te2 instanceof TransductionBarrierTile) {
                console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.CANT_START.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return coord;
        }
        return null;
    }

    public static int calculateHeight(World world, ConsoleTile tile, AbstractExterior exterior) {
        return world.func_217301_I() - exterior.getHeight(tile) + 1;
    }
}

