/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.ShipComputerTile;

public class Helper {
    public static Random rand = new Random();

    public static boolean isInBounds(int testX, int testY, int x, int y, int u, int v) {
        return testX > x && testX < u && testY > y && testY < v;
    }

    public static void doIfAdvancementPresent(String name, ServerPlayerEntity ent, Runnable run) {
        Advancement adv = ent.func_184102_h().func_191949_aK().func_192778_a(new ResourceLocation("tardis", name));
        if (adv != null && ent.func_192039_O().func_192747_a(adv).func_192105_a()) {
            run.run();
        }
    }

    public static void doIfAdvancementPresentOther(ResourceLocation loc, ServerPlayerEntity ent, Runnable run) {
        Advancement adv = ent.func_184102_h().func_191949_aK().func_192778_a(loc);
        if (adv != null && ent.func_192039_O().func_192747_a(adv).func_192105_a()) {
            run.run();
        }
    }

    public static ResourceLocation createRL(String string) {
        return new ResourceLocation("tardis", string);
    }

    public static String createRLString(String name) {
        return "tardis:" + name;
    }

    public static ResourceLocation createManualRL(String string) {
        return new ResourceLocation("tardis", "manual/" + string);
    }

    public static ResourceLocation createOldManualRL(String string) {
        return new ResourceLocation("tardis", "manual/chapters/" + string + ".json");
    }

    public static String getSubSystemNotActivatedMessage(String name) {
        return "message.tardis.subsystem.not_activated." + name;
    }

    public static boolean canRenderInBOTI(BlockState state) {
        for (String blocked : (List)TConfig.CLIENT.botiBlacklistedBlocks.get()) {
            if (state.func_177230_c().getRegistryName().toString().equals(blocked)) {
                return false;
            }
            if (!blocked.endsWith("*")) continue;
            String modid = blocked.substring(0, blocked.indexOf(58));
            if (!state.func_177230_c().getRegistryName().func_110624_b().equals(modid)) continue;
            return false;
        }
        return true;
    }

    public static boolean canRenderInBOTI(Entity entity) {
        if (entity == null) {
            return false;
        }
        for (String blocked : (List)TConfig.CLIENT.botiBlacklistedEntities.get()) {
            if (entity.func_200600_R().getRegistryName().toString().equals(blocked)) {
                return false;
            }
            if (!blocked.endsWith("*")) continue;
            String modid = blocked.substring(0, blocked.indexOf(58));
            if (!entity.func_200600_R().getRegistryName().func_110624_b().equals(modid)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBeInBOTIPacket(BlockState state) {
        for (String blocked : (List)TConfig.SERVER.botiBlacklistedBlocks.get()) {
            if (!state.func_177230_c().getRegistryName().toString().equals(blocked)) continue;
            return false;
        }
        return true;
    }

    public static boolean canBeInBOTIPacket(Entity entity) {
        if (entity == null) {
            return false;
        }
        for (String blocked : (List)TConfig.SERVER.botiBlacklistedEntities.get()) {
            if (!entity.func_200600_R().getRegistryName().toString().equals(blocked)) continue;
            return false;
        }
        return true;
    }

    public static <T> void addAllToListNotDuplicate(ArrayList<T> list1, List<T> list2) {
        for (T obj : list2) {
            if (list1.contains(obj)) continue;
            list1.add(obj);
        }
    }

    public static <T extends INBT> List<T> getListFromNBT(ListNBT nbt, Class<T> nbtClass) {
        ArrayList list = Lists.newArrayList();
        for (INBT n : nbt) {
            list.add(nbtClass.cast(n));
        }
        return list;
    }

    public static String[] getConsoleText(ConsoleTile console) {
        if (console.getFlightEvent() != null) {
            return new String[]{"", console.getFlightEvent().getTranslation().getString()};
        }
        if (console.getInteriorManager().getMonitorOverrides() != null) {
            return console.getInteriorManager().getMonitorOverrides().getText();
        }
        boolean hasNav = console.hasNavCom();
        return new String[]{TardisConstants.Translations.LOCATION.getString() + (hasNav ? WorldHelper.formatBlockPos(console.getCurrentLocation()) : TardisConstants.Translations.UNKNOWN.getString()), TardisConstants.Translations.DIMENSION.getString() + (hasNav ? WorldHelper.formatDimName(console.getCurrentDimension()) : TardisConstants.Translations.UNKNOWN.getString()), TardisConstants.Translations.FACING.getString() + console.getExteriorFacingDirection().func_176742_j().toUpperCase(), TardisConstants.Translations.TARGET.getString() + (hasNav ? WorldHelper.formatBlockPos(console.getDestinationPosition()) : TardisConstants.Translations.UNKNOWN.getString()), TardisConstants.Translations.TARGET_DIM.getString() + (hasNav ? WorldHelper.formatDimName(console.getDestinationDimension()) : TardisConstants.Translations.UNKNOWN.getString()), TardisConstants.Translations.ARTRON.getString() + TardisConstants.TEXT_FORMAT_NO_DECIMALS.format(console.getArtron()) + "AU", TardisConstants.Translations.JOURNEY.getString() + TardisConstants.TEXT_FORMAT_NO_DECIMALS.format(console.getPercentageJourney() * 100.0) + "%"};
    }

    public static AxisAlignedBB createBBWithRaduis(int i) {
        return new AxisAlignedBB((double)(-i), (double)(-i), (double)(-i), (double)i, (double)i, (double)i);
    }

    static <FIELDHOLDER, FIELDTYPE> Function<FIELDHOLDER, FIELDTYPE> getInstanceField(Class<FIELDHOLDER> fieldHolderClass, String fieldName) {
        Field field = ObfuscationReflectionHelper.findField(fieldHolderClass, (String)fieldName);
        return instance -> {
            try {
                return field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static void addLootToComputerBelow(IServerWorld worldIn, BlockPos pos, ResourceLocation lootRL) {
        TileEntity te = worldIn.func_175625_s(pos.func_177977_b());
        if (te instanceof ShipComputerTile) {
            ShipComputerTile computer = (ShipComputerTile)te;
            computer.setLootTable(lootRL);
            worldIn.func_217377_a(pos, false);
        }
    }

    public static void addSchematicToComputerBelow(IServerWorld worldIn, BlockPos pos, ResourceLocation schematic) {
        TileEntity te = worldIn.func_175625_s(pos.func_177977_b());
        if (te instanceof ShipComputerTile) {
            ShipComputerTile computer = (ShipComputerTile)te;
            computer.setSchematic(schematic);
            worldIn.func_217377_a(pos, false);
        }
    }

    public static float getConfigPercent(int configInput) {
        float numerator = configInput;
        float denominator = 100.0f;
        float result = numerator / denominator;
        return result;
    }

    public static ResourceLocation getVariantTextureOr(@Nullable TexVariant variant, ResourceLocation defaultTex) {
        if (variant == null || variant.getTexture() == null) {
            return defaultTex;
        }
        return variant.getTexture();
    }

    public static int[] toIntArray(List<? extends Integer> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    public static float getChunkOffset(float val, float size) {
        return val >= 0.0f ? val / size : val / size - 1.0f;
    }

    public static void addTardisStatistic(ConsoleTile tile, ResourceLocation statLoc) {
        Helper.addTardisStatistic(tile.getPilot(), statLoc);
    }

    public static void addTardisStatistic(@Nullable PlayerEntity player, ResourceLocation statLoc) {
        if (player != null) {
            player.func_195066_a(statLoc);
        }
    }

    public static void addTardisDistanceTravelledStat(@Nullable PlayerEntity player, BlockPos start, BlockPos end) {
        BlockPos diff = start.func_177973_b((Vector3i)end);
        if (player != null) {
            Helper.addTardisDistanceTravelledStat(player, diff.func_177958_n(), diff.func_177956_o(), diff.func_177952_p());
        }
    }

    public static void addTardisDistanceTravelledStat(PlayerEntity player, double diffX, double diffY, double diffZ) {
        int dist = Math.round(MathHelper.func_76133_a((double)(diffX * diffX + diffZ * diffZ)) * 100.0f);
        player.func_195067_a(TardisStatistics.TARDIS_DISTANCE_TRAVELLED, dist);
    }
}

