/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.SyncDimensionListMessage;

public class DimensionHelper {
    public static ServerWorld getOrCreateWorld(MinecraftServer server, RegistryKey<World> worldKey, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        if (map.containsKey(worldKey)) {
            return (ServerWorld)map.get(worldKey);
        }
        ServerWorld newWorld = DimensionHelper.createAndRegisterDynamicWorldAndDimension(server, map, worldKey, dimensionFactory);
        return newWorld;
    }

    public static ServerWorld getOrCreateWorldStatic(MinecraftServer server, RegistryKey<World> worldKey, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        if (map.containsKey(worldKey)) {
            return (ServerWorld)map.get(worldKey);
        }
        ServerWorld newWorld = DimensionHelper.createAndRegisterWorldAndDimension(server, map, worldKey, dimensionFactory);
        return newWorld;
    }

    private static ServerWorld createAndRegisterDynamicWorldAndDimension(MinecraftServer server, Map<RegistryKey<World>, ServerWorld> map, RegistryKey<World> worldKey, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimensionFactory) {
        ServerWorld newWorld = DimensionHelper.createAndRegisterWorldAndDimension(server, map, worldKey, dimensionFactory);
        Network.sendPacketToAll(new SyncDimensionListMessage(worldKey, true));
        return newWorld;
    }

    private static ServerWorld createAndRegisterWorldAndDimension(MinecraftServer server, Map<RegistryKey<World>, ServerWorld> map, RegistryKey<World> worldKey, BiFunction<MinecraftServer, RegistryKey<Dimension>, Dimension> dimensionFactory) {
        ServerWorld overworld = server.func_71218_a(World.field_234918_g_);
        RegistryKey dimensionKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)worldKey.func_240901_a_());
        Dimension dimension = dimensionFactory.apply(server, (RegistryKey<Dimension>)dimensionKey);
        IChunkStatusListener chunkListener = server.field_213220_d.create(11);
        Executor executor = server.field_213217_au;
        SaveFormat.LevelSave levelSave = server.field_71310_m;
        IServerConfiguration serverConfig = server.func_240793_aU_();
        DimensionGeneratorSettings dimensionGeneratorSettings = serverConfig.func_230418_z_();
        dimensionGeneratorSettings.func_236224_e_().func_218381_a(dimensionKey, (Object)dimension, Lifecycle.stable());
        DerivedWorldInfo derivedWorldInfo = new DerivedWorldInfo(serverConfig, serverConfig.func_230407_G_());
        ServerWorld newWorld = new ServerWorld(server, executor, levelSave, (IServerWorldInfo)derivedWorldInfo, worldKey, dimension.func_236063_b_(), chunkListener, dimension.func_236064_c_(), dimensionGeneratorSettings.func_236227_h_(), BiomeManager.func_235200_a_((long)dimensionGeneratorSettings.func_236221_b_()), (List)ImmutableList.of(), false);
        overworld.func_175723_af().func_177737_a((IBorderListener)new IBorderListener.Impl(newWorld.func_175723_af()));
        map.put(worldKey, newWorld);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)newWorld));
        System.out.println("Registered new dimension of: " + dimensionKey.func_240901_a_().toString());
        return newWorld;
    }
}

