/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.helper;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.helper.TardisHelper;

public class CommandHelper {
    public static final SuggestionProvider<CommandSource> SUGGEST_TARDISES = (context, suggestionBuilder) -> {
        Set<RegistryKey<World>> collection = TardisHelper.getTardisWorldKeys(((CommandSource)context.getSource()).func_197028_i());
        return ISuggestionProvider.func_212476_a(collection.stream().map(RegistryKey::func_240901_a_), (SuggestionsBuilder)suggestionBuilder);
    };

    public static SuggestionsBuilder addTardisNamesAndKeySuggestions(SuggestionsBuilder builder, MinecraftServer server) {
        Map<RegistryKey<World>, String> map = TardisHelper.getTardisWorldKeyAndNames(server);
        map.entrySet().forEach(entry -> builder.suggest((String)entry.getValue(), (Message)new StringTextComponent(((RegistryKey)entry.getKey()).func_240901_a_().toString()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN))));
        builder.buildFuture();
        return builder;
    }

    public static SuggestionsBuilder addTardisNamesAndKeySuggestionsForPlayer(SuggestionsBuilder builder, MinecraftServer server, ServerPlayerEntity player) {
        Map<RegistryKey<World>, String> map = TardisHelper.getTardisNamesAndWorldsByPlayer(server, player);
        if (!map.isEmpty()) {
            map.entrySet().forEach(entry -> builder.suggest((String)entry.getValue(), (Message)new StringTextComponent(((RegistryKey)entry.getKey()).func_240901_a_().toString()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN))));
        } else {
            builder.suggest(new TranslationTextComponent("command.suggestion.tardis.no_connections").getString(), (Message)new TranslationTextComponent("command.suggestion.tardis.no_connections_tooltip"));
        }
        builder.buildFuture();
        return builder;
    }

    public static SuggestionsBuilder addTardisKeysWithNameTooltip(SuggestionsBuilder builder, MinecraftServer server) {
        Map<RegistryKey<World>, String> map = TardisHelper.getTardisWorldKeyAndNames(server);
        map.entrySet().forEach(entry -> builder.suggest(((RegistryKey)entry.getKey()).func_240901_a_().toString(), (Message)new StringTextComponent((String)entry.getValue()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN))));
        builder.buildFuture();
        return builder;
    }

    public static SuggestionsBuilder addTardisKeysWithNameTooltipForPlayer(SuggestionsBuilder builder, MinecraftServer server, ServerPlayerEntity player) {
        Map<RegistryKey<World>, String> map = TardisHelper.getTardisNamesAndWorldsByPlayer(server, player);
        if (!map.isEmpty()) {
            map.entrySet().forEach(entry -> builder.suggest(((RegistryKey)entry.getKey()).func_240901_a_().toString(), (Message)new StringTextComponent((String)entry.getValue()).func_240700_a_(style -> style.func_240712_a_(TextFormatting.GREEN))));
        } else {
            builder.suggest(new TranslationTextComponent("command.suggestion.tardis.no_connections").getString(), (Message)new TranslationTextComponent("command.suggestion.tardis.no_connections_tooltip"));
        }
        builder.buildFuture();
        return builder;
    }
}

