/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.flight;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.flight.FlightEvent;
import net.tardis.mod.tileentities.ConsoleTile;

public class FlightEventFactory
extends ForgeRegistryEntry<FlightEventFactory> {
    private IFlightEventFactory<FlightEvent> factory;
    private Supplier<ArrayList<ResourceLocation>> sequence;
    private boolean isNormal = true;

    public FlightEventFactory(IFlightEventFactory<FlightEvent> event, Supplier<ArrayList<ResourceLocation>> sequence) {
        this.factory = event;
        this.sequence = sequence;
    }

    public FlightEventFactory(IFlightEventFactory<FlightEvent> event, Supplier<ArrayList<ResourceLocation>> sequence, boolean normal) {
        this(event, sequence);
        this.isNormal = normal;
    }

    public FlightEvent create(ConsoleTile tile) {
        FlightEvent event = this.factory.create(this, this.sequence.get());
        event.calcTime(tile);
        return event;
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    public void setNormal(boolean normal) {
        this.isNormal = normal;
    }

    public static interface IFlightEventFactory<T extends FlightEvent> {
        public T create(FlightEventFactory var1, ArrayList<ResourceLocation> var2);
    }
}

