/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.flight;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.controls.AbstractControl;
import net.tardis.mod.controls.ThrottleControl;
import net.tardis.mod.flight.FlightEventFactory;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.MissControlMessage;
import net.tardis.mod.registries.TardisStatistics;
import net.tardis.mod.subsystem.Subsystem;
import net.tardis.mod.tileentities.ConsoleTile;

public abstract class FlightEvent {
    private FlightEventFactory entry;
    private List<ResourceLocation> controlsLeft;
    protected int timeUntilMiss = 0;
    private boolean isComplete = false;
    private String translationKey;

    public FlightEvent(FlightEventFactory entry, ResourceLocation ... controls) {
        this(entry, Lists.newArrayList((Object[])controls));
    }

    public FlightEvent(FlightEventFactory entry, List<ResourceLocation> controls) {
        this.controlsLeft = controls;
        this.entry = entry;
    }

    public boolean onComplete(ConsoleTile tile) {
        if (!this.controlsLeft.isEmpty()) {
            this.onMiss(tile);
            Random rand = tile.func_145831_w().field_73012_v;
            tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, 1.0f);
            for (LivingEntity ent : tile.func_145831_w().func_217357_a(LivingEntity.class, new AxisAlignedBB(tile.func_174877_v()).func_186662_g(20.0))) {
                ent.func_213317_d(ent.func_213322_ci().func_72441_c(rand.nextDouble() - 0.5, rand.nextDouble(), rand.nextDouble() - 0.5));
                if (!(ent instanceof ServerPlayerEntity)) continue;
                Network.sendTo(new MissControlMessage(), (ServerPlayerEntity)ent);
            }
            tile.getEmotionHandler().setMood(tile.getEmotionHandler().getMood() - 10.0);
            tile.getEmotionHandler().addLoyalty(tile.getPilot(), -5);
            for (Subsystem s : tile.getSubSystems()) {
                s.explode(true);
            }
            return false;
        }
        tile.getEmotionHandler().addLoyalty(tile.getPilot(), 1);
        Helper.addTardisStatistic(tile.getPilot(), TardisStatistics.FLIGHT_EVENTS_COMPLETED);
        return true;
    }

    public void onMiss(ConsoleTile tile) {
    }

    public boolean onControlHit(ConsoleTile console, AbstractControl control) {
        if (this.controlsLeft.contains(control.getEntry().getRegistryName())) {
            this.controlsLeft.remove(control.getEntry().getRegistryName());
            if (this.controlsLeft.isEmpty()) {
                this.isComplete = true;
                console.updateClient();
            }
            return true;
        }
        return false;
    }

    public int calcTime(ConsoleTile console) {
        ObjectWrapper<Float> wrapper = new ObjectWrapper<Float>(Float.valueOf(0.0f));
        console.getControl(ThrottleControl.class).ifPresent(throt -> wrapper.setValue(Float.valueOf(throt.getAmount())));
        float amt = wrapper.getValue().floatValue();
        int seconds = (Integer)TConfig.SERVER.controlTime.get() * 20;
        this.timeUntilMiss = console.flightTicks + seconds + (int)Math.floor((1.0f - amt) * (float)seconds);
        return this.timeUntilMiss;
    }

    public int getMissedTime() {
        return this.timeUntilMiss;
    }

    public List<ResourceLocation> getControls() {
        return this.controlsLeft;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"flight_events", (ResourceLocation)this.getEntry().getRegistryName());
        }
        return this.translationKey;
    }

    public TranslationTextComponent getTranslation() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    public void warnPlayers(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            for (PlayerEntity player : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(pos).func_186662_g(26.0))) {
                player.func_146105_b((ITextComponent)this.getTranslation().func_240699_a_(TextFormatting.ITALIC), true);
            }
        }
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public FlightEventFactory getEntry() {
        return this.entry;
    }

    public static interface IFlightConsequence {
        public void onMissed(ConsoleTile var1);
    }
}

