/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.exterior;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tardis.mod.blocks.TBlocks;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.misc.IDoorSoundScheme;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.upgrades.AtriumUpgrade;

public class TwoBlockBasicExterior
extends AbstractExterior {
    private Supplier<BlockState> top;
    private TexVariant[] variants = null;

    public TwoBlockBasicExterior(Supplier<BlockState> state, boolean isUnlockedByDefault, IDoorType type, IDoorSoundScheme sounds, ResourceLocation blueprint) {
        super(isUnlockedByDefault, type, sounds, blueprint);
        this.top = state;
    }

    public TwoBlockBasicExterior(Supplier<BlockState> state, boolean isUnlockedByDefault, IDoorType type, IDoorSoundScheme sounds, ResourceLocation blueprint, TexVariant[] variants) {
        this(state, isUnlockedByDefault, type, sounds, blueprint);
        this.variants = variants;
    }

    @Override
    public void demat(ConsoleTile console) {
        ServerWorld world = console.func_145831_w().func_73046_m().func_71218_a(console.getCurrentDimension());
        if (world != null) {
            if (this.getExteriorTile(console) != null) {
                this.getExteriorTile(console).demat(console.getSoundScheme().getLandTime());
            }
        } else {
            System.err.println("Tried to demat, but TARDIS location dimension is null!");
        }
    }

    @Override
    public void remat(ConsoleTile console) {
        ServerWorld world = console.func_145831_w().func_73046_m().func_71218_a(console.getDestinationDimension());
        if (world != null) {
            BlockPos pos = console.getDestinationPosition().func_177984_a();
            boolean isWater = world.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            BlockState state = (BlockState)this.top.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)console.getExteriorFacingDirection());
            if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(isWater));
            }
            world.func_175656_a(pos, state);
            world.func_175656_a(pos.func_177977_b(), (BlockState)((Block)TBlocks.bottom_exterior.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177977_b()).getFluidState().func_206884_a((ITag)FluidTags.field_206959_a))));
            TileEntity ext = world.func_175625_s(pos);
            if (ext instanceof ExteriorTile) {
                ExteriorTile exter = (ExteriorTile)ext;
                exter.copyConsoleData(console);
                world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(2, () -> exter.remat(console.getSoundScheme().getLandTime())));
                exter.placeExteriorBlocks();
            }
        } else {
            System.err.println("Tried to Remat, but TARDIS destination dimension is null!");
        }
    }

    @Override
    public boolean isUnlockedByDefault() {
        return this.isUnlockedByDefault;
    }

    @Override
    public int getWidth(ConsoleTile console) {
        AtriumUpgrade atrium = (AtriumUpgrade)console.getUpgrade(AtriumUpgrade.class).orElse(null);
        if (atrium != null && atrium.isActive()) {
            return atrium.getWidth();
        }
        return 0;
    }

    @Override
    public int getHeight(ConsoleTile console) {
        AtriumUpgrade atrium = (AtriumUpgrade)console.getUpgrade(AtriumUpgrade.class).orElse(null);
        if (atrium != null && atrium.isActive()) {
            return atrium.getHeight();
        }
        return 2;
    }

    @Override
    public ExteriorTile getExteriorTile(ConsoleTile console) {
        TileEntity te;
        ServerWorld world;
        if (!console.func_145831_w().func_201670_d() && (world = console.func_145831_w().func_73046_m().func_71218_a(console.getCurrentDimension())) != null && (te = world.func_175625_s(console.getCurrentLocation().func_177984_a())) instanceof ExteriorTile) {
            return (ExteriorTile)te;
        }
        return null;
    }

    @Override
    public ResourceLocation getBlueprintPreviewTexture() {
        return this.blueprint;
    }

    @Override
    public IDoorType getDoorType() {
        return this.type;
    }

    @Override
    public void remove(ConsoleTile tile) {
        ServerWorld world = tile.func_145831_w().func_73046_m().func_71218_a(tile.getCurrentDimension());
        if (world != null) {
            if (this.getExteriorTile(tile) != null) {
                this.getExteriorTile(tile).deleteExteriorBlocks();
            } else {
                System.err.println("Exterior was not found!");
            }
        } else {
            System.err.println("World was not loadable!");
        }
    }

    @Override
    public void place(ConsoleTile tile, RegistryKey<World> world, BlockPos pos) {
        ServerWorld targetWorld = tile.func_145831_w().func_73046_m().func_71218_a(world);
        if (targetWorld != null) {
            boolean isInWater = targetWorld.func_204610_c(pos.func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a);
            BlockState state = (BlockState)this.top.get().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)tile.getExteriorFacingDirection());
            if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(isInWater));
            }
            targetWorld.func_175656_a(pos.func_177984_a(), state);
            targetWorld.func_175656_a(pos, (BlockState)((Block)TBlocks.bottom_exterior.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(targetWorld.func_204610_c(pos).getFluidState().func_206884_a((ITag)FluidTags.field_206959_a))));
            tile.setCurrentLocation((RegistryKey<World>)targetWorld.func_234923_W_(), pos);
            if (targetWorld.func_175625_s(pos.func_177984_a()) instanceof ExteriorTile) {
                ExteriorTile exterior = (ExteriorTile)targetWorld.func_175625_s(pos.func_177984_a());
                exterior.copyConsoleData(tile);
                exterior.placeExteriorBlocks();
            }
        } else {
            System.err.println("World was not loadable!");
        }
    }

    @Override
    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent("exterior.tardis." + this.getRegistryName().func_110623_a());
    }

    @Override
    public TexVariant[] getVariants() {
        return this.variants;
    }

    @Override
    public BlockState getDefaultState() {
        return this.top.get();
    }

    @Override
    public IDoorSoundScheme getDoorSounds() {
        return this.sounds;
    }
}

