/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.exterior;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.misc.IDoorSoundScheme;
import net.tardis.mod.misc.IDoorType;
import net.tardis.mod.misc.TexVariant;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public abstract class AbstractExterior
extends ForgeRegistryEntry<AbstractExterior> {
    protected boolean isUnlockedByDefault = false;
    protected ResourceLocation blueprint = null;
    protected IDoorType type;
    protected TexVariant[] variants = null;
    protected IDoorSoundScheme sounds;
    protected String translationKey;

    public AbstractExterior(boolean isUnlockedByDefault, IDoorType type, IDoorSoundScheme sounds, ResourceLocation blueprint) {
        this.isUnlockedByDefault = isUnlockedByDefault;
        this.blueprint = blueprint;
        this.type = type;
        this.sounds = sounds;
    }

    public abstract void demat(ConsoleTile var1);

    public abstract void remat(ConsoleTile var1);

    public abstract ExteriorTile getExteriorTile(ConsoleTile var1);

    public abstract void remove(ConsoleTile var1);

    public abstract void place(ConsoleTile var1, RegistryKey<World> var2, BlockPos var3);

    public boolean isUnlockedByDefault() {
        return this.isUnlockedByDefault;
    }

    public abstract BlockState getDefaultState();

    public abstract int getWidth(ConsoleTile var1);

    public abstract int getHeight(ConsoleTile var1);

    public ResourceLocation getBlueprintPreviewTexture() {
        return this.blueprint;
    }

    public IDoorType getDoorType() {
        return this.type;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"exterior", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    @Nullable
    public TexVariant[] getVariants() {
        return this.variants;
    }

    public IDoorSoundScheme getDoorSounds() {
        return this.sounds;
    }
}

