/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.experimental.sound;

import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tardis.mod.entity.BessieEntity;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.tileentities.AntiGravityTile;

@OnlyIn(value=Dist.CLIENT)
public class EntityMovingSound
extends TickableSound {
    private final Entity entity;
    private final SoundEvent refSound;

    public EntityMovingSound(Entity entity, SoundEvent soundEvent, SoundCategory soundCategory) {
        super(soundEvent, soundCategory);
        this.entity = entity;
        this.refSound = soundEvent;
        this.field_147659_g = false;
        this.field_147665_h = 0;
        this.field_147662_b = 0.0f;
        this.field_147660_d = (float)entity.func_226277_ct_();
        this.field_147661_e = (float)entity.func_226278_cu_();
        this.field_147658_f = (float)entity.func_226281_cx_();
    }

    public EntityMovingSound(Entity entity, SoundEvent soundEvent, SoundCategory soundCategory, float vol) {
        this(entity, soundEvent, soundCategory);
        this.field_147659_g = false;
        this.field_147662_b = vol;
        this.field_147660_d = (float)entity.func_226277_ct_();
        this.field_147661_e = (float)entity.func_226278_cu_();
        this.field_147658_f = (float)entity.func_226281_cx_();
    }

    public EntityMovingSound(Entity entity, SoundEvent soundEvent, SoundCategory soundCategory, float vol, boolean repeat) {
        this(entity, soundEvent, soundCategory);
        this.field_147662_b = vol;
        this.field_147660_d = (float)entity.func_226277_ct_();
        this.field_147661_e = (float)entity.func_226278_cu_();
        this.field_147658_f = (float)entity.func_226281_cx_();
        this.field_147659_g = repeat;
    }

    public boolean func_211503_n() {
        return true;
    }

    public void func_73660_a() {
        if (!this.entity.func_70089_S()) {
            this.func_239509_o_();
        } else {
            this.field_147660_d = (float)this.entity.func_226277_ct_();
            this.field_147661_e = (float)this.entity.func_226278_cu_();
            this.field_147658_f = (float)this.entity.func_226281_cx_();
            float motion = MathHelper.func_76133_a((double)Entity.func_213296_b((Vector3d)this.entity.func_213322_ci()));
            if (this.refSound == TSounds.DALEK_MOVES.get() && this.entity instanceof DalekEntity) {
                DalekEntity dalek = (DalekEntity)this.entity;
                if (dalek.field_70160_al) {
                    this.silence();
                } else {
                    this.field_147662_b = 0.5f;
                }
            }
            if (this.refSound == TSounds.DALEK_HOVER.get()) {
                if (!this.entity.func_233570_aj_() || this.entity.field_70170_p.func_180495_p(this.entity.func_233580_cy_().func_177977_b()).func_196958_f()) {
                    this.field_147662_b = 0.5f;
                } else {
                    this.silence();
                }
            }
            if (this.entity instanceof AbstractClientPlayerEntity && this.refSound.getRegistryName().equals((Object)((SoundEvent)TSounds.SHIELD_HUM.get()).getRegistryName())) {
                if (AntiGravityTile.isInAntiGrav(this.entity.func_174813_aQ().func_72314_b(5.0, (double)this.entity.field_70170_p.func_217301_I(), 5.0), this.entity.field_70170_p)) {
                    this.field_147662_b = 0.2f;
                } else {
                    this.silence();
                }
            }
            if (this.entity instanceof BessieEntity) {
                if ((double)motion >= 0.01) {
                    this.field_147662_b = MathHelper.func_219799_g((float)MathHelper.func_76131_a((float)motion, (float)0.0f, (float)1.0f), (float)0.0f, (float)1.0f);
                } else {
                    this.silence();
                }
            }
        }
    }

    public void silence() {
        this.field_147662_b = 0.0f;
    }
}

