/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.events;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tardis.api.events.EntityOutOfWorldEvent;
import net.tardis.api.events.ServerSoundEvent;
import net.tardis.api.space.OxygenHelper;
import net.tardis.api.space.entities.ISpaceImmuneEntity;
import net.tardis.api.space.items.IGravArmor;
import net.tardis.mod.Tardis;
import net.tardis.mod.ars.ARSPiece;
import net.tardis.mod.ars.ConsoleRoom;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.cap.ChunkLoaderCapability;
import net.tardis.mod.cap.ILightCap;
import net.tardis.mod.cap.IMissionCap;
import net.tardis.mod.cap.IRift;
import net.tardis.mod.cap.ISpaceDimProperties;
import net.tardis.mod.cap.ITardisWorldData;
import net.tardis.mod.cap.LightCapability;
import net.tardis.mod.cap.MissionWorldCapability;
import net.tardis.mod.cap.RiftCapability;
import net.tardis.mod.cap.SpaceDimensionCapability;
import net.tardis.mod.cap.entity.IPlayerData;
import net.tardis.mod.cap.entity.PlayerDataCapability;
import net.tardis.mod.cap.items.DiagnosticToolCapability;
import net.tardis.mod.cap.items.IDiagnostic;
import net.tardis.mod.cap.items.IRemote;
import net.tardis.mod.cap.items.IVortexCap;
import net.tardis.mod.cap.items.IWatch;
import net.tardis.mod.cap.items.RemoteCapability;
import net.tardis.mod.cap.items.VortexCapability;
import net.tardis.mod.cap.items.WatchCapability;
import net.tardis.mod.cap.items.sonic.SonicCapability;
import net.tardis.mod.cap.items.sonic.SonicProvider;
import net.tardis.mod.client.ClientHelper;
import net.tardis.mod.commands.TardisCommand;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.constants.TardisConstants;
import net.tardis.mod.controls.HandbrakeControl;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.TardisEntity;
import net.tardis.mod.entity.ai.FollowIntoTardisGoal;
import net.tardis.mod.entity.ai.FollowOutOfTardisGoal;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.humanoid.HumanoidEmotionalState;
import net.tardis.mod.entity.mission.HumanoidMissionEntity;
import net.tardis.mod.enums.EnumDoorState;
import net.tardis.mod.events.LivingEvents;
import net.tardis.mod.events.MissingMappingsLookup;
import net.tardis.mod.experimental.advancement.TTriggers;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.BlockPosHelper;
import net.tardis.mod.helper.PlayerHelper;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.items.ISpaceHelmet;
import net.tardis.mod.items.SonicItem;
import net.tardis.mod.items.TItems;
import net.tardis.mod.items.TardisDiagnosticItem;
import net.tardis.mod.misc.Disguise;
import net.tardis.mod.misc.IDontBreak;
import net.tardis.mod.misc.TardisLike;
import net.tardis.mod.misc.TardisNames;
import net.tardis.mod.missions.KillMission;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.TPacketHandler;
import net.tardis.mod.network.packets.LaserDamageSyncMessage;
import net.tardis.mod.network.packets.MissionUpdateMessage;
import net.tardis.mod.registries.ControlRegistry;
import net.tardis.mod.registries.DisguiseRegistry;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.schematics.SchematicDataListener;
import net.tardis.mod.sonic.AbstractSonicMode;
import net.tardis.mod.sounds.TSounds;
import net.tardis.mod.subsystem.TemporalGraceSubsystem;
import net.tardis.mod.tags.TardisEntityTypeTags;
import net.tardis.mod.tileentities.BrokenExteriorTile;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.PlayerTelepathicConnection;
import net.tardis.mod.tileentities.exteriors.DisguiseExteriorTile;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;
import net.tardis.mod.trades.ItemTrade;
import net.tardis.mod.trades.TVillagerProfession;
import net.tardis.mod.traits.AbstractEntityDeathTrait;
import net.tardis.mod.traits.TardisTrait;
import net.tardis.mod.world.WorldGen;
import net.tardis.mod.world.biomes.TBiomes;
import net.tardis.mod.world.dimensions.TDimensions;
import net.tardis.mod.world.feature.TFeatures;
import net.tardis.mod.world.structures.TStructures;
import org.apache.logging.log4j.Level;

@Mod.EventBusSubscriber(modid="tardis", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEvents {
    public static final ResourceLocation LIGHT_CAP = new ResourceLocation("tardis", "light");
    public static final ResourceLocation CHUNK_CAP = new ResourceLocation("tardis", "loader");
    public static final ResourceLocation TARDIS_CAP = new ResourceLocation("tardis", "tardis_data");
    public static final ResourceLocation WATCH_CAP = new ResourceLocation("tardis", "watch");
    public static final ResourceLocation PLAYER_DATA_CAP = new ResourceLocation("tardis", "player_data");
    public static final ResourceLocation REMOTE_CAP = new ResourceLocation("tardis", "remote");
    public static final ResourceLocation VORTEX = new ResourceLocation("tardis", "vortex");
    public static final ResourceLocation LOCATOR = new ResourceLocation("tardis", "locator");
    public static final ResourceLocation RIFT = new ResourceLocation("tardis", "rift");
    public static final ResourceLocation SPACE_DIM_CAP = new ResourceLocation("tardis", "space_dim_property");
    public static final ResourceLocation SONIC_CAP = new ResourceLocation("tardis", "sonic_cap");
    public static final ResourceLocation MISSION_CAP = new ResourceLocation("tardis", "mission");
    private static HashMap<ResourceLocation, ResourceLocation> remappedEntries = new HashMap();
    private static Method GETCODEC_METHOD;

    @SubscribeEvent
    public static void onSoundPlayed(ServerSoundEvent serverSoundEvent) {
        BlockPos pos = serverSoundEvent.getBlockPos();
        World world = serverSoundEvent.getWorld();
        for (TileEntity tileEntity : world.field_147482_g) {
            if (!(tileEntity instanceof ExteriorTile) || !(tileEntity.func_174877_v().func_177951_i((Vector3i)pos) < (double)(serverSoundEvent.getVolume() * 16.0f))) continue;
            ExteriorTile exteriorTile = (ExteriorTile)tileEntity;
            float muffleCoeffecient = exteriorTile.getOpen() == EnumDoorState.BOTH ? 1.0f : (exteriorTile.getOpen() == EnumDoorState.ONE ? 0.8f : 0.6f);
            TardisHelper.getConsole(world.func_73046_m(), exteriorTile.getInteriorDimensionKey()).ifPresent(consoleTile -> consoleTile.getDoor().ifPresent(doorEntity -> doorEntity.func_184185_a(serverSoundEvent.getSound(), serverSoundEvent.getVolume() * muffleCoeffecient, serverSoundEvent.getPitch())));
        }
    }

    @SubscribeEvent
    public static void attachChunkCaps(AttachCapabilitiesEvent<Chunk> event) {
        if (event.getObject() != null && ((Chunk)event.getObject()).func_177412_p() != null) {
            if (WorldHelper.areDimensionTypesSame(((Chunk)event.getObject()).func_177412_p(), TDimensions.DimensionTypes.TARDIS_TYPE)) {
                event.addCapability(LIGHT_CAP, (ICapabilityProvider)new ILightCap.LightProvider(new LightCapability((Chunk)event.getObject())));
            } else {
                event.addCapability(RIFT, (ICapabilityProvider)new IRift.Provider(new RiftCapability((Chunk)event.getObject())));
            }
        }
    }

    @SubscribeEvent
    public static void attachItemStackCap(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == TItems.POCKET_WATCH.get()) {
            event.addCapability(WATCH_CAP, (ICapabilityProvider)new IWatch.Provider(new WatchCapability()));
        }
        if (((ItemStack)event.getObject()).func_77973_b() == TItems.STATTENHEIM_REMOTE.get()) {
            event.addCapability(REMOTE_CAP, (ICapabilityProvider)new IRemote.Provider(new RemoteCapability((ItemStack)event.getObject())));
        }
        if (((ItemStack)event.getObject()).func_77973_b() == TItems.VORTEX_MANIP.get()) {
            event.addCapability(VORTEX, (ICapabilityProvider)new IVortexCap.Provider(new VortexCapability((ItemStack)event.getObject(), 3)));
        }
        if (((ItemStack)event.getObject()).func_77973_b() instanceof TardisDiagnosticItem) {
            event.addCapability(LOCATOR, (ICapabilityProvider)new IDiagnostic.Provider(new DiagnosticToolCapability((ItemStack)event.getObject())));
        }
        if (((ItemStack)event.getObject()).func_77973_b() instanceof SonicItem) {
            event.addCapability(SONIC_CAP, (ICapabilityProvider)new SonicProvider(new SonicCapability((ItemStack)event.getObject())));
        }
    }

    @SubscribeEvent
    public static void attachPlayerCap(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(PLAYER_DATA_CAP, (ICapabilityProvider)new IPlayerData.Provider(new PlayerDataCapability((PlayerEntity)event.getObject())));
        }
    }

    @SubscribeEvent
    public static void registerTrades(VillagerTradesEvent event) {
        if (event.getType() == TVillagerProfession.STORY_TELLER.get()) {
            ((List)event.getTrades().get(2)).add(new ItemTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 15), new ItemStack((IItemProvider)TItems.ARTIFACT_MAP.get()), 1, 10));
            ((List)event.getTrades().get(1)).add(new ItemTrade(new ItemStack((IItemProvider)Items.field_151121_aF, 24), new ItemStack((IItemProvider)Items.field_151166_bC), 3, 3));
            ((List)event.getTrades().get(1)).add(new ItemTrade(new ItemStack((IItemProvider)Items.field_221792_df, 10), new ItemStack((IItemProvider)Items.field_151166_bC), 3, 3));
            ItemStack manual = new ItemStack((IItemProvider)TItems.MANUAL.get());
            manual.func_200302_a((ITextComponent)new StringTextComponent("Strange Journal"));
            ((List)event.getTrades().get(1)).add(new ItemTrade(new ItemStack((IItemProvider)Items.field_151166_bC, 3), manual, 5, 3));
        }
    }

    @SubscribeEvent
    public static void attachWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (WorldHelper.areDimensionTypesSame((World)event.getObject(), TDimensions.DimensionTypes.TARDIS_TYPE)) {
            event.addCapability(TARDIS_CAP, (ICapabilityProvider)new ITardisWorldData.TardisWorldProvider((World)event.getObject()));
        }
        if (((World)event.getObject()).func_234923_W_() == TDimensions.SPACE_DIM) {
            event.addCapability(MISSION_CAP, (ICapabilityProvider)new IMissionCap.Provider(new MissionWorldCapability((World)event.getObject())));
            event.addCapability(SPACE_DIM_CAP, (ICapabilityProvider)new ISpaceDimProperties.Provider(new SpaceDimensionCapability((RegistryKey<World>)((World)event.getObject()).func_234923_W_())));
        }
        if (((World)event.getObject()).func_234923_W_() == TDimensions.MOON_DIM || ((World)event.getObject()).func_234923_W_() == World.field_234920_i_) {
            event.addCapability(SPACE_DIM_CAP, (ICapabilityProvider)new ISpaceDimProperties.Provider(new SpaceDimensionCapability((RegistryKey<World>)((World)event.getObject()).func_234923_W_())));
        }
        if (((World)event.getObject()).func_201670_d()) {
            return;
        }
        final LazyOptional inst = LazyOptional.of(() -> new ChunkLoaderCapability((ServerWorld)event.getObject()));
        ICapabilitySerializable<INBT> provider = new ICapabilitySerializable<INBT>(){

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                return Capabilities.CHUNK_LOADER.orEmpty(cap, inst);
            }

            public INBT serializeNBT() {
                return Capabilities.CHUNK_LOADER.writeNBT(inst.orElse(null), null);
            }

            public void deserializeNBT(INBT nbt) {
                Capabilities.CHUNK_LOADER.readNBT(inst.orElse(null), null, nbt);
            }
        };
        event.addCapability(CHUNK_CAP, (ICapabilityProvider)provider);
        event.addListener(() -> inst.invalidate());
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        World world;
        if (event.getState().func_177230_c() instanceof IDontBreak) {
            event.setCanceled(true);
        }
        if (event.getWorld() instanceof World && !(world = (World)event.getWorld()).func_201670_d()) {
            block0: for (TileEntity te : ((World)event.getWorld()).field_147482_g) {
                if (!(te instanceof DisguiseExteriorTile)) continue;
                DisguiseExteriorTile disguiseTile = (DisguiseExteriorTile)te;
                Disguise disguise = disguiseTile.disguise;
                if (disguise == null || !te.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) continue;
                Direction facing = ((Direction)disguiseTile.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d();
                BlockPos extPos = disguiseTile.func_174877_v().func_185334_h();
                for (Map.Entry<BlockPos, BlockState> entry : disguise.getOtherBlocks().entrySet()) {
                    BlockPos offset = entry.getKey();
                    BlockPos rotated = WorldHelper.rotateBlockPos(offset, facing);
                    BlockPos rotatedOffset = extPos.func_177971_a((Vector3i)rotated);
                    if (!event.getPos().equals((Object)rotatedOffset) || !world.func_180495_p(rotatedOffset).func_203425_a(entry.getValue().func_177230_c())) continue;
                    event.setCanceled(true);
                    continue block0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockClicked(PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BellBlock) {
            ChunkPos pos = event.getWorld().func_217349_x(event.getEntity().func_233580_cy_()).func_76632_l();
            for (int x = -3; x < 3; ++x) {
                for (int z = -3; z < 3; ++z) {
                    for (TileEntity te : event.getWorld().func_212866_a_(pos.field_77276_a + x, pos.field_77275_b + z).func_177434_r().values()) {
                        if (!(te instanceof ExteriorTile) && !(te instanceof BrokenExteriorTile)) continue;
                        event.getWorld().func_184133_a(null, te.getTileEntity().func_174877_v(), (SoundEvent)TSounds.SINGLE_CLOISTER.get(), SoundCategory.BLOCKS, 5.0f, 0.5f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            event.world.getCapability(Capabilities.MISSION).ifPresent(cap -> cap.tick(event.world));
            if (!event.world.field_72995_K && event.world.func_82737_E() % 200L == 0L && WorldHelper.areDimensionTypesSame(event.world, TDimensions.DimensionTypes.TARDIS_TYPE)) {
                for (PlayerEntity player : event.world.func_217369_A()) {
                    ChunkPos pos = new ChunkPos(player.func_233580_cy_());
                    for (int x = -3; x < 3; ++x) {
                        for (int z = -3; z < 3; ++z) {
                            event.world.func_212866_a_(pos.field_77276_a + x, pos.field_77275_b + z).getCapability(Capabilities.LIGHT).ifPresent(cap -> cap.onLoad());
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && server.func_71278_l() && event.phase == TickEvent.Phase.START) {
            for (World world : server.func_212370_w()) {
                world.getCapability(Capabilities.TARDIS_DATA).ifPresent(ITardisWorldData::tick);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d()) {
            event.getWorld().func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                if (WorldHelper.areDimensionTypesSame(event.getWorld(), TDimensions.DimensionTypes.TARDIS_TYPE)) {
                    if (event.getEntity() instanceof IMob && !event.getEntity().func_200600_R().func_220341_a(TardisEntityTypeTags.IGNORED_ALARM_ENTITIES)) {
                        if (TardisHelper.getConsoleInWorld(event.getWorld()).isPresent()) {
                            TardisHelper.getConsoleInWorld(event.getWorld()).ifPresent(tile -> tile.getInteriorManager().setAlarmOn(true));
                        } else {
                            Tardis.LOGGER.error("Error trying to add entity: {}", (Object)event.getEntity().func_200600_R().getRegistryName().toString());
                            Tardis.LOGGER.error("Could not find Console tile in: {}", (Object)event.getWorld().func_234923_W_().func_240901_a_().toString());
                        }
                    }
                    if (event.getEntity() instanceof ServerPlayerEntity) {
                        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
                        TTriggers.OBTAINED.test(player);
                    }
                }
                if (event.getEntity() instanceof MonsterEntity) {
                    MonsterEntity ent = (MonsterEntity)event.getEntity();
                    ent.field_70714_bg.func_75776_a(0, (Goal)new FollowIntoTardisGoal((CreatureEntity)ent, ent.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                    ent.field_70714_bg.func_75776_a(1, (Goal)new FollowOutOfTardisGoal((CreatureEntity)ent, ent.func_110148_a(Attributes.field_233821_d_).func_111126_e()));
                }
                if (event.getEntity() instanceof ServerPlayerEntity && !event.getWorld().field_72995_K) {
                    event.getWorld().getCapability(Capabilities.MISSION).ifPresent(misCap -> {
                        for (MiniMission mis : misCap.getAllMissions()) {
                            Network.sendTo(new MissionUpdateMessage(mis), (ServerPlayerEntity)event.getEntity());
                        }
                    });
                }
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            ServerWorld toWorld = player.func_130014_f_().func_73046_m().func_71218_a(event.getTo());
            ServerWorld fromWorld = player.func_130014_f_().func_73046_m().func_71218_a(event.getFrom());
            if (TardisHelper.getConsoleInWorld((World)toWorld).isPresent()) {
                toWorld.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(20, () -> TardisHelper.getConsoleInWorld((World)toWorld).ifPresent(console -> {
                    if (event.getTo().func_240901_a_().equals((Object)console.func_145831_w().func_234923_W_().func_240901_a_())) {
                        console.relocatePlayerIfExteriorDeadlocked(player, (World)toWorld);
                        console.forceLoadExteriorChunk(true);
                    }
                })));
            } else if (WorldHelper.areDimensionTypesSame((World)fromWorld, TDimensions.DimensionTypes.TARDIS_TYPE)) {
                fromWorld.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(20, () -> TardisHelper.getConsoleInWorld((World)fromWorld).ifPresent(console -> {
                    if (event.getTo().func_240901_a_().equals((Object)console.getCurrentDimension().func_240901_a_())) {
                        if (console.doesConsoleWorldHaveNoPlayers()) {
                            console.forceLoadExteriorChunk(false);
                        }
                        console.startInteriorChangeProcess(toWorld);
                    }
                })));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            entity.getCapability(Capabilities.PLAYER_DATA).ifPresent(cap -> cap.tick());
            if (!entity.field_70170_p.field_72995_K && entity.field_70170_p.func_82737_E() % 400L == 0L) {
                ChunkPos playerChunk = new ChunkPos(entity.func_233580_cy_());
                for (int x = -3; x <= 3; ++x) {
                    for (int z = -3; z <= 3; ++z) {
                        ChunkPos pos = new ChunkPos(playerChunk.field_77276_a + x, playerChunk.field_77275_b + z);
                        BlockPos riftPos = pos.func_206849_h();
                        IRift rift = (IRift)entity.field_70170_p.func_212866_a_(pos.field_77276_a, pos.field_77275_b).getCapability(Capabilities.RIFT).orElse(null);
                        if (rift == null) continue;
                        if (entity.func_70681_au().nextDouble() < 0.001) {
                            rift.setRift(true);
                            Tardis.LOGGER.log(Level.DEBUG, String.format("New rift created at: %s, %s", riftPos.func_177958_n() + 8, riftPos.func_177952_p() + 8));
                        }
                        if (!rift.isRift()) continue;
                        rift.addEnergy(10.0f);
                        Tardis.LOGGER.log(Level.DEBUG, String.format("Rift refueled at: %s, %s now has %s", riftPos.func_177958_n() + 8, riftPos.func_177952_p() + 8, Float.valueOf(rift.getRiftEnergy())));
                    }
                }
            }
        }
        entity.field_70170_p.getCapability(Capabilities.SPACE_DIM_PROPERTIES).ifPresent(cap -> {
            if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).field_71075_bZ.field_75100_b) {
                boolean hasBoots;
                ItemStack boots = entity.func_184582_a(EquipmentSlotType.FEET);
                boolean bl = hasBoots = boots.func_77973_b() instanceof IGravArmor && ((IGravArmor)boots.func_77973_b()).useNormalGrav(entity, boots);
                if (!hasBoots) {
                    entity.func_213317_d(cap.modMotion((Entity)entity));
                }
            }
            if (!cap.hasAir() && entity.field_70173_aa % 20 == 0) {
                ItemStack helm = event.getEntityLiving().func_184582_a(EquipmentSlotType.HEAD);
                if (helm.func_77973_b() instanceof ISpaceHelmet && !((ISpaceHelmet)helm.func_77973_b()).shouldSufficate(entity)) {
                    return;
                }
                if (!MinecraftForge.EVENT_BUS.post((Event)new LivingEvents.SpaceAir(entity))) {
                    entity.func_70097_a(TDamageSources.SPACE, 2.0f);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        if (WorldHelper.areDimensionTypesSame(event.getEntity().func_130014_f_(), TDimensions.DimensionTypes.TARDIS_TYPE) && event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            TardisHelper.getConsoleInWorld(player.func_130014_f_()).ifPresent(console -> {
                PlayerTelepathicConnection connection;
                if (console.func_145830_o() && !console.func_145831_w().field_72995_K && (connection = console.getEmotionHandler().getConnectedPlayers().get(player.func_110124_au())) != null) {
                    connection.onSlept(player.func_184102_h());
                }
            });
        }
    }

    @SubscribeEvent
    public static void sonicOnEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().func_77973_b() instanceof SonicItem) {
            ItemStack stack = event.getItemStack();
            AbstractSonicMode mode = SonicItem.getCurrentMode(stack);
            mode.processSpecialEntity(event);
        }
    }

    @SubscribeEvent
    public static void sonicOnSpecialBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getItemStack().func_77973_b() instanceof SonicItem) {
            ItemStack stack = event.getItemStack();
            AbstractSonicMode mode = SonicItem.getCurrentMode(stack);
            mode.processSpecialBlocks(event);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (event.getSource() != null && event.getSource().func_76346_g() instanceof DalekEntity) {
                Network.sendToAllAround(new LaserDamageSyncMessage(event.getEntityLiving().func_145782_y()), (RegistryKey<World>)event.getEntityLiving().field_70170_p.func_234923_W_(), event.getEntityLiving().func_233580_cy_(), 20);
            }
            if (event.getEntityLiving() instanceof HumanoidMissionEntity && event.getSource().func_76346_g() instanceof PlayerEntity) {
                HumanoidMissionEntity missionHumanoid = (HumanoidMissionEntity)event.getEntity();
                missionHumanoid.field_70170_p.getCapability(Capabilities.MISSION).ifPresent(cap -> {
                    if (cap.getMissionForPos(missionHumanoid.func_233580_cy_()) != null) {
                        MiniMission mission = cap.getMissionForPos(missionHumanoid.func_233580_cy_());
                        if (missionHumanoid.func_200600_R() == mission.getMissionHostEntity()) {
                            missionHumanoid.setEmotionalState(HumanoidEmotionalState.HOSTILE);
                        }
                    }
                });
            }
            if (WorldHelper.areDimensionTypesSame(event.getEntityLiving().func_130014_f_(), TDimensions.DimensionTypes.TARDIS_TYPE) && !event.getSource().func_76357_e()) {
                TardisHelper.getConsoleInWorld(event.getEntityLiving().field_70170_p).ifPresent(tile -> tile.getSubsystem(TemporalGraceSubsystem.class).ifPresent(grace -> {
                    if (grace.canBeUsed()) {
                        grace.damage(event.getEntityLiving() instanceof ServerPlayerEntity ? (ServerPlayerEntity)event.getEntityLiving() : null, 1);
                        event.setCanceled(true);
                    }
                }));
            }
            if (WorldHelper.handleTardisVoidSaving((Entity)event.getEntityLiving())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamaged(LivingDamageEvent event) {
        if (!event.getEntityLiving().field_70170_p.func_201670_d() && event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (event.getEntityLiving().func_110143_aJ() <= 6.0f) {
                for (ServerWorld interior : TardisHelper.getTardises(event.getEntityLiving().func_184102_h())) {
                    ConsoleTile console;
                    if (!WorldHelper.canTravelToDimension(player.field_70170_p) || (console = (ConsoleTile)TardisHelper.getConsoleInWorld((World)interior).orElse(null)) == null) continue;
                    console.getControl(HandbrakeControl.class).ifPresent(handBrake -> {
                        if (!console.isInFlight() && console.getEmotionHandler().getLoyalty(player.func_110124_au()) > 100 && handBrake.isFree() && !console.getInteriorManager().isInteriorStillRegenerating() && console.canFly() && player.func_233580_cy_().func_177956_o() > 0 && player.func_70089_S() && player.field_70170_p.func_180495_p(player.func_233580_cy_().func_177984_a()).func_196958_f()) {
                            console.getExteriorType().remove(console);
                            console.setCurrentLocation((RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.func_233580_cy_());
                            console.getExteriorType().place(console, (RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.func_233580_cy_());
                            ExteriorTile ext = console.getExteriorType().getExteriorTile(console);
                            if (ext != null) {
                                ext.remat(console.getSoundScheme().getLandTime());
                            }
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityOutOfWorld(EntityOutOfWorldEvent event) {
        if (!event.getEntity().func_130014_f_().func_201670_d() && !WorldHelper.handleTardisVoidSaving(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)ConsoleRoom.DATA_LOADER);
        event.addListener((IFutureReloadListener)ARSPiece.DATA_LOADER);
        event.addListener((IFutureReloadListener)SchematicDataListener.INSTANCE);
        event.addListener(TardisLike.DATA_LOADER);
        event.addListener(new IFutureReloadListener(){

            public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return stage.func_216872_a((Object)Unit.INSTANCE).thenRun(() -> TardisNames.read(resourceManager));
            }
        });
        event.addListener(new IFutureReloadListener(){

            public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return stage.func_216872_a((Object)Unit.INSTANCE).thenRun(() -> DisguiseRegistry.DISGUISE_REGISTRY.get().getValues().forEach(d -> {
                    Tardis.LOGGER.log(Level.DEBUG, "Adding Blocks to Disguise " + d.getRegistryName().toString());
                    d.readData(resourceManager, d.getRegistryName());
                }));
            }
        });
    }

    @SubscribeEvent
    public static void useVortexM(PlayerInteractEvent.RightClickEmpty e) {
        if (e.getPlayer().func_184614_ca().func_190926_b()) {
            ItemStack vm = new ItemStack((IItemProvider)TItems.VORTEX_MANIP.get());
            if (((Boolean)TConfig.CLIENT.openVMEmptyHand.get()).booleanValue() && e.getPlayer().field_71071_by.func_70431_c(vm)) {
                int index = PlayerHelper.findItem(e.getPlayer(), vm).getAsInt();
                ItemStack stack = e.getPlayer().field_71071_by.func_70301_a(index);
                if (e.getWorld().field_72995_K && !e.getPlayer().func_184811_cZ().func_185141_a(stack.func_77973_b())) {
                    ClientHelper.openGUI(5, null);
                    if (!PlayerHelper.isInEitherHand((LivingEntity)e.getPlayer(), vm.func_77973_b())) {
                        stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> cap.setOpen(true));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKilled(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getEntityLiving().func_70613_aW()) {
            for (ServerWorld world : TardisHelper.getTardises(event.getEntityLiving().func_184102_h())) {
                TardisHelper.getConsoleInWorld((World)world).ifPresent(console -> {
                    if (console.getEmotionHandler().getLoyalty(event.getEntityLiving().func_110124_au()) > 10) {
                        console.playSoundAtExterior((SoundEvent)TSounds.SINGLE_CLOISTER.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        console.func_145831_w().func_184133_a(null, console.func_174877_v(), (SoundEvent)TSounds.SINGLE_CLOISTER.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                });
            }
        }
        event.getEntityLiving().field_70170_p.getCapability(Capabilities.MISSION).ifPresent(missions -> {
            MiniMission current = missions.getMissionForPos(event.getEntityLiving().func_233580_cy_());
            if (current instanceof KillMission) {
                ((KillMission)current).onKill((Entity)event.getEntityLiving());
            }
        });
        if (event.getEntityLiving().func_70613_aW() && event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            for (ServerWorld world : TardisHelper.getTardises(player.func_184102_h())) {
                TardisHelper.getConsoleInWorld((World)world).ifPresent(tile -> {
                    if (tile.getEmotionHandler().getLoyaltyTrackingCrew().contains(player.func_110124_au())) {
                        for (TardisTrait trait : tile.getEmotionHandler().getTraits()) {
                            if (!(trait instanceof AbstractEntityDeathTrait)) continue;
                            ((AbstractEntityDeathTrait)trait).onPlayerKilledEntity(player, (ConsoleTile)((Object)tile), event.getEntityLiving());
                        }
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onBoomBoom(ExplosionEvent.Detonate event) {
        for (BlockPos pos : event.getExplosion().func_180343_e()) {
            TileEntity te = event.getWorld().func_175625_s(pos);
            if (!(te instanceof ExteriorTile) || te instanceof DisguiseExteriorTile) continue;
            ExteriorTile tile = (ExteriorTile)te;
            tile.damage(10);
            TardisEntity tardis = tile.fall();
            if (tardis == null || tardis.func_70089_S()) continue;
            Vector3d mot = new Vector3d(tardis.func_226277_ct_(), tardis.func_226278_cu_(), tardis.func_226281_cx_()).func_178788_d(event.getExplosion().getPosition()).func_72432_b();
            tardis.func_213317_d(mot);
        }
    }

    @SubscribeEvent
    public static void onSuffocate(LivingEvents.SpaceAir event) {
        if (event.getEntityLiving() instanceof ISpaceImmuneEntity && !((ISpaceImmuneEntity)event.getEntityLiving()).shouldTakeSpaceDamage()) {
            event.setCanceled(true);
            return;
        }
        for (TileEntity te : event.getEntityLiving().field_70170_p.field_147482_g) {
            te.getCapability(Capabilities.OXYGEN_SEALER).ifPresent(oxy -> {
                if (oxy.getSealedPositions().contains(event.getEntityLiving().func_233580_cy_().func_177963_a(0.0, (double)event.getEntityLiving().func_70047_e(), 0.0))) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        ItemStack vm;
        ServerPlayerEntity sPlayer;
        ItemStack stack;
        PlayerEntity playerEntity;
        if (event.getEntity() instanceof PlayerEntity && !(playerEntity = (PlayerEntity)event.getEntity()).func_130014_f_().func_201670_d() && (stack = PlayerHelper.getHeldOrNearestStack((PlayerEntity)(sPlayer = (ServerPlayerEntity)playerEntity), vm = new ItemStack((IItemProvider)TItems.VORTEX_MANIP.get()))) != null && !stack.func_190926_b()) {
            stack.getCapability(Capabilities.VORTEX_MANIP).ifPresent(cap -> {
                float totalCurrentCharge = cap.getTotalCurrentCharge();
                if (totalCurrentCharge < 50.0f) {
                    return;
                }
                double d3 = playerEntity.func_226282_d_(500.0);
                double d4 = MathHelper.func_151237_a((double)sPlayer.func_226279_cv_(), (double)0.0, (double)(sPlayer.field_70170_p.func_217301_I() - 1));
                double d5 = playerEntity.func_226287_g_(500.0);
                BlockPos tpPos = new BlockPos(d3, d4, d5);
                double diff = Math.sqrt(playerEntity.func_233580_cy_().func_177951_i((Vector3i)tpPos));
                float artronNeeded = (float)((double)((Integer)TConfig.SERVER.vmBaseFuelUsage.get()).intValue() + (Double)TConfig.SERVER.vmFuelUsageMultiplier.get() * diff);
                if (totalCurrentCharge < artronNeeded) {
                    float affordablePercentage = (totalCurrentCharge - 10.0f) / artronNeeded;
                    tpPos = BlockPosHelper.lerp(sPlayer.func_233580_cy_(), tpPos, affordablePercentage);
                }
                if (sPlayer.func_184218_aH()) {
                    playerEntity.func_184210_p();
                }
                sPlayer.func_146105_b((ITextComponent)new TranslationTextComponent("message.vm.lightning_malfunction"), false);
                TPacketHandler.handleVortexMTeleport(sPlayer, tpPos, false);
                event.setCanceled(true);
            });
        }
    }

    @SubscribeEvent
    public static void onEntered(LivingEvents.TardisEnterEvent event) {
        List list = event.getEntityLiving().field_70170_p.func_217357_a(TameableEntity.class, new AxisAlignedBB(event.getEntityLiving().func_233580_cy_()).func_186662_g(16.0));
        list.removeIf(ent -> ent.func_233685_eM_() || ent.func_184753_b() == null || !ent.func_184753_b().equals(event.getEntityLiving().func_110124_au()) || ent.field_70128_L);
        if (!list.isEmpty()) {
            event.getExterior().transferEntities(new ArrayList<Entity>(list));
        }
    }

    @SubscribeEvent
    public static void onLeft(LivingEvents.TardisLeaveEvent event) {
        List list = event.getEntityLiving().field_70170_p.func_217357_a(TameableEntity.class, new AxisAlignedBB(event.getEntityLiving().func_233580_cy_()).func_186662_g(16.0));
        list.removeIf(ent -> ent.func_233685_eM_() || !event.getEntityLiving().func_110124_au().equals(ent.func_184753_b()) || ent.field_70128_L);
        event.getDoor().teleportEntities(new ArrayList<Entity>(list));
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player.field_70170_p.func_201670_d() && ModList.get().isLoaded("optifine") && ((Boolean)TConfig.CLIENT.displayOptifineWarning.get()).booleanValue()) {
            player.func_146105_b((ITextComponent)TardisConstants.Translations.OPTIFINE_WARNING, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayerEntity player;
        ServerWorld world;
        PlayerEntity ent = event.getPlayer();
        if (ent instanceof ServerPlayerEntity && WorldHelper.areDimensionTypesSame((World)(world = (player = (ServerPlayerEntity)ent).func_71121_q()), TDimensions.DimensionTypes.TARDIS_TYPE)) {
            TardisHelper.getConsoleInWorld((World)world).ifPresent(console -> {
                if (!console.getInteriorManager().isInteriorStillRegenerating() && !console.isInFlight() && world.func_217369_A().size() == 1 && world.func_217369_A().contains(ent)) {
                    console.forceLoadExteriorChunk(false);
                    console.forceLoadInteriorChunk(false, true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        TardisCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        OxygenHelper.readOrCreate();
    }

    @SubscribeEvent
    public static void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        WorldGen.addStructuresToJigsawPools(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            HashMap<IForgeRegistryEntry, Object> tempMap;
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ChunkGenerator chunkGenerator = serverWorld.func_72863_F().func_201711_g();
            if (ModList.get().isLoaded("terraforged")) {
                try {
                    ResourceLocation cgRL;
                    if (GETCODEC_METHOD == null) {
                        GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                    }
                    if ((cgRL = Registry.field_239690_aB_.func_177774_c((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.func_110624_b().equals("terraforged")) {
                        Tardis.LOGGER.info("Setting up compatibility with Terraforged's ChunkGenerator for world {}!", (Object)serverWorld.func_234923_W_().func_240901_a_());
                        return;
                    }
                }
                catch (Exception e) {
                    Tardis.LOGGER.error("Was unable to check if " + serverWorld.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator.");
                }
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap seperationSettings = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            for (Map.Entry entry : seperationSettings.entrySet()) {
                if (!((Structure)entry.getKey()).getRegistryName().func_110624_b().equals("tardis")) continue;
                if (entry.getValue() == null) {
                    String errorMessage = String.format("Error detected in Structure!\nStructure ID: %s\nThis structure's seperation settings is null!\nThis could be caused by your Structure Spacing being smaller than Structure Seperation values!\nThis is not allowed, Structure Spacing must be LARGER than Structure Seperation values!\nPlease check your tardis-common.toml config options!\nIf you are stuck, regenerate the config values by deleting the tardis-common.toml file!", ((Structure)entry.getKey()).getRegistryName().toString());
                    throw new NullPointerException(errorMessage);
                }
                if (((StructureSeparationSettings)entry.getValue()).func_236668_a_() > ((StructureSeparationSettings)entry.getValue()).func_236671_b_()) continue;
                String errorMessage = String.format("Structure Spacing must be larger then Structure Seperation values!\nStructure ID: %s\nInput Spacing: %s, Input Seperation: %s.\nThis is an intentional crash.\nPlease check your tardis-common.toml config options!\nPlease note: the vanilla warning of 'Spacing has to be smaller than separation' is wrong!", ((Structure)entry.getKey()).getRegistryName().toString(), ((StructureSeparationSettings)entry.getValue()).func_236668_a_(), ((StructureSeparationSettings)entry.getValue()).func_236671_b_());
                throw new IllegalStateException(errorMessage);
            }
            if (serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                tempMap = new HashMap<IForgeRegistryEntry, Object>(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.put(TStructures.Structures.CRASHED_STRUCTURE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TStructures.Structures.CRASHED_STRUCTURE.get()));
                tempMap.put(TStructures.Structures.DALEK_SHIP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TStructures.Structures.DALEK_SHIP.get()));
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            }
            if (serverWorld.func_234923_W_().equals(TDimensions.SPACE_DIM)) {
                tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.put(TStructures.Structures.SPACE_STATION_DRONE.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TStructures.Structures.SPACE_STATION_DRONE.get()));
                tempMap.put(TStructures.Structures.ABANDONED_SPACESHIP.get(), DimensionStructuresSettings.field_236191_b_.get((Object)TStructures.Structures.ABANDONED_SPACESHIP.get()));
                serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        RegistryKey biomeRegistryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        Biome.Category biomeCategory = event.getCategory();
        if (biomeCategory != Biome.Category.NETHER && biomeCategory != Biome.Category.THEEND && biomeRegistryKey != TBiomes.TARDIS_BIOME_KEY && biomeRegistryKey != TBiomes.VORTEX_BIOME_KEY) {
            if (biomeRegistryKey != TBiomes.SPACE_BIOME_KEY && biomeRegistryKey != Biomes.field_185440_P && biomeRegistryKey != TBiomes.MOON_BIOME_KEY) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, TFeatures.ConfiguredFeatures.CONFIGURED_CINNABAR_ORE);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, TFeatures.ConfiguredFeatures.CONFIGURED_XION_CRYSTAL);
                event.getGeneration().func_242513_a(GenerationStage.Decoration.RAW_GENERATION, TFeatures.ConfiguredFeatures.CONFIGURED_BROKEN_EXTERIOR);
                if (biomeCategory != Biome.Category.OCEAN) {
                    event.getGeneration().getStructures().add(() -> TStructures.ConfiguredStructures.CONFIGURED_CRASHED_STRUCTURE);
                    event.getGeneration().getStructures().add(() -> TStructures.ConfiguredStructures.CONFIGURED_DALEK_SHIP);
                }
            } else {
                if (biomeRegistryKey == TBiomes.SPACE_BIOME_KEY) {
                    event.getGeneration().getStructures().add(() -> TStructures.ConfiguredStructures.CONFIGURED_SPACE_STATION_DRONE);
                    event.getGeneration().getStructures().add(() -> TStructures.ConfiguredStructures.CONFIGURED_ABANDONED_SPACESHIP);
                }
                if (biomeRegistryKey == TBiomes.MOON_BIOME_KEY) {
                    event.getGeneration().getStructures().add(() -> TStructures.ConfiguredStructures.CONFIGURED_MOON_LANDER);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getWorld().func_241828_r().func_243612_b(Registry.field_239698_ad_) != null && event.getWorld().func_241828_r().func_243612_b(Registry.field_239698_ad_).func_177774_c((Object)event.getWorld().func_230315_m_()) != null && event.getWorld().func_241828_r().func_243612_b(Registry.field_239698_ad_).func_177774_c((Object)event.getWorld().func_230315_m_()).equals((Object)TDimensions.DimensionTypes.TARDIS_TYPE.func_240901_a_()) && event.getEntityLiving() != null && event.getEntityLiving().func_200600_R() != null && (event.getSpawnReason() == SpawnReason.NATURAL || !WorldHelper.canEntitySpawnInTardis(event.getEntityLiving().func_200600_R()))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            remappedEntries.forEach((oldName, newName) -> {
                if (entry.key.equals(oldName)) {
                    entry.remap(ForgeRegistries.BLOCKS.getValue(newName));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMissingItemMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            remappedEntries.forEach((oldName, newName) -> {
                if (entry.key.equals(oldName)) {
                    entry.remap(ForgeRegistries.ITEMS.getValue(newName));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMissingControlMapping(RegistryEvent.MissingMappings<ControlRegistry.ControlEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            remappedEntries.forEach((oldName, newName) -> {
                if (entry.key.equals(oldName)) {
                    entry.remap(ControlRegistry.CONTROL_REGISTRY.get().getValue(newName));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onMissingExteriorMapping(RegistryEvent.MissingMappings<AbstractExterior> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            remappedEntries.forEach((oldName, newName) -> {
                if (entry.key.equals(oldName)) {
                    entry.remap(ExteriorRegistry.EXTERIOR_REGISTRY.get().getValue(newName));
                }
            });
        }
    }

    public static void getAllMappingEntries() {
        JsonObject obj = MissingMappingsLookup.getMissingMappings();
        for (Map.Entry entry : obj.entrySet()) {
            remappedEntries.put(new ResourceLocation("tardis", (String)entry.getKey()), new ResourceLocation("tardis", ((JsonElement)entry.getValue()).getAsString()));
        }
    }
}

