/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.projectiles;

import net.minecraft.block.BlockState;
import net.minecraft.block.TNTBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.misc.AbstractWeapon;

public class LaserEntity
extends ThrowableEntity {
    public float damage = 10.0f;
    public float scale = 0.5f;
    private Vector3d color = new Vector3d(0.0, 1.0, 1.0);
    private DamageSource source = DamageSource.field_76377_j;
    private AbstractWeapon<? extends LivingEntity> weapon;
    private float rayLength = 1.0f;
    public static final DataParameter<Float> RAY_LENGTH = EntityDataManager.func_187226_a(LaserEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<CompoundNBT> COLOR = EntityDataManager.func_187226_a(LaserEntity.class, (IDataSerializer)DataSerializers.field_192734_n);

    public LaserEntity(EntityType<? extends ThrowableEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public LaserEntity(EntityType<? extends ThrowableEntity> type, double x, double y, double z, World worldIn) {
        super(type, x, y, z, worldIn);
    }

    public LaserEntity(EntityType<? extends ThrowableEntity> type, LivingEntity livingEntityIn, World worldIn) {
        super(type, livingEntityIn, worldIn);
    }

    public LaserEntity(EntityType<? extends ThrowableEntity> type, double x, double y, double z, World worldIn, LivingEntity livingEntityIn, float damage, DamageSource source) {
        super(type, x, y, z, worldIn);
        this.func_212361_a((Entity)livingEntityIn);
        this.damage = damage;
        this.source = source;
    }

    public LaserEntity(EntityType<? extends ThrowableEntity> type, LivingEntity livingEntityIn, World worldIn, float damage, DamageSource source) {
        super(type, livingEntityIn, worldIn);
        this.damage = damage;
        this.source = source;
    }

    public LaserEntity(World world) {
        this((EntityType<? extends ThrowableEntity>)((EntityType)TEntities.LASER.get()), world);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(RAY_LENGTH, (Object)Float.valueOf(this.rayLength));
        this.func_184212_Q().func_187214_a(COLOR, (Object)new CompoundNBT());
    }

    public void func_70037_a(CompoundNBT compoundNBT) {
        Vector3d colorFromData;
        super.func_70037_a(compoundNBT);
        this.damage = compoundNBT.func_74760_g("damage");
        CompoundNBT colorData = compoundNBT.func_74775_l("color");
        this.func_184212_Q().func_187227_b(COLOR, (Object)colorData);
        this.color = colorFromData = new Vector3d(colorData.func_74769_h("red"), colorData.func_74769_h("green"), colorData.func_74769_h("blue"));
        this.scale = compoundNBT.func_74760_g("scale");
        this.rayLength = compoundNBT.func_74760_g("ray_length");
        this.func_184212_Q().func_187227_b(RAY_LENGTH, (Object)Float.valueOf(this.rayLength));
    }

    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74776_a("damage", this.damage);
        CompoundNBT colorData = (CompoundNBT)this.func_184212_Q().func_187225_a(COLOR);
        colorData = this.setColorNBT(colorData, this.color);
        compoundNBT.func_218657_a("color", (INBT)colorData);
        compoundNBT.func_74776_a("scale", this.scale);
        this.rayLength = ((Float)this.func_184212_Q().func_187225_a(RAY_LENGTH)).floatValue();
        compoundNBT.func_74776_a("ray_length", this.rayLength);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        double speed = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72438_d(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s));
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 600 || speed < 0.01)) {
            this.func_70106_y();
        }
        if (this.func_70089_S()) {
            super.func_70071_h_();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result == null || !this.func_70089_S()) {
            return;
        }
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult entityHitResult = (EntityRayTraceResult)result;
            if (entityHitResult.func_216348_a() == this.func_234616_v_() || entityHitResult == null) {
                return;
            }
            Entity hitEntity = entityHitResult.func_216348_a();
            if (this.weapon != null) {
                this.weapon.onHitEntityPre(this, hitEntity);
            }
            hitEntity.func_70097_a(this.source, this.weapon == null ? this.damage : this.weapon.damage());
        } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            BlockPos pos = blockResult.func_216350_a();
            BlockState block = this.field_70170_p.func_180495_p(pos);
            if (this.weapon != null) {
                this.weapon.onHitBlockPre(this, block);
            }
            if (block.func_177230_c() instanceof TNTBlock) {
                this.field_70170_p.func_217377_a(pos, false);
                TNTEntity tntEntity = new TNTEntity(this.field_70170_p, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), (LivingEntity)this.func_234616_v_());
                tntEntity.func_184534_a(0);
                this.field_70170_p.func_217376_c((Entity)tntEntity);
                this.field_70170_p.func_184148_a(null, tntEntity.func_226277_ct_(), tntEntity.func_226278_cu_(), tntEntity.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (this.field_70170_p.func_201670_d()) {
                    this.field_70170_p.func_195590_a((IParticleData)ParticleTypes.field_197601_L, true, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.weapon != null) {
            this.weapon.onHit(this, result);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void setWeaponType(AbstractWeapon<? extends LivingEntity> weap) {
        this.weapon = weap;
    }

    public void setColor(Vector3d color) {
        this.color = color;
        CompoundNBT colorData = (CompoundNBT)this.func_184212_Q().func_187225_a(COLOR);
        this.func_184212_Q().func_187227_b(COLOR, (Object)this.setColorNBT(colorData, this.color));
    }

    public Vector3d getColor() {
        Vector3d colorFromData;
        CompoundNBT colorData = (CompoundNBT)this.func_184212_Q().func_187225_a(COLOR);
        this.color = colorFromData = new Vector3d(colorData.func_74769_h("red"), colorData.func_74769_h("green"), colorData.func_74769_h("blue"));
        return this.color;
    }

    public CompoundNBT setColorNBT(CompoundNBT input, Vector3d color) {
        input.func_74780_a("red", color.field_72450_a);
        input.func_74780_a("green", color.field_72448_b);
        input.func_74780_a("blue", color.field_72449_c);
        return input;
    }

    public void setSource(DamageSource source) {
        this.source = source;
    }

    public DamageSource getSource() {
        return this.source;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getRayLength() {
        return ((Float)this.func_184212_Q().func_187225_a(RAY_LENGTH)).floatValue();
    }

    public void setRayLength(float length) {
        this.rayLength = length;
        this.func_184212_Q().func_187227_b(RAY_LENGTH, (Object)Float.valueOf(this.rayLength));
    }
}

