/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.mission;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.entity.humanoid.AbstractHumanoidEntity;
import net.tardis.mod.entity.humanoid.HumanoidEmotionalState;
import net.tardis.mod.helper.Helper;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.missions.MiniMission;
import net.tardis.mod.missions.misc.Dialog;

public class HumanoidMissionEntity
extends AbstractHumanoidEntity {
    public ITextComponent cachedDisplayName;
    public static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(HumanoidMissionEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> EMOTIONAL_STATE = EntityDataManager.func_187226_a(HumanoidMissionEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final ResourceLocation[] HUMAN_TEXTURES = new ResourceLocation[]{Helper.createRL("textures/entity/crew/1.png"), Helper.createRL("textures/entity/crew/2.png"), Helper.createRL("textures/entity/crew/3.png"), Helper.createRL("textures/entity/crew/4.png"), Helper.createRL("textures/entity/crew/5.png"), Helper.createRL("textures/entity/crew/6.png"), Helper.createRL("textures/entity/crew/7.png")};

    public HumanoidMissionEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public Dialog getCurrentDialog(PlayerEntity player) {
        return this.setupDialog(player);
    }

    public Dialog setupDialog(PlayerEntity player) {
        ObjectWrapper<Object> dialog = new ObjectWrapper<Object>(null);
        this.field_70170_p.getCapability(Capabilities.MISSION).ifPresent(miss -> {
            MiniMission mission = miss.getMissionForPos(this.func_233580_cy_());
            if (mission != null) {
                dialog.setValue(mission.getDialogForObjective((LivingEntity)this, player, mission.getCurrentObjective()));
            }
        });
        return dialog.getValue();
    }

    @Override
    public ResourceLocation getSkin() {
        return HUMAN_TEXTURES[(Integer)this.func_184212_Q().func_187225_a(VARIANT)];
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(VARIANT, (Object)0);
        this.func_184212_Q().func_187214_a(EMOTIONAL_STATE, (Object)0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        if (!worldIn.func_201670_d()) {
            this.func_184212_Q().func_187227_b(VARIANT, (Object)this.field_70146_Z.nextInt(HUMAN_TEXTURES.length));
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233827_j_, 10.0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("texture", ((Integer)this.func_184212_Q().func_187225_a(VARIANT)).intValue());
        compound.func_74768_a("emotional_state", ((Integer)this.func_184212_Q().func_187225_a(EMOTIONAL_STATE)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(VARIANT, (Object)compound.func_74762_e("texture"));
        this.func_184212_Q().func_187227_b(EMOTIONAL_STATE, (Object)compound.func_74762_e("emotional_state"));
    }

    public HumanoidEmotionalState getEmotionalState() {
        return HumanoidEmotionalState.values()[(Integer)this.func_184212_Q().func_187225_a(EMOTIONAL_STATE)];
    }

    public void setEmotionalState(HumanoidEmotionalState state) {
        this.func_184212_Q().func_187227_b(EMOTIONAL_STATE, (Object)state.ordinal());
    }
}

