/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.misc.outfits;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public abstract class Outfit {
    private final Predicate<LivingEntity> shouldBeWearing;
    private final EnumMap<EquipmentSlotType, Item> slotMap = new EnumMap(EquipmentSlotType.class);

    public Outfit(Predicate<LivingEntity> shouldBeWearing) {
        this.shouldBeWearing = shouldBeWearing;
        this.registerItems();
    }

    public abstract void registerItems();

    public void addItem(EquipmentSlotType slot, Item item) {
        this.slotMap.put(slot, item);
    }

    public void tickServer(LivingEntity entity) {
        if (this.shouldBeWearing.test(entity)) {
            this.equip(entity);
        } else {
            this.unequip(entity);
        }
    }

    public void equip(LivingEntity entity) {
        for (Map.Entry<EquipmentSlotType, Item> entry : this.slotMap.entrySet()) {
            if (entity.func_184582_a(entry.getKey()).func_77973_b() == entry.getValue()) continue;
            entity.func_184201_a(entry.getKey(), new ItemStack((IItemProvider)entry.getValue()));
        }
    }

    public void unequip(LivingEntity entity) {
        for (Map.Entry<EquipmentSlotType, Item> slot : this.slotMap.entrySet()) {
            if (entity.func_184582_a(slot.getKey()).func_77973_b() != slot.getValue()) continue;
            entity.func_184201_a(slot.getKey(), ItemStack.field_190927_a);
        }
    }
}

