/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.humanoid;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.tardis.mod.entity.IPlayerTameable;
import net.tardis.mod.entity.humanoid.AbstractHumanoidEntity;
import net.tardis.mod.misc.ObjectWrapper;
import net.tardis.mod.missions.misc.Dialog;

public class TameableHumanoidEntity
extends AbstractHumanoidEntity
implements IPlayerTameable {
    public static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(TameableHumanoidEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(TameableHumanoidEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected PlayerEntity ownerPlayer;

    public TameableHumanoidEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, Optional.empty());
        this.func_184212_Q().func_187214_a(SITTING, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("owner_id")) {
            this.field_70180_af.func_187227_b(OWNER, Optional.of(compound.func_186857_a("owner_id")));
        }
        this.setSitting(compound.func_74767_n("is_sitting"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ((Optional)this.func_184212_Q().func_187225_a(OWNER)).ifPresent(owner -> compound.func_186854_a("owner_id", owner));
        compound.func_74757_a("is_sitting", this.isSitting());
    }

    @Override
    public Dialog getCurrentDialog(PlayerEntity player) {
        return null;
    }

    @Override
    public boolean isTamed() {
        ObjectWrapper<Boolean> tamed = new ObjectWrapper<Boolean>(false);
        ((Optional)this.field_70180_af.func_187225_a(OWNER)).ifPresent(owner -> tamed.setValue(true));
        return tamed.getValue();
    }

    @Override
    public UUID getOwner() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER)).orElse(null);
    }

    @Override
    public void setOwner(UUID owner) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(owner));
    }

    public PlayerEntity getOwnerEntity() {
        UUID ownerId = this.getOwner();
        if (ownerId == null) {
            return null;
        }
        if (this.ownerPlayer != null && this.ownerPlayer.func_70089_S()) {
            return this.ownerPlayer;
        }
        this.ownerPlayer = this.field_70170_p.func_217371_b(ownerId);
        return this.ownerPlayer;
    }

    @Override
    public ResourceLocation getSkin() {
        return new ResourceLocation("textures/entity/steve.png");
    }

    @Override
    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    @Override
    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }
}

