/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.humanoid;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.ai.humanoids.CompanionFollowGoal;
import net.tardis.mod.entity.ai.humanoids.HelpFlyTARDISGoal;
import net.tardis.mod.entity.ai.humanoids.SitInChairGoal;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.humanoid.TameableHumanoidEntity;
import net.tardis.mod.entity.misc.outfits.SpaceSuitOutfit;
import net.tardis.mod.enums.EnumCompanionAction;
import net.tardis.mod.missions.misc.Dialog;
import net.tardis.mod.missions.misc.DialogOption;
import net.tardis.mod.network.Network;
import net.tardis.mod.network.packets.CompanionActionMessage;

public class CompanionEntity
extends TameableHumanoidEntity {
    private SpaceSuitOutfit space = new SpaceSuitOutfit();

    public CompanionEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public CompanionEntity(World worldIn) {
        this((EntityType<? extends CreatureEntity>)((EntityType)TEntities.COMPANION.get()), worldIn);
    }

    @Override
    public Dialog getCurrentDialog(PlayerEntity player) {
        Dialog root = new Dialog(this.getCompanionDialogKey("hello"));
        if (player.func_110124_au().equals(this.getOwner())) {
            DialogOption followType = new DialogOption(null, !this.isSitting() ? this.getCompanionDialogOptionKey("wait") : this.getCompanionDialogOptionKey("follow"));
            followType.setOptionAction((companion, player1) -> {
                CompanionEntity comp = (CompanionEntity)companion;
                Network.sendToServer(new CompanionActionMessage(comp.func_110124_au(), EnumCompanionAction.SITTING));
            });
            DialogOption learnConsole = new DialogOption(null, this.getCompanionDialogOptionKey("fly_tardis"));
            learnConsole.setOptionAction((companion, player2) -> {
                CompanionEntity comp = (CompanionEntity)companion;
                Network.sendToServer(new CompanionActionMessage(comp.func_110124_au(), EnumCompanionAction.FLY_TARDIS));
            });
            root.addDialogOption(learnConsole);
            root.addDialogOption(followType);
        }
        return root;
    }

    @Override
    public ResourceLocation getSkin() {
        return new ResourceLocation("textures/entity/steve.png");
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new HelpFlyTARDISGoal(this, 0.4, 16));
        this.field_70714_bg.func_75776_a(3, (Goal)new CompanionFollowGoal(this, 0.4));
        this.field_70714_bg.func_75776_a(5, (Goal)new AvoidEntityGoal((CreatureEntity)this, DalekEntity.class, 6.0f, 0.4, 0.4));
        this.field_70714_bg.func_75776_a(6, (Goal)new SitInChairGoal(this, 0.23, 6));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.23));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233827_j_, 20.0).func_233815_a_(Attributes.field_233821_d_, 1.0);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public String getCompanionDialogKey(String key) {
        return "companion.tardis.dialog." + key;
    }

    public String getCompanionDialogOptionKey(String key) {
        return "companion.tardis.dialog_option." + key;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            this.setOwner(player.func_110124_au());
        }
        return super.func_184199_a(player, vec, hand);
    }

    public void func_184642_a(EquipmentSlotType slotIn, float chance) {
        if (slotIn.func_188453_a() == EquipmentSlotType.Group.HAND) {
            chance = 0.0f;
        }
        super.func_184642_a(slotIn, chance);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.equipEnviromentalArmor();
    }

    public void equipEnviromentalArmor() {
        if (!this.field_70170_p.field_72995_K) {
            this.space.tickServer((LivingEntity)this);
        }
    }
}

