/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.hostile.dalek.weapons;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.projectiles.LaserEntity;
import net.tardis.mod.misc.AbstractWeapon;

public class DalekWeapon
extends AbstractWeapon<DalekEntity> {
    private DalekEntity dalek;

    public DalekWeapon(DalekEntity dalek) {
        this.dalek = dalek;
    }

    @Override
    public void onHit(LaserEntity laser, RayTraceResult result) {
        if (!this.dalek.field_70170_p.func_201670_d() && result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult entityHitResult = (EntityRayTraceResult)result;
            Entity hitEntity = entityHitResult.func_216348_a();
            float extraAttackDamage = 0.0f;
            float knockbackAmount = (float)this.dalek.func_233637_b_(Attributes.field_233824_g_);
            if (hitEntity instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)hitEntity;
                if (this.dalek.func_184614_ca() != null) {
                    extraAttackDamage += EnchantmentHelper.func_152377_a((ItemStack)this.dalek.func_184614_ca(), (CreatureAttribute)((LivingEntity)hitEntity).func_70668_bt());
                    knockbackAmount += (float)EnchantmentHelper.func_77501_a((LivingEntity)this.dalek);
                    int setOnFireTime = EnchantmentHelper.func_90036_a((LivingEntity)this.dalek);
                    if (setOnFireTime > 0) {
                        hitEntity.func_70015_d(setOnFireTime * 4);
                    }
                    this.dalek.func_70097_a(this.dalek.getDalekType().getDamageSource((LivingEntity)this.dalek), extraAttackDamage);
                } else {
                    if (knockbackAmount > 0.0f) {
                        livingTarget.func_233627_a_(knockbackAmount * 0.5f, (double)MathHelper.func_76126_a((float)(this.dalek.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.dalek.field_70177_z * ((float)Math.PI / 180)))));
                        this.dalek.func_213317_d(this.dalek.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                    }
                    if (livingTarget instanceof PlayerEntity) {
                        PlayerEntity playerentity = (PlayerEntity)livingTarget;
                        this.dalek.maybeDisableShield(playerentity, this.dalek.func_184614_ca(), playerentity.func_184587_cr() ? playerentity.func_184607_cu() : ItemStack.field_190927_a);
                    }
                }
            }
        }
    }

    @Override
    public float damage() {
        return (float)this.dalek.func_110148_a(Attributes.field_233823_f_).func_111125_b();
    }

    @Override
    public boolean useWeapon(DalekEntity dalek) {
        if (!dalek.field_70170_p.field_72995_K) {
            LaserEntity laser = new LaserEntity((EntityType<? extends ThrowableEntity>)((EntityType)TEntities.LASER.get()), (LivingEntity)dalek, dalek.field_70170_p, this.damage(), dalek.getDalekType().getDamageSource((LivingEntity)dalek));
            laser.func_234612_a_((Entity)laser, dalek.field_70125_A, dalek.field_70759_as, 0.0f, 2.0f, 0.1f);
            laser.setColor(dalek.getDalekType().getLaserColour());
            LivingEntity targetEntity = dalek.func_70638_az();
            if (targetEntity != null) {
                double distToTarget = dalek.func_70092_e(targetEntity.func_226277_ct_(), targetEntity.func_226278_cu_(), targetEntity.func_226281_cx_()) / 35.0;
                laser.setRayLength((float)distToTarget);
            } else {
                laser.setRayLength(1.0f);
            }
            laser.setWeaponType(this);
            dalek.field_70170_p.func_217376_c((Entity)laser);
            return true;
        }
        return false;
    }

    @Override
    public void onHitEntityPre(LaserEntity laserEntity, Entity result) {
        super.onHitEntityPre(laserEntity, result);
        if (!this.dalek.field_70170_p.field_72995_K && result instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)result;
            ItemStack heldItem = player.func_184592_cb().func_77973_b() instanceof ShieldItem ? player.func_184592_cb() : player.func_184614_ca();
            this.dalek.maybeDisableShield(player, heldItem);
        }
    }
}

