/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.hostile.dalek.types;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.hostile.dalek.types.DalekType;
import net.tardis.mod.entity.hostile.dalek.weapons.DalekSpecialWeapon;
import net.tardis.mod.sounds.TSounds;

public class SpecialType
extends DalekType {
    private SoundEvent[] specialFireSounds;
    private SoundEvent[] specialAmbientSounds;

    @Override
    protected void setupWeapons(DalekEntity entity) {
        this.setWeapon(new DalekSpecialWeapon(entity));
    }

    @Override
    public double getMovementSpeed() {
        return 0.5;
    }

    @Override
    public double getAttacksPerSecond() {
        return 0.6;
    }

    @Override
    public double getAttackDamage() {
        return 12.0;
    }

    @Override
    public double getMaxHealth() {
        return 120.0;
    }

    @Override
    public Vector3d getLaserColour() {
        return new Vector3d(0.5, 0.5, 0.0);
    }

    @Override
    public DamageSource getDamageSource(LivingEntity entity) {
        return TDamageSources.causeTardisMobDamage("dalek_spec", entity).func_94540_d();
    }

    @Override
    public SoundEvent getAmbientSound(DalekEntity dalekEntity) {
        if (this.specialAmbientSounds == null) {
            this.specialAmbientSounds = new SoundEvent[]{(SoundEvent)TSounds.DALEK_SW_AIM.get(), (SoundEvent)TSounds.DALEK_HOVER.get()};
        }
        return this.specialAmbientSounds[(int)(System.currentTimeMillis() % (long)this.specialAmbientSounds.length)];
    }

    @Override
    public SoundEvent getFireSound(DalekEntity dalekEntity) {
        if (this.specialFireSounds == null) {
            this.specialFireSounds = new SoundEvent[]{(SoundEvent)TSounds.DALEK_SW_FIRE.get(), (SoundEvent)TSounds.DALEK_EXTERMINATE.get()};
        }
        return this.specialFireSounds[(int)(System.currentTimeMillis() % (long)this.specialFireSounds.length)];
    }
}

