/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.hostile.dalek.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRaidGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.ai.FlyingMovementGoal;
import net.tardis.mod.entity.ai.TardisMoveTowardsRaidGoal;
import net.tardis.mod.entity.ai.TardisRaiderOpenGoal;
import net.tardis.mod.entity.ai.dalek.DalekAttackGoal;
import net.tardis.mod.entity.ai.dalek.DalekDestroyBlockGoal;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.hostile.dalek.weapons.DalekWeapon;
import net.tardis.mod.items.TItems;
import net.tardis.mod.items.misc.BlockGriefingLaserWeapon;
import net.tardis.mod.misc.AbstractWeapon;
import net.tardis.mod.sounds.TSounds;

public class DalekType
extends ForgeRegistryEntry<DalekType> {
    private SoundEvent[] ambientSounds = null;
    private SoundEvent[] deathSounds = null;
    private SoundEvent[] fireSounds = null;
    private List<String> textureVariants = new ArrayList<String>();
    private AbstractWeapon<DalekEntity> dalekWeapon = null;
    private boolean canFly = true;
    private double maxHealth = 80.0;
    private double followRange = 60.0;
    private double movementSpeed = 0.55;
    private double attackDamage = 8.0;
    private double attackKnockback = 0.5;
    private double attacksPerSecond = 1.0;
    private double flyingSpeed = 0.8;
    private double knockbackResistance = 0.1;
    private boolean removeOldGoals = false;
    private boolean removeTargetGoals = false;
    private Vector3d laserColour = new Vector3d(0.0, 0.0, 1.0);
    private Item spawnItem = (Item)TItems.SPAWN_EGG_DALEK_DEFAULT.get();

    public DalekType addTextureVariant(String textureVariantFileName) {
        this.textureVariants.add(textureVariantFileName);
        return this;
    }

    public DalekType addTextureVariant(List<String> textureVariantFileNames) {
        this.textureVariants.addAll(textureVariantFileNames);
        return this;
    }

    public DalekType setupDalek(DalekEntity dalekEntity) {
        HashSet<PrioritizedGoal> goalsToRemove;
        if (this.removeOldGoals) {
            goalsToRemove = new HashSet<PrioritizedGoal>();
            for (PrioritizedGoal goal : dalekEntity.field_70714_bg.field_220892_d) {
                goalsToRemove.add(goal);
            }
            for (PrioritizedGoal pGoal : goalsToRemove) {
                dalekEntity.field_70714_bg.func_85156_a((Goal)pGoal);
            }
        }
        if (this.removeTargetGoals) {
            goalsToRemove = new HashSet();
            for (PrioritizedGoal goal : dalekEntity.field_70715_bh.field_220892_d) {
                dalekEntity.field_70715_bh.func_85156_a((Goal)goal);
            }
            for (PrioritizedGoal pGoal : goalsToRemove) {
                dalekEntity.field_70715_bh.func_85156_a((Goal)pGoal);
            }
        }
        this.addGoals(dalekEntity);
        this.modifyExistingAttributes(dalekEntity);
        this.setupWeapons(dalekEntity);
        return this;
    }

    protected void addGoals(DalekEntity dalekEntity) {
        HashSet<PrioritizedGoal> goalsToRemove = new HashSet<PrioritizedGoal>();
        for (PrioritizedGoal goal : dalekEntity.field_70714_bg.field_220892_d) {
            if (!(goal.func_220772_j() instanceof PatrollerEntity.PatrolGoal) && !(goal.func_220772_j() instanceof AbstractRaiderEntity.InvadeHomeGoal) && !(goal.func_220772_j() instanceof MoveTowardsRaidGoal) || goal.func_220773_g()) continue;
            goalsToRemove.add(goal);
        }
        for (PrioritizedGoal pGoal : goalsToRemove) {
            dalekEntity.field_70714_bg.field_220892_d.remove(pGoal);
        }
        dalekEntity.field_70714_bg.func_75776_a(1, (Goal)new DalekAttackGoal(dalekEntity, LivingEntity.class, true, false, 20.0));
        dalekEntity.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)dalekEntity, new Class[0]).func_220794_a(new Class[]{DalekEntity.class}));
        dalekEntity.field_70714_bg.func_75776_a(3, (Goal)new TardisMoveTowardsRaidGoal(dalekEntity, this.getMovementSpeed() * 1.1));
        if (this.canFly()) {
            dalekEntity.field_70714_bg.func_75776_a(8, (Goal)new FlyingMovementGoal((CreatureEntity)dalekEntity));
        }
        dalekEntity.field_70714_bg.func_75776_a(4, (Goal)new PatrollerEntity.PatrolGoal((PatrollerEntity)dalekEntity, this.getMovementSpeed(), this.getMovementSpeed()));
        dalekEntity.field_70714_bg.func_75776_a(5, (Goal)new AbstractRaiderEntity.InvadeHomeGoal((AbstractRaiderEntity)dalekEntity, this.getMovementSpeed() * 1.1, 20));
        dalekEntity.field_70714_bg.func_75776_a(6, (Goal)new OpenDoorGoal((MobEntity)dalekEntity, false));
        dalekEntity.field_70714_bg.func_75776_a(7, (Goal)new TardisRaiderOpenGoal(dalekEntity));
        BlockGriefingLaserWeapon<DalekEntity> doorBreakingWeapon = new BlockGriefingLaserWeapon<DalekEntity>(dalekEntity, this.getDamageSource((LivingEntity)dalekEntity), 0.0f, this.laserColour, 1.0f, this.getFireSound(dalekEntity));
        doorBreakingWeapon.setBlockToDestroy(DoorBlock.class);
        dalekEntity.field_70714_bg.func_75776_a(7, (Goal)new DalekDestroyBlockGoal(DoorBlock.class, dalekEntity, doorBreakingWeapon, 10.0, flag -> flag == Difficulty.HARD));
        dalekEntity.field_70714_bg.func_75776_a(9, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)dalekEntity, this.getMovementSpeed()));
        dalekEntity.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)dalekEntity, PlayerEntity.class, 8.0f));
        dalekEntity.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)dalekEntity));
    }

    private void modifyExistingAttributes(DalekEntity dalekEntity) {
        dalekEntity.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getMaxHealth());
        dalekEntity.func_110148_a(Attributes.field_233819_b_).func_111128_a(this.getFollowRange());
        dalekEntity.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.getMovementSpeed());
        dalekEntity.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.getAttackDamage());
        dalekEntity.func_110148_a(Attributes.field_233824_g_).func_111128_a(this.getAttackKnockback());
        dalekEntity.func_110148_a(Attributes.field_233825_h_).func_111128_a(this.getAttacksPerSecond());
        dalekEntity.func_110148_a(Attributes.field_233822_e_).func_111128_a(this.getFlyingSpeed());
        dalekEntity.func_110148_a(Attributes.field_233820_c_).func_111128_a(this.getKnockbackResistance());
    }

    protected void setupWeapons(DalekEntity dalek) {
        this.setWeapon(new DalekWeapon(dalek));
    }

    public void tickSpecial(DalekEntity dalekEntity) {
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public double getFollowRange() {
        return this.followRange;
    }

    public double getMovementSpeed() {
        return this.movementSpeed;
    }

    public double getAttackDamage() {
        return this.attackDamage;
    }

    public double getAttackKnockback() {
        return this.attackKnockback;
    }

    public double getAttacksPerSecond() {
        return this.attacksPerSecond;
    }

    public double getFlyingSpeed() {
        return this.flyingSpeed;
    }

    public double getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public DamageSource getDamageSource(LivingEntity entity) {
        return TDamageSources.causeTardisMobDamage("dalek", entity);
    }

    public Vector3d getLaserColour() {
        return this.laserColour;
    }

    public boolean canFly() {
        return this.canFly;
    }

    public DalekType setCanFly(boolean canFly) {
        this.canFly = canFly;
        return this;
    }

    public SoundEvent getAmbientSound(DalekEntity dalekEntity) {
        if (this.ambientSounds == null) {
            this.ambientSounds = new SoundEvent[]{(SoundEvent)TSounds.DALEK_HOVER.get(), (SoundEvent)TSounds.DALEK_ARM.get()};
        }
        return this.ambientSounds[(int)(System.currentTimeMillis() % (long)this.ambientSounds.length)];
    }

    public SoundEvent getFireSound(DalekEntity dalekEntity) {
        if (this.fireSounds == null) {
            this.fireSounds = new SoundEvent[]{(SoundEvent)TSounds.DALEK_FIRE.get(), (SoundEvent)TSounds.DALEK_FIRE_EXTENDED.get(), (SoundEvent)TSounds.DALEK_EXTERMINATE.get()};
        }
        return this.fireSounds[(int)(System.currentTimeMillis() % (long)this.fireSounds.length)];
    }

    public SoundEvent getDeathSound(DalekEntity dalekEntity) {
        if (this.deathSounds == null) {
            this.deathSounds = new SoundEvent[]{(SoundEvent)TSounds.DALEK_DEATH.get()};
        }
        return this.deathSounds[(int)(System.currentTimeMillis() % (long)this.deathSounds.length)];
    }

    public String getRandomTexture(DalekEntity dalekEntity) {
        return this.textureVariants.get(dalekEntity.field_70170_p.field_73012_v.nextInt(this.textureVariants.size()));
    }

    public Predicate<LivingEntity> getAttackPredicate() {
        return livingEntity -> {
            boolean predicate = livingEntity.func_200600_R() != TEntities.DALEK.get() && !(livingEntity instanceof AbstractRaiderEntity) && !(livingEntity instanceof ArmorStandEntity) && livingEntity.func_200600_R() != TEntities.HOLO_PILOT.get();
            boolean dalekTargetAll = (Boolean)TConfig.SERVER.dalekTargetAllLiving.get();
            if (!dalekTargetAll) {
                if (((Boolean)TConfig.SERVER.dalekTargetHostileOnly.get()).booleanValue()) {
                    predicate = livingEntity instanceof CreatureEntity ? predicate && livingEntity instanceof MonsterEntity : predicate && livingEntity instanceof MobEntity;
                } else {
                    if (!((Boolean)TConfig.SERVER.dalekTargetAnimals.get()).booleanValue()) {
                        boolean bl = predicate = predicate && !(livingEntity instanceof AnimalEntity);
                    }
                    if (!((Boolean)TConfig.SERVER.dalekTargetVillagers.get()).booleanValue()) {
                        boolean bl = predicate = predicate && !(livingEntity instanceof AbstractVillagerEntity);
                    }
                    if (!((Boolean)TConfig.SERVER.dalekTargetPlayers.get()).booleanValue()) {
                        predicate = predicate && !(livingEntity instanceof PlayerEntity);
                    }
                }
                return predicate;
            }
            return predicate;
        };
    }

    public DalekType setWeapon(AbstractWeapon<DalekEntity> weapon) {
        this.dalekWeapon = weapon;
        return this;
    }

    public AbstractWeapon<DalekEntity> getWeapon() {
        return this.dalekWeapon;
    }

    public Item getSpawnItem() {
        return this.spawnItem;
    }

    public DalekType setSpawnItem(Item spawnItem) {
        this.spawnItem = spawnItem;
        return this;
    }

    public boolean removeOldGoals() {
        return this.removeOldGoals;
    }

    public void setRemoveOldGoals(boolean removeOldGoals) {
        this.removeOldGoals = removeOldGoals;
    }

    public boolean removeTargetGoals() {
        return this.removeTargetGoals;
    }

    public void setRemoveTargetGoals(boolean removeTargetGoals) {
        this.removeTargetGoals = removeTargetGoals;
    }
}

