/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.hostile.dalek;

import java.util.function.Predicate;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.tardis.api.space.entities.ISpaceImmuneEntity;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.entity.ai.TDataSerializers;
import net.tardis.mod.entity.hostile.dalek.types.DalekType;
import net.tardis.mod.registries.DalekTypeRegistry;

public class DalekEntity
extends AbstractRaiderEntity
implements ISpaceImmuneEntity {
    public static final DataParameter<ResourceLocation> DALEK_TYPE = EntityDataManager.func_187226_a(DalekEntity.class, TDataSerializers.RESOURCE_LOCATION);
    public static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(DalekEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final Predicate<LivingEntity> DEFAULT_PREDICATE = predicate -> !(predicate instanceof AbstractRaiderEntity) && predicate.func_200600_R() != TEntities.DALEK.get();
    public static final EntityPredicate DEFAULT_ENEMY_CONDITION = new EntityPredicate().func_221012_a(DEFAULT_PREDICATE).func_221013_a(20.0);

    public DalekEntity(EntityType<? extends AbstractRaiderEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public DalekEntity(World worldIn) {
        super((EntityType)TEntities.DALEK.get(), worldIn);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233824_g_, 0.5).func_233815_a_(Attributes.field_233825_h_, 0.1).func_233815_a_(Attributes.field_233822_e_, 0.4).func_233815_a_(Attributes.field_233820_c_, 0.1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        DalekType dalek = DalekTypeRegistry.getRandom(this.field_70146_Z);
        this.func_184212_Q().func_187214_a(DALEK_TYPE, (Object)dalek.getRegistryName());
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)this.getDalekType().getRandomTexture(this));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.getDalekType().setupDalek(this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        GroundPathNavigator navigator = new GroundPathNavigator((MobEntity)this, worldIn);
        navigator.func_189566_q().func_186317_a(true);
        navigator.func_179688_b(true);
        navigator.func_212239_d(true);
        navigator.func_179685_e(false);
        return navigator;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        ItemStack headStack = this.func_184582_a(EquipmentSlotType.HEAD);
        if (!headStack.func_190926_b() && !ItemStack.func_77989_b((ItemStack)headStack, (ItemStack)Raid.func_221312_H())) {
            super.func_213333_a(source, looting, recentlyHitIn);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getDalekType() != null) {
            this.getDalekType().tickSpecial(this);
        }
        if (!this.field_70122_E) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218420_D, this.func_226277_ct_(), this.func_226278_cu_() - 0.25, this.func_226281_cx_(), 0.0, -0.25, 0.0);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("dalek_type")) {
            this.func_184212_Q().func_187227_b(DALEK_TYPE, (Object)new ResourceLocation(compound.func_74779_i("dalek_type")));
        }
        if (compound.func_74764_b("texture")) {
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)compound.func_74779_i("texture"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("dalek_type", ((ResourceLocation)this.func_184212_Q().func_187225_a(DALEK_TYPE)).toString());
        compound.func_74778_a("texture", (String)this.func_184212_Q().func_187225_a(TEXTURE));
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184639_G() {
        return this.getDalekType().getAmbientSound(this);
    }

    protected SoundEvent func_184615_bR() {
        return this.getDalekType().getDeathSound(this);
    }

    public DalekType getDalekType() {
        return (DalekType)DalekTypeRegistry.DALEK_TYPE_REGISTRY.get().getValue((ResourceLocation)this.func_184212_Q().func_187225_a(DALEK_TYPE));
    }

    public void setDalekType(DalekType dalekType) {
        ResourceLocation oldType = (ResourceLocation)this.func_184212_Q().func_187225_a(DALEK_TYPE);
        boolean hasChanged = !oldType.equals((Object)dalekType.getRegistryName());
        this.func_184212_Q().func_187227_b(DALEK_TYPE, (Object)dalekType.getRegistryName());
        if (hasChanged) {
            this.func_184212_Q().func_187227_b(TEXTURE, (Object)dalekType.getRandomTexture(this));
            this.getDalekType().setupDalek(this);
        }
    }

    public String getTexture() {
        return (String)this.func_184212_Q().func_187225_a(TEXTURE);
    }

    public double getTargetDistance() {
        return this.func_233637_b_(Attributes.field_233819_b_);
    }

    public AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source.func_76346_g() != null ? (source.func_76352_a() ? (((Boolean)TConfig.SERVER.dalekImmuneToProjectiles.get()).booleanValue() ? true : this.field_70170_p.func_175659_aa() == Difficulty.HARD) : source.func_76346_g().func_200600_R() == this.getDalekType().getDamageSource((LivingEntity)this).func_76346_g().func_200600_R()) : source != TDamageSources.TARDIS_SQUASH && source != DamageSource.field_76380_i;
    }

    public float func_70599_aP() {
        return this.getDalekType() == DalekTypeRegistry.RUSTY.get() ? 0.2f : 0.8f;
    }

    public float func_70647_i() {
        return this.getDalekType() == DalekTypeRegistry.RUSTY.get() ? 0.1f : 1.0f;
    }

    public void func_213660_a(int wave, boolean p_213660_2_) {
        Raid raid = this.func_213663_ek();
        int i = 2;
        if (wave > raid.func_221306_a(Difficulty.NORMAL)) {
            i = 4;
            this.func_195064_c(new EffectInstance(Effects.field_76429_m, 99999, 3));
        }
        this.func_195064_c(new EffectInstance(Effects.field_76428_l, 99999, i));
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219687_it;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)this.getDalekType().getSpawnItem());
    }

    public void maybeDisableShield(PlayerEntity player, ItemStack dalekHeldItem, ItemStack playerHeldItem) {
        if (!dalekHeldItem.func_190926_b() && !playerHeldItem.func_190926_b() && dalekHeldItem.func_77973_b() instanceof AxeItem && playerHeldItem.func_77973_b() instanceof ShieldItem) {
            float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                ShieldItem shield = (ShieldItem)playerHeldItem.func_77973_b();
                player.func_184811_cZ().func_185145_a((Item)shield, 100);
                player.func_184602_cy();
                this.field_70170_p.func_72960_a((Entity)player, (byte)30);
            }
        }
    }

    public void maybeDisableShield(PlayerEntity player, ItemStack playerHeldItem) {
        if (!playerHeldItem.func_190926_b() && playerHeldItem.func_77973_b() instanceof ShieldItem) {
            double chance = (Double)TConfig.SERVER.dalekShieldDisableChance.get();
            if (this.field_70146_Z.nextDouble() <= chance) {
                ShieldItem shield = (ShieldItem)playerHeldItem.func_77973_b();
                player.func_184811_cZ().func_185145_a((Item)shield, 100);
                player.func_184602_cy();
                this.field_70170_p.func_72960_a((Entity)player, (byte)30);
            }
        }
    }

    @Override
    public boolean shouldTakeSpaceDamage() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }
}

