/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.ai.dalek;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.misc.AbstractWeapon;

public class DalekAttackGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    protected final Class<LivingEntity> field_75307_b;
    private final DalekEntity dalek;
    private int tickCounter;
    private double maxAttackDistance;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    protected final boolean field_75297_f;
    protected final boolean field_75303_a;

    public DalekAttackGoal(DalekEntity dalek, Class<LivingEntity> targetClass, boolean shouldCheckSight, boolean nearbyOnly, double maxAttackDistance) {
        super((MobEntity)dalek, targetClass, shouldCheckSight, nearbyOnly);
        this.field_75307_b = targetClass;
        this.field_75297_f = shouldCheckSight;
        this.field_75303_a = nearbyOnly;
        this.dalek = dalek;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
        this.maxAttackDistance = maxAttackDistance;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.tickCounter = 0;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.seeTime = 0;
        this.tickCounter = 0;
        this.dalek.func_70624_b(null);
        this.field_75309_a = null;
    }

    public void func_75246_d() {
        if (!this.dalek.field_70170_p.field_72995_K && this.field_75309_a != null) {
            boolean targetSeen;
            this.dalek.func_70624_b(this.field_75309_a);
            double distToTarget = this.dalek.func_70092_e(this.field_75309_a.func_226277_ct_(), this.field_75309_a.func_226278_cu_(), this.field_75309_a.func_226281_cx_());
            boolean canSeeTarget = this.dalek.func_70635_at().func_75522_a((Entity)this.field_75309_a);
            boolean bl = targetSeen = this.seeTime > 0;
            if (canSeeTarget != targetSeen) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            if (!(distToTarget > this.maxAttackDistance) && this.seeTime >= 20) {
                this.dalek.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.dalek.func_70661_as().func_75497_a((Entity)this.field_75309_a, this.dalek.getDalekType().getMovementSpeed());
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.dalek.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.dalek.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distToTarget > this.maxAttackDistance * 0.75) {
                    this.strafingBackwards = false;
                } else if (distToTarget < this.maxAttackDistance * 0.25) {
                    this.strafingBackwards = true;
                }
                this.dalek.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.dalek.func_70625_a((Entity)this.field_75309_a, 30.0f, 30.0f);
            } else {
                this.dalek.func_70671_ap().func_75651_a((Entity)this.field_75309_a, 30.0f, 30.0f);
            }
            if (canSeeTarget) {
                ++this.tickCounter;
                if ((double)this.tickCounter >= this.getTicksUntilAttack()) {
                    this.dalek.func_70625_a((Entity)this.field_75309_a, 30.0f, 30.0f);
                    AbstractWeapon<DalekEntity> weapon = this.dalek.getDalekType().getWeapon();
                    if (weapon != null && weapon.useWeapon(this.dalek)) {
                        this.dalek.func_184185_a(this.dalek.getDalekType().getFireSound(this.dalek), this.dalek.func_70599_aP(), this.dalek.func_70647_i());
                        if (this.field_75309_a instanceof MobEntity) {
                            MobEntity mob = (MobEntity)this.field_75309_a;
                            mob.func_213395_q(true);
                        }
                    }
                    this.tickCounter = 0;
                }
            }
        }
    }

    public double getTicksUntilAttack() {
        double attacksPerSecond = this.dalek.getDalekType().getAttacksPerSecond();
        double ticksTillAttack = 1.0 / attacksPerSecond * 20.0;
        return ticksTillAttack;
    }

    protected void func_220778_g() {
        this.field_75309_a = !(this.field_75309_a instanceof PlayerEntity) ? this.dalek.field_70170_p.func_225318_b(this.field_75307_b, DalekEntity.DEFAULT_ENEMY_CONDITION.func_221012_a(this.dalek.getDalekType().getAttackPredicate()), (LivingEntity)this.dalek, this.dalek.func_226277_ct_(), this.dalek.func_226280_cw_(), this.dalek.func_226281_cx_(), this.dalek.getTargetableArea(this.dalek.getTargetDistance())) : this.dalek.field_70170_p.func_217362_a((Entity)this.field_75299_d, this.dalek.getTargetDistance());
    }
}

