/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity.ai;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.tardis.mod.items.misc.BlockGriefingLaserWeapon;
import net.tardis.mod.misc.AbstractWeapon;

public class WeaponDestroyBlockGoal<E extends LivingEntity>
extends Goal {
    protected AbstractWeapon<E> weapon;
    private final Predicate<Difficulty> difficultyPredicate;
    protected final Class<? extends Block> blockToDestroy;
    protected final E entity;
    protected final double distanceToBlock;
    protected BlockPos blockPos = BlockPos.field_177992_a;
    protected int timeout = 20;

    public WeaponDestroyBlockGoal(Class<? extends Block> blockToDestroy, E weaponHolder, AbstractWeapon<E> weapon, double distanceToBlock, Predicate<Difficulty> difficultyPredicate) {
        this.blockToDestroy = blockToDestroy;
        this.entity = weaponHolder;
        this.weapon = weapon;
        this.distanceToBlock = distanceToBlock;
        this.difficultyPredicate = difficultyPredicate;
    }

    public WeaponDestroyBlockGoal(Class<? extends Block> blockToDestroy, E weaponHolder, double distanceToBlock, Predicate<Difficulty> difficultyPredicate) {
        this(blockToDestroy, weaponHolder, new BlockGriefingLaserWeapon<E>(weaponHolder), distanceToBlock, difficultyPredicate);
    }

    public boolean func_75250_a() {
        if (!((LivingEntity)this.entity).field_70170_p.func_201670_d() && this.blockPos == BlockPos.field_177992_a && this.timeout > 0) {
            return this.canBreakOnDifficulty(((LivingEntity)this.entity).field_70170_p.func_175659_aa());
        }
        return false;
    }

    public boolean func_75253_b() {
        return !((LivingEntity)this.entity).field_70170_p.func_201670_d() && this.blockPos != BlockPos.field_177992_a && this.doesBlockStillExist(((LivingEntity)this.entity).field_70170_p, this.blockPos) && this.timeout > 0;
    }

    public void func_75249_e() {
        super.func_75249_e();
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.blockPos = BlockPos.field_177992_a;
        this.timeout = 20;
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (!((LivingEntity)this.entity).field_70170_p.func_201670_d()) {
            BlockRayTraceResult target;
            if (this.timeout > 0) {
                --this.timeout;
            }
            if (((LivingEntity)this.entity).field_70170_p.func_82737_E() % 20L == 0L && (target = this.findTarget((LivingEntity)this.entity, this.distanceToBlock, 0.0f, false)) != null && target.func_216350_a() != null) {
                this.blockPos = target.func_216350_a();
                BlockState state = ((LivingEntity)this.entity).field_70170_p.func_180495_p(target.func_216350_a());
                if (this.matchesTargetBlock(state) && this.weapon != null && this.timeout > 0) {
                    this.weapon.useWeapon(this.entity);
                    this.func_75251_c();
                }
            }
        }
    }

    protected boolean matchesTargetBlock(BlockState state) {
        if (state != null) {
            return state.func_177230_c().getClass().equals(this.blockToDestroy);
        }
        return false;
    }

    private boolean canBreakOnDifficulty(Difficulty difficulty) {
        return this.difficultyPredicate.test(difficulty);
    }

    protected BlockRayTraceResult findTarget(LivingEntity dalek, double distanceToBlock, float partialTicks, boolean searchThroughFluids) {
        Vector3d eyeVec = dalek.func_174824_e(1.0f);
        Vector3d lookVec = dalek.func_70676_i(partialTicks);
        Vector3d searchVec = eyeVec.func_72441_c(lookVec.field_72450_a * distanceToBlock, lookVec.field_72448_b * distanceToBlock, lookVec.field_72449_c * distanceToBlock);
        return dalek.field_70170_p.func_217299_a(new RayTraceContext(eyeVec, searchVec, RayTraceContext.BlockMode.OUTLINE, searchThroughFluids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)dalek));
    }

    protected boolean doesBlockStillExist(World world, BlockPos pos) {
        return this.matchesTargetBlock(world.func_180495_p(pos));
    }

    public WeaponDestroyBlockGoal<E> setWeaponType(AbstractWeapon<E> doorBreakingWeapon) {
        this.weapon = doorBreakingWeapon;
        return this;
    }
}

