/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.cap.Capabilities;
import net.tardis.mod.config.TConfig;
import net.tardis.mod.damagesources.TDamageSources;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.exterior.AbstractExterior;
import net.tardis.mod.helper.LandingSystem;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;
import net.tardis.mod.registries.ExteriorRegistry;
import net.tardis.mod.tileentities.ConsoleTile;
import net.tardis.mod.tileentities.console.misc.AlarmType;
import net.tardis.mod.tileentities.console.misc.MonitorOverride;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class TardisEntity
extends Entity {
    public static final DataParameter<String> EXTERIOR = EntityDataManager.func_187226_a(TardisEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<CompoundNBT> EXTERIOR_DATA = EntityDataManager.func_187226_a(TardisEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private ConsoleTile console;
    private int sneakTicks = 0;
    private AbstractExterior exterior;
    private boolean hasLanded = false;
    private ExteriorTile tile;

    public TardisEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public TardisEntity(World worldIn) {
        this((EntityType)TEntities.TARDIS.get(), worldIn);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(EXTERIOR, (Object)((AbstractExterior)ExteriorRegistry.TRUNK.get()).getRegistryName().toString());
        this.func_184212_Q().func_187214_a(EXTERIOR_DATA, (Object)new CompoundNBT());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.func_184212_Q().func_187227_b(EXTERIOR, (Object)compound.func_74779_i("exterior"));
        if (compound.func_74764_b("exterior_data")) {
            CompoundNBT tag = compound.func_74775_l("exterior_data");
            this.field_70180_af.func_187227_b(EXTERIOR_DATA, (Object)tag);
            this.readExteriorFromData(tag);
        }
        if (!this.field_70170_p.field_72995_K && compound.func_74764_b("interior_dimension")) {
            TardisHelper.getConsole(this.field_70170_p.func_73046_m(), (World)this.field_70170_p.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("interior_dimension"))))).ifPresent(console -> {
                this.console = console;
            });
        }
    }

    public void readExteriorFromData(CompoundNBT tag) {
        TileEntityType type = (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation(tag.func_74779_i("id")));
        if (type != null) {
            this.tile = (ExteriorTile)type.func_200968_a();
            this.tile.func_226984_a_(this.field_70170_p, this.tile.func_174877_v());
            this.tile.deserializeNBT(tag);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("exterior", (String)this.func_184212_Q().func_187225_a(EXTERIOR));
        if (this.tile != null) {
            compound.func_218657_a("exterior_data", (INBT)this.tile.serializeNBT());
        }
        if (this.console != null) {
            compound.func_74778_a("interior_dimension", this.console.func_145831_w().func_234923_W_().func_240901_a_().toString());
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.func_189652_ae() && this.func_213322_ci().field_72448_b > -3.0) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.08, 0.0));
            this.field_70170_p.getCapability(Capabilities.SPACE_DIM_PROPERTIES).ifPresent(cap -> this.func_213317_d(cap.modMotion(this)));
        }
        if (this.func_189652_ae()) {
            float slippery = this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177977_b()).getSlipperiness((IWorldReader)this.field_70170_p, this.func_233580_cy_().func_177977_b(), (Entity)this);
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)slippery * 0.4));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getConsole() != null && this.field_70170_p.func_82737_E() % 20L == 0L) {
                this.console.setCurrentLocation((RegistryKey<World>)this.field_70170_p.func_234923_W_(), this.func_233580_cy_());
            }
            if (this.func_184188_bt().isEmpty()) {
                boolean hasWacked = false;
                for (Entity ent : this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ())) {
                    if (ent == this) continue;
                    float damageAmount = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 18.0f : 12.0f;
                    ent.func_70097_a(TDamageSources.TARDIS_SQUASH, damageAmount);
                }
                if (hasWacked) {
                    this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187767_eL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            }
            if (!LandingSystem.shouldTARDISFall(this.field_70170_p, this.func_226270_aj_())) {
                this.func_70106_y();
            }
            if (this.func_226278_cu_() <= 0.0) {
                this.onFallOutOfWorld();
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.hasLanded) {
            this.land();
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.field_70122_E) {
            this.sneakTicks = this.func_184187_bx().func_225608_bj_() ? ++this.sneakTicks : 0;
            if (this.sneakTicks > 30) {
                this.func_70106_y();
            }
        } else {
            this.sneakTicks = 0;
        }
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!this.field_70170_p.func_201670_d() && player.func_184600_cs() != null) {
            this.func_70106_y();
        }
        return super.func_184230_a(player, hand);
    }

    public void land() {
        if (!this.field_70170_p.field_72995_K && this.console != null && !this.hasLanded) {
            this.console.getExteriorType().place(this.console, (RegistryKey<World>)this.field_70170_p.func_234923_W_(), this.func_233580_cy_());
            this.console.setCurrentLocation((RegistryKey<World>)this.field_70170_p.func_234923_W_(), this.func_233580_cy_());
            this.console.setEntity(null);
        }
        this.hasLanded = true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public AbstractExterior getExterior() {
        if (this.exterior == null) {
            this.exterior = ExteriorRegistry.getExterior(new ResourceLocation((String)this.func_184212_Q().func_187225_a(EXTERIOR)));
        }
        return this.exterior;
    }

    public void onFallOutOfWorld() {
        for (String id : (List)TConfig.SERVER.dimsToHandleTardisVoidTeleport.get()) {
            ResourceLocation rl = new ResourceLocation(id);
            RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)rl);
            if (this.field_70170_p.func_234923_W_() != worldKey) continue;
            ChunkPos cPos = new ChunkPos(this.func_233580_cy_());
            ServerWorld destWorld = this.field_70170_p.func_73046_m().func_71218_a(World.field_234918_g_);
            WorldHelper.forceChunkIfNotLoaded(destWorld, cPos, this.func_233580_cy_());
            WorldHelper.teleportEntities(this, destWorld, this.func_226277_ct_(), this.field_70170_p.func_217301_I(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            WorldHelper.unForceChunkIfLoaded(destWorld, cPos, this.func_233580_cy_());
        }
        this.func_70107_b(this.func_226277_ct_(), this.field_70170_p.func_217301_I(), this.func_226281_cx_());
        this.func_213317_d(Vector3d.field_186680_a);
        if (this.getConsole() != null) {
            this.console.getInteriorManager().soundAlarm(AlarmType.LOW);
            ArrayList<String> list = new ArrayList<String>();
            list.add(new TranslationTextComponent("text.tardis.fall_below_world.line1").getString());
            list.add(new TranslationTextComponent("text.tardis.fall_below_world.line2").getString());
            list.add(new TranslationTextComponent("text.tardis.fall_below_world.line3").getString());
            this.console.getInteriorManager().setMonitorOverrides(new MonitorOverride(this.console, 100, list));
            this.console.setCurrentLocation((RegistryKey<World>)this.field_70170_p.func_234923_W_(), this.func_233580_cy_());
        }
    }

    @Nullable
    public ExteriorTile getExteriorTile() {
        if (this.tile == null) {
            this.readExteriorFromData((CompoundNBT)this.func_184212_Q().func_187225_a(EXTERIOR_DATA));
        }
        return this.tile;
    }

    public void setExteriorTile(ExteriorTile tile) {
        this.tile = tile;
        this.field_70180_af.func_187227_b(EXTERIOR_DATA, (Object)tile.serializeNBT());
    }

    public ConsoleTile getConsole() {
        return this.console;
    }

    public Entity func_241206_a_(ServerWorld destination) {
        return super.func_241206_a_(destination);
    }

    public void setConsole(ConsoleTile tile) {
        this.console = tile;
        this.exterior = tile.getExteriorType();
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(EXTERIOR, (Object)this.exterior.getRegistryName().toString());
        }
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }
}

