/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.tileentities.exteriors.ExteriorTile;

public class TardisDisplayEntity
extends Entity {
    public static final DataParameter<String> EXTERIOR = EntityDataManager.func_187226_a(TardisDisplayEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private ExteriorTile tile;
    private int ticksUntilDeath = 100;
    private float friction = 0.97f;

    public TardisDisplayEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        this.func_184224_h(true);
        this.field_70145_X = true;
    }

    public TardisDisplayEntity(World worldIn) {
        this((EntityType)TEntities.DISPLAY_TARDIS.get(), worldIn);
    }

    public TardisDisplayEntity setTile(ExteriorTile tile) {
        this.tile = tile;
        this.func_184212_Q().func_187227_b(EXTERIOR, (Object)tile.func_200662_C().getRegistryName().toString());
        return this;
    }

    public void setTicksUntilDeath(int death) {
        this.ticksUntilDeath = death;
    }

    public int getTicksUntilDeath() {
        return this.ticksUntilDeath;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(EXTERIOR, (Object)"");
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.func_184212_Q().func_187227_b(EXTERIOR, (Object)compound.func_74779_i("exterior"));
        this.friction = compound.func_74760_g("friction");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("exterior", (String)this.func_184212_Q().func_187225_a(EXTERIOR));
        compound.func_74776_a("friction", this.friction);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70145_X = true;
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a((double)this.friction));
        if (!this.field_70170_p.field_72995_K) {
            --this.ticksUntilDeath;
            if (this.ticksUntilDeath <= 0) {
                this.func_70106_y();
            }
        }
    }

    public ExteriorTile getTile() {
        TileEntityType type;
        if (this.tile == null && (type = (TileEntityType)ForgeRegistries.TILE_ENTITIES.getValue(new ResourceLocation((String)this.func_184212_Q().func_187225_a(EXTERIOR)))) != null) {
            this.tile = (ExteriorTile)type.func_200968_a();
            this.tile.func_226984_a_(this.field_70170_p, this.tile.func_174877_v());
        }
        return this.tile;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }
}

