/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tardis.mod.entity.TEntities;
import net.tardis.mod.helper.TardisHelper;
import net.tardis.mod.helper.WorldHelper;

public class TardisBackdoorEntity
extends Entity {
    private RegistryKey<World> interiorWorldKey;
    private int activatedTicks = 0;

    public TardisBackdoorEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public TardisBackdoorEntity(World worldIn) {
        super((EntityType)TEntities.TARDIS_BACKDOOR.get(), worldIn);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.interiorWorldKey = WorldHelper.getWorldKeyFromRL(new ResourceLocation(compound.func_74779_i("interior_world_key")));
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.interiorWorldKey != null) {
            compound.func_74778_a("interior_world_key", this.interiorWorldKey.func_240901_a_().toString());
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void moveThroughPortal(Entity entity) {
        if (!this.field_70170_p.func_201670_d() && entity.func_200600_R() != TEntities.TARDIS_BACKDOOR.get() && this.interiorWorldKey != null) {
            if (this.activatedTicks <= 0) {
                this.activatedTicks = 60;
            }
            this.field_70170_p.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                WorldHelper.teleportEntities(entity, this.field_70170_p.func_73046_m().func_71218_a(this.interiorWorldKey), TardisHelper.TARDIS_POS.func_177984_a(), entity.field_70177_z, entity.field_70125_A);
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        for (Entity e : this.field_70170_p.func_217357_a(Entity.class, this.func_174813_aQ())) {
            if (!e.func_70089_S() || e == this) continue;
            this.moveThroughPortal(e);
        }
        if (this.activatedTicks > 0) {
            --this.activatedTicks;
            if (this.activatedTicks == 0) {
                this.func_70106_y();
            }
        }
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn);
    }

    public RegistryKey<World> getInteriorWorldKey() {
        return this.interiorWorldKey;
    }

    public void setInteriorWorldKey(RegistryKey<World> interiorWorldKey) {
        this.interiorWorldKey = interiorWorldKey;
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source);
    }

    public boolean func_180427_aV() {
        return true;
    }
}

