/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tardis.mod.entity.BessieEntity;
import net.tardis.mod.entity.ChairEntity;
import net.tardis.mod.entity.ControlEntity;
import net.tardis.mod.entity.DoorEntity;
import net.tardis.mod.entity.HoloPilotEntity;
import net.tardis.mod.entity.SecDroidEntity;
import net.tardis.mod.entity.TardisBackdoorEntity;
import net.tardis.mod.entity.TardisDisplayEntity;
import net.tardis.mod.entity.TardisEntity;
import net.tardis.mod.entity.hostile.dalek.DalekEntity;
import net.tardis.mod.entity.humanoid.CompanionEntity;
import net.tardis.mod.entity.humanoid.CrewmateEntity;
import net.tardis.mod.entity.humanoid.ShipCaptainEntity;
import net.tardis.mod.entity.projectiles.LaserEntity;

public class TEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"tardis");
    public static final RegistryObject<EntityType<ControlEntity>> CONTROL = ENTITIES.register("control", () -> TEntities.registerStatic(ControlEntity::new, ControlEntity::new, EntityClassification.MISC, 1.0f, 1.0f, "control"));
    public static final RegistryObject<EntityType<DoorEntity>> DOOR = ENTITIES.register("interior_door", () -> TEntities.registerStatic(DoorEntity::new, DoorEntity::new, EntityClassification.MISC, 1.0f, 2.0f, "interior_door"));
    public static final RegistryObject<EntityType<ChairEntity>> CHAIR = ENTITIES.register("chair", () -> TEntities.registerStatic(ChairEntity::new, ChairEntity::new, EntityClassification.MISC, 1.0f, 1.0f, "chair"));
    public static final RegistryObject<EntityType<TardisEntity>> TARDIS = ENTITIES.register("tardis", () -> TEntities.registerBase(TardisEntity::new, TardisEntity::new, EntityClassification.MISC, 1.0f, 2.0f, 64, 1, true, "tardis"));
    public static final RegistryObject<EntityType<HoloPilotEntity>> HOLO_PILOT = ENTITIES.register("holo_pilot", () -> TEntities.registerStatic(HoloPilotEntity::new, HoloPilotEntity::new, EntityClassification.CREATURE, 0.75f, 1.75f, "holo_pilot"));
    public static final RegistryObject<EntityType<SecDroidEntity>> SECURITY_DROID = ENTITIES.register("security_drone", () -> TEntities.registerBase(SecDroidEntity::new, SecDroidEntity::new, EntityClassification.CREATURE, 0.8f, 0.8f, 64, 1, false, "security_drone"));
    public static final RegistryObject<EntityType<LaserEntity>> LASER = ENTITIES.register("laser", () -> TEntities.registerNoSpawnerBase(LaserEntity::new, EntityClassification.MISC, 0.25f, 0.25f, 128, 1, true, "laser"));
    public static final RegistryObject<EntityType<BessieEntity>> BESSIE = ENTITIES.register("bessie", () -> TEntities.registerFireResistantMob(BessieEntity::new, BessieEntity::new, EntityClassification.MISC, 1.5f, 1.0f, "bessie", false));
    public static final RegistryObject<EntityType<TardisDisplayEntity>> DISPLAY_TARDIS = ENTITIES.register("display_tardis", () -> TEntities.registerBase(TardisDisplayEntity::new, TardisDisplayEntity::new, EntityClassification.MISC, 0.75f, 2.5f, 64, 1, true, "display_tardis"));
    public static final RegistryObject<EntityType<ShipCaptainEntity>> SHIP_CAPTAIN = ENTITIES.register("ship_captain", () -> TEntities.registerFireResistantMob(ShipCaptainEntity::new, ShipCaptainEntity::new, EntityClassification.CREATURE, 0.8f, 1.7f, "ship_captain", false));
    public static final RegistryObject<EntityType<CrewmateEntity>> CREWMATE = ENTITIES.register("crewmate", () -> TEntities.registerFireResistantMob(CrewmateEntity::new, CrewmateEntity::new, EntityClassification.CREATURE, 0.8f, 1.7f, "crewmate", false));
    public static final RegistryObject<EntityType<CompanionEntity>> COMPANION = ENTITIES.register("companion", () -> TEntities.registerFireResistantMob(CompanionEntity::new, CompanionEntity::new, EntityClassification.CREATURE, 0.8f, 1.7f, "companion", false));
    public static final RegistryObject<EntityType<DalekEntity>> DALEK = ENTITIES.register("dalek", () -> TEntities.registerFireResistantMob(DalekEntity::new, DalekEntity::new, EntityClassification.MONSTER, 1.0f, 1.75f, "dalek", false));
    public static final RegistryObject<EntityType<TardisBackdoorEntity>> TARDIS_BACKDOOR = ENTITIES.register("tardis_backdoor", () -> TEntities.registerNoSpawnerImmuneToFire(TardisBackdoorEntity::new, EntityClassification.MISC, 1.0f, 2.0f, 32, 1, false, "tardis_backdoor"));

    private static <T extends Entity> EntityType<T> registerNoSpawnerBase(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("tardis", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerNoSpawnerImmuneToFire(EntityType.IFactory<T> factory, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("tardis", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        builder.func_220320_c();
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerBase(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("tardis", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220321_a(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((World)world));
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerFireResistantBase(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, int trackingRange, int updateFreq, boolean sendUpdate, String name) {
        ResourceLocation loc = new ResourceLocation("tardis", name);
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setShouldReceiveVelocityUpdates(sendUpdate);
        builder.setTrackingRange(trackingRange);
        builder.setUpdateInterval(updateFreq);
        builder.func_220320_c();
        builder.func_220321_a(width, height);
        builder.setCustomClientFactory((spawnEntity, world) -> (Entity)client.spawn((World)world));
        return builder.func_206830_a(loc.toString());
    }

    private static <T extends Entity> EntityType<T> registerStatic(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name) {
        return TEntities.registerBase(factory, client, classification, width, height, 64, 40, false, name);
    }

    private static <T extends Entity> EntityType<T> registerMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity) {
        return TEntities.registerBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    private static <T extends Entity> EntityType<T> registerFireResistantMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity) {
        return TEntities.registerFireResistantBase(factory, client, classification, width, height, 80, 3, velocity, name);
    }

    private static <T extends Entity> EntityType<T> registerMob(EntityType.IFactory<T> factory, IClientSpawner<T> client, EntityClassification classification, float width, float height, String name, boolean velocity, int trackingRange, int updateFreq) {
        return TEntities.registerBase(factory, client, classification, width, height, trackingRange, updateFreq, velocity, name);
    }

    public static interface IClientSpawner<T> {
        public T spawn(World var1);
    }
}

